/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.spatial.assembler;

import java.io.File;
import java.io.IOException;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.query.spatial.EntityDefinition;
import org.apache.jena.query.spatial.SpatialDatasetFactory;
import org.apache.jena.query.spatial.SpatialIndex;
import org.apache.jena.query.spatial.SpatialIndexException;
import org.apache.jena.query.spatial.assembler.SpatialVocab;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.apache.lucene.store.BaseDirectory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;

public class SpatialIndexLuceneAssembler
extends AssemblerBase {
    @Override
    public SpatialIndex open(Assembler a, Resource root2, Mode mode) {
        try {
            BaseDirectory directory;
            if (!GraphUtils.exactlyOneProperty(root2, SpatialVocab.pDirectory)) {
                throw new SpatialIndexException("No 'spatial:directory' property on " + root2);
            }
            RDFNode n = root2.getProperty(SpatialVocab.pDirectory).getObject();
            if (n.isLiteral()) {
                if (!"mem".equals(n.asLiteral().getLexicalForm())) {
                    throw new SpatialIndexException("No 'spatial:directory' property on " + root2 + " is a literal and not \"mem\"");
                }
                directory = new RAMDirectory();
            } else {
                Resource x = n.asResource();
                String path = IRILib.IRIToFilename(x.getURI());
                File dir = new File(path);
                directory = FSDirectory.open(dir.toPath());
            }
            Resource r = GraphUtils.getResourceValue(root2, SpatialVocab.pDefinition);
            EntityDefinition docDef = (EntityDefinition)a.open(r);
            return SpatialDatasetFactory.createLuceneIndex(directory, docDef);
        }
        catch (IOException e2) {
            IO.exception(e2);
            return null;
        }
    }
}

