/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text;

import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.text.DatasetGraphText;
import org.apache.jena.query.text.EntityDefinition;
import org.apache.jena.query.text.TextDocProducer;
import org.apache.jena.query.text.TextDocProducerTriples;
import org.apache.jena.query.text.TextIndex;
import org.apache.jena.query.text.TextIndexConfig;
import org.apache.jena.query.text.TextIndexLucene;
import org.apache.jena.query.text.TextQuery;
import org.apache.jena.query.text.assembler.TextVocab;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.system.JenaSystem;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.store.Directory;

public class TextDatasetFactory {
    public static Dataset create(String assemblerFile) {
        return (Dataset)AssemblerUtils.build(assemblerFile, TextVocab.textDataset);
    }

    public static Dataset create(Dataset base, TextIndex textIndex) {
        return TextDatasetFactory.create(base, textIndex, false);
    }

    public static Dataset create(Dataset base, TextIndex textIndex, boolean closeIndexOnDSGClose) {
        DatasetGraph dsg = base.asDatasetGraph();
        dsg = TextDatasetFactory.create(dsg, textIndex, closeIndexOnDSGClose);
        return DatasetFactory.wrap(dsg);
    }

    public static Dataset create(Dataset base, TextIndex textIndex, boolean closeIndexOnDSGClose, TextDocProducer producer) {
        DatasetGraph dsg = base.asDatasetGraph();
        dsg = TextDatasetFactory.create(dsg, textIndex, closeIndexOnDSGClose, producer);
        return DatasetFactory.wrap(dsg);
    }

    public static DatasetGraph create(DatasetGraph dsg, TextIndex textIndex) {
        return TextDatasetFactory.create(dsg, textIndex, false);
    }

    public static DatasetGraph create(DatasetGraph dsg, TextIndex textIndex, boolean closeIndexOnDSGClose) {
        return TextDatasetFactory.create(dsg, textIndex, closeIndexOnDSGClose, null);
    }

    public static DatasetGraph create(DatasetGraph dsg, TextIndex textIndex, boolean closeIndexOnDSGClose, TextDocProducer producer) {
        if (producer == null) {
            producer = new TextDocProducerTriples(textIndex);
        }
        DatasetGraphText dsgt = new DatasetGraphText(dsg, textIndex, producer, closeIndexOnDSGClose);
        Context c = dsgt.getContext();
        c.set(TextQuery.textIndex, textIndex);
        return dsgt;
    }

    public static TextIndex createLuceneIndex(Directory directory, EntityDefinition def, Analyzer queryAnalyzer) {
        TextIndexConfig config = new TextIndexConfig(def);
        config.setQueryAnalyzer(queryAnalyzer);
        return TextDatasetFactory.createLuceneIndex(directory, config);
    }

    public static TextIndex createLuceneIndex(Directory directory, TextIndexConfig config) {
        return new TextIndexLucene(directory, config);
    }

    public static Dataset createLucene(Dataset base, Directory directory, EntityDefinition def, Analyzer queryAnalyzer) {
        TextIndexConfig config = new TextIndexConfig(def);
        config.setQueryAnalyzer(queryAnalyzer);
        return TextDatasetFactory.createLucene(base, directory, config);
    }

    public static Dataset createLucene(Dataset base, Directory directory, TextIndexConfig config) {
        TextIndex index = TextDatasetFactory.createLuceneIndex(directory, config);
        return TextDatasetFactory.create(base, index, true);
    }

    public static DatasetGraph createLucene(DatasetGraph base, Directory directory, EntityDefinition def, Analyzer queryAnalyzer) {
        TextIndexConfig config = new TextIndexConfig(def);
        config.setQueryAnalyzer(queryAnalyzer);
        return TextDatasetFactory.createLucene(base, directory, config);
    }

    public static DatasetGraph createLucene(DatasetGraph base, Directory directory, TextIndexConfig config) {
        TextIndex index = TextDatasetFactory.createLuceneIndex(directory, config);
        return TextDatasetFactory.create(base, index, true);
    }

    static {
        JenaSystem.init();
    }
}

