/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text.assembler;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.ext.com.google.common.collect.HashMultimap;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.query.text.EntityDefinition;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.assembler.TextVocab;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDF;
import org.apache.lucene.analysis.Analyzer;

public class EntityDefinitionAssembler
extends AssemblerBase
implements Assembler {
    @Override
    public EntityDefinition open(Assembler a, Resource root2, Mode mode) {
        Collection c;
        String prologue = "PREFIX : <http://jena.apache.org/text#>   PREFIX list: <http://jena.apache.org/ARQ/list#> ";
        Model model = root2.getModel();
        String qs1 = StrUtils.strjoinNL(prologue, "SELECT * {", "  ?eMap  :entityField  ?entityField ;", "         :map ?map ;", "         :defaultField ?dftField .", "  OPTIONAL {", "    ?eMap :graphField ?graphField", "  }", "  OPTIONAL {", "    ?eMap :langField ?langField", "  }", "  OPTIONAL {", "    ?eMap :uidField ?uidField", "  }", "}");
        ParameterizedSparqlString pss = new ParameterizedSparqlString(qs1);
        pss.setIri("eMap", root2.getURI());
        Query query1 = QueryFactory.create(pss.toString());
        QueryExecution qexec1 = QueryExecutionFactory.create(query1, model);
        ResultSet rs1 = qexec1.execSelect();
        List<QuerySolution> results = ResultSetFormatter.toList(rs1);
        if (results.size() == 0) {
            Log.warn(this, "Failed to find a valid EntityMap for : " + root2);
            throw new TextIndexException("Failed to find a valid EntityMap for : " + root2);
        }
        if (results.size() != 1) {
            Log.warn(this, "Multiple matches for EntityMap for : " + root2);
            throw new TextIndexException("Multiple matches for EntityMap for : " + root2);
        }
        QuerySolution qsol1 = results.get(0);
        String entityField = qsol1.getLiteral("entityField").getLexicalForm();
        String graphField = qsol1.contains("graphField") ? qsol1.getLiteral("graphField").getLexicalForm() : null;
        String langField = qsol1.contains("langField") ? qsol1.getLiteral("langField").getLexicalForm() : null;
        String defaultField = qsol1.contains("dftField") ? qsol1.getLiteral("dftField").getLexicalForm() : null;
        String uniqueIdField = qsol1.contains("uidField") ? qsol1.getLiteral("uidField").getLexicalForm() : null;
        HashMultimap<String, Node> mapDefs = HashMultimap.create();
        HashMap<String, Analyzer> analyzerDefs = new HashMap<String, Analyzer>();
        Statement listStmt = root2.getProperty(TextVocab.pMap);
        while (listStmt != null) {
            RDFNode n = listStmt.getObject();
            if (!n.isResource()) {
                throw new TextIndexException("Text list node is not a resource : " + n);
            }
            Resource listResource = n.asResource();
            if (listResource.equals(RDF.nil)) break;
            Statement listEntryStmt = listResource.getProperty(RDF.first);
            if (listEntryStmt == null) {
                throw new TextIndexException("Text map list is not well formed.  No rdf:first property");
            }
            n = listEntryStmt.getObject();
            if (!n.isResource()) {
                throw new TextIndexException("Text map list entry is not a resource : " + n);
            }
            Resource listEntry = n.asResource();
            Statement fieldStatement = listEntry.getProperty(TextVocab.pField);
            if (fieldStatement == null) {
                throw new TextIndexException("Text map entry has no field property");
            }
            n = fieldStatement.getObject();
            if (!n.isLiteral()) {
                throw new TextIndexException("Text map entry field property has no literal value : " + n);
            }
            String field = n.asLiteral().getLexicalForm();
            Statement predicateStatement = listEntry.getProperty(TextVocab.pPredicate);
            if (predicateStatement == null) {
                throw new TextIndexException("Text map entry has no predicate property");
            }
            n = predicateStatement.getObject();
            if (!n.isURIResource()) {
                throw new TextIndexException("Text map entry predicate property has non resource value : " + n);
            }
            mapDefs.put(field, n.asNode());
            Statement analyzerStatement = listEntry.getProperty(TextVocab.pAnalyzer);
            if (analyzerStatement != null) {
                n = analyzerStatement.getObject();
                if (!n.isResource()) {
                    throw new TextIndexException("Text map entry analyzer property is not a resource : " + n);
                }
                Resource analyzerResource = n.asResource();
                Analyzer analyzer = (Analyzer)a.open(analyzerResource);
                analyzerDefs.put(field, analyzer);
            }
            listStmt = listResource.getProperty(RDF.rest);
        }
        if (defaultField != null && (c = mapDefs.get(defaultField)).isEmpty()) {
            throw new TextIndexException("No definition of primary field '" + defaultField + "'");
        }
        EntityDefinition docDef = new EntityDefinition(entityField, defaultField);
        docDef.setGraphField(graphField);
        docDef.setLangField(langField);
        docDef.setUidField(uniqueIdField);
        for (String f : mapDefs.keys()) {
            for (Node p : mapDefs.get(f)) {
                docDef.set(f, p);
            }
        }
        for (String f : analyzerDefs.keySet()) {
            docDef.setAnalyzer(f, (Analyzer)analyzerDefs.get(f));
        }
        return docDef;
    }
}

