/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfconnection;

import java.util.function.Consumer;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdfconnection.JenaConnectionException;
import org.apache.jena.rdfconnection.RDFDatasetConnection;
import org.apache.jena.rdfconnection.SparqlQueryConnection;
import org.apache.jena.rdfconnection.SparqlUpdateConnection;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.system.Txn;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;

public interface RDFConnection
extends SparqlQueryConnection,
SparqlUpdateConnection,
RDFDatasetConnection,
Transactional,
AutoCloseable {
    @Override
    default public void queryResultSet(String query2, Consumer<ResultSet> resultSetAction) {
        this.queryResultSet(QueryFactory.create(query2), resultSetAction);
    }

    @Override
    default public void queryResultSet(Query query2, Consumer<ResultSet> resultSetAction) {
        if (!query2.isSelectType()) {
            throw new JenaConnectionException("Query is not a SELECT query");
        }
        Txn.executeRead(this, () -> {
            try (QueryExecution qExec = this.query(query2);){
                ResultSet rs = qExec.execSelect();
                resultSetAction.accept(rs);
            }
        });
    }

    @Override
    default public void querySelect(String query2, Consumer<QuerySolution> rowAction) {
        Txn.executeRead(this, () -> {
            try (QueryExecution qExec = this.query(query2);){
                qExec.execSelect().forEachRemaining(rowAction);
            }
        });
    }

    @Override
    default public void querySelect(Query query2, Consumer<QuerySolution> rowAction) {
        if (!query2.isSelectType()) {
            throw new JenaConnectionException("Query is not a SELECT query");
        }
        Txn.executeRead(this, () -> {
            try (QueryExecution qExec = this.query(query2);){
                qExec.execSelect().forEachRemaining(rowAction);
            }
        });
    }

    @Override
    default public Model queryConstruct(String query2) {
        return this.queryConstruct(QueryFactory.create(query2));
    }

    @Override
    default public Model queryConstruct(Query query2) {
        return Txn.calculateRead(this, () -> {
            try (QueryExecution qExec = this.query(query2);){
                Model model = qExec.execConstruct();
                return model;
            }
        });
    }

    @Override
    default public Model queryDescribe(String query2) {
        return this.queryDescribe(QueryFactory.create(query2));
    }

    @Override
    default public Model queryDescribe(Query query2) {
        return Txn.calculateRead(this, () -> {
            try (QueryExecution qExec = this.query(query2);){
                Model model = qExec.execDescribe();
                return model;
            }
        });
    }

    @Override
    default public boolean queryAsk(String query2) {
        return this.queryAsk(QueryFactory.create(query2));
    }

    @Override
    default public boolean queryAsk(Query query2) {
        return Txn.calculateRead(this, () -> {
            try (QueryExecution qExec = this.query(query2);){
                Boolean bl = qExec.execAsk();
                return bl;
            }
        });
    }

    @Override
    public QueryExecution query(Query var1);

    @Override
    default public QueryExecution query(String queryString) {
        return this.query(QueryFactory.create(queryString));
    }

    @Override
    default public void update(Update update2) {
        this.update(new UpdateRequest(update2));
    }

    @Override
    public void update(UpdateRequest var1);

    @Override
    default public void update(String updateString) {
        this.update(UpdateFactory.create(updateString));
    }

    @Override
    public void load(String var1, String var2);

    @Override
    public void load(String var1);

    @Override
    public void load(String var1, Model var2);

    @Override
    public void load(Model var1);

    @Override
    public void put(String var1, String var2);

    @Override
    public void put(String var1);

    @Override
    public void put(String var1, Model var2);

    @Override
    public void put(Model var1);

    @Override
    public void delete(String var1);

    @Override
    public void delete();

    @Override
    public void loadDataset(String var1);

    @Override
    public void loadDataset(Dataset var1);

    @Override
    public void putDataset(String var1);

    @Override
    public void putDataset(Dataset var1);

    @Override
    public boolean isClosed();

    @Override
    public void close();
}

