/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfconnection;

import org.apache.jena.query.Dataset;
import org.apache.jena.rdfconnection.Isolation;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionFuseki;
import org.apache.jena.rdfconnection.RDFConnectionLocal;
import org.apache.jena.rdfconnection.RDFConnectionRemote;
import org.apache.jena.system.JenaSystem;

public class RDFConnectionFactory {
    public static RDFConnection connect(String destination) {
        return RDFConnectionRemote.create().destination(destination).build();
    }

    public static RDFConnection connect(String queryServiceEndpoint, String updateServiceEndpoint, String graphStoreProtocolEndpoint) {
        return RDFConnectionRemote.create().queryEndpoint(queryServiceEndpoint).updateEndpoint(updateServiceEndpoint).gspEndpoint(graphStoreProtocolEndpoint).build();
    }

    public static RDFConnection connect(String datasetURL, String queryServiceEndpoint, String updateServiceEndpoint, String graphStoreProtocolEndpoint) {
        return RDFConnectionRemote.create().destination(datasetURL).queryEndpoint(queryServiceEndpoint).updateEndpoint(updateServiceEndpoint).gspEndpoint(graphStoreProtocolEndpoint).build();
    }

    public static RDFConnection connect(Dataset dataset) {
        return new RDFConnectionLocal(dataset);
    }

    public static RDFConnection connect(Dataset dataset, Isolation isolation) {
        return new RDFConnectionLocal(dataset, isolation);
    }

    public static RDFConnectionFuseki connectFuseki(String destination) {
        return (RDFConnectionFuseki)RDFConnectionFuseki.create().destination(destination).build();
    }

    public static RDFConnectionFuseki connectFuseki(String datasetURL, String queryServiceEndpoint, String updateServiceEndpoint, String graphStoreProtocolEndpoint) {
        return (RDFConnectionFuseki)RDFConnectionFuseki.create().destination(datasetURL).queryEndpoint(queryServiceEndpoint).updateEndpoint(updateServiceEndpoint).gspEndpoint(graphStoreProtocolEndpoint).build();
    }

    static {
        JenaSystem.init();
    }
}

