/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys;

import java.util.List;
import org.apache.jena.graph.Capabilities;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.reasoner.BaseInfGraph;
import org.apache.jena.reasoner.IllegalParameterException;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.ReasonerException;
import org.apache.jena.reasoner.ReasonerFactory;
import org.apache.jena.reasoner.rulesys.LPBackwardRuleInfGraph;
import org.apache.jena.reasoner.rulesys.Rule;
import org.apache.jena.reasoner.rulesys.impl.LPRuleStore;
import org.apache.jena.vocabulary.ReasonerVocabulary;

public class LPBackwardRuleReasoner
implements Reasoner {
    protected ReasonerFactory factory;
    protected List<Rule> rules;
    protected LPRuleStore ruleStore;
    protected Graph schemaGraph;
    protected boolean recordDerivations = false;
    boolean traceOn = false;
    protected Capabilities capabilities;

    public LPBackwardRuleReasoner(List<Rule> rules) {
        this.rules = rules;
        this.ruleStore = new LPRuleStore(rules);
    }

    public LPBackwardRuleReasoner(List<Rule> rules, ReasonerFactory factory) {
        this.rules = rules;
        this.factory = factory;
        this.ruleStore = new LPRuleStore(rules);
    }

    protected LPBackwardRuleReasoner(LPBackwardRuleReasoner parent, Graph schemaGraph) {
        this.rules = parent.rules;
        this.ruleStore = parent.ruleStore;
        this.schemaGraph = schemaGraph;
        this.factory = parent.factory;
    }

    @Override
    public Model getReasonerCapabilities() {
        if (this.factory != null) {
            return this.factory.getCapabilities();
        }
        return null;
    }

    @Override
    public void addDescription(Model configSpec, Resource base) {
    }

    public synchronized void tablePredicate(Node predicate) {
        this.ruleStore.tablePredicate(predicate);
    }

    @Override
    public boolean supportsProperty(Property property) {
        if (this.factory == null) {
            return false;
        }
        Model caps = this.factory.getCapabilities();
        Resource root2 = caps.getResource(this.factory.getURI());
        return caps.contains(root2, ReasonerVocabulary.supportsP, property);
    }

    @Override
    public Reasoner bindSchema(Graph tbox) throws ReasonerException {
        return new LPBackwardRuleReasoner(this, tbox);
    }

    @Override
    public Reasoner bindSchema(Model tbox) throws ReasonerException {
        return new LPBackwardRuleReasoner(this, tbox.getGraph());
    }

    @Override
    public InfGraph bind(Graph data) throws ReasonerException {
        LPBackwardRuleInfGraph graph = new LPBackwardRuleInfGraph(this, this.ruleStore, data, this.schemaGraph);
        graph.setDerivationLogging(this.recordDerivations);
        return graph;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    @Override
    public void setDerivationLogging(boolean logOn) {
        this.recordDerivations = logOn;
    }

    public void setTraceOn(boolean state) {
        this.traceOn = state;
    }

    @Override
    public void setParameter(Property parameter, Object value) {
        throw new IllegalParameterException(parameter.toString());
    }

    @Override
    public Capabilities getGraphCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new BaseInfGraph.InfCapabilities();
        }
        return this.capabilities;
    }
}

