/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.graph;

import java.util.Iterator;
import org.apache.jena.atlas.data.DataBag;
import org.apache.jena.atlas.data.ThresholdPolicy;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Capabilities;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.TripleStore;
import org.apache.jena.mem.GraphMemBase;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public abstract class GraphDataBag
extends GraphMemBase {
    private final ThresholdPolicy<Triple> thresholdPolicy;
    private DataBag<Triple> db;

    public GraphDataBag(ThresholdPolicy<Triple> thresholdPolicy) {
        this.thresholdPolicy = thresholdPolicy;
        this.capabilities = new Capabilities(){

            @Override
            public boolean sizeAccurate() {
                return false;
            }

            @Override
            public boolean addAllowed() {
                return this.addAllowed(false);
            }

            @Override
            public boolean addAllowed(boolean every) {
                return true;
            }

            @Override
            public boolean deleteAllowed() {
                return this.deleteAllowed(false);
            }

            @Override
            public boolean deleteAllowed(boolean every) {
                return false;
            }

            @Override
            public boolean canBeEmpty() {
                return true;
            }

            @Override
            public boolean iteratorRemoveAllowed() {
                return false;
            }

            @Override
            public boolean findContractSafe() {
                return true;
            }

            @Override
            public boolean handlesLiteralTyping() {
                return true;
            }
        };
        this.db = this.createDataBag();
    }

    protected abstract DataBag<Triple> createDataBag();

    protected ThresholdPolicy<Triple> getThresholdPolicy() {
        return this.thresholdPolicy;
    }

    @Override
    protected TripleStore createTripleStore() {
        return null;
    }

    @Override
    public void performAdd(Triple t) {
        this.db.add(t);
    }

    @Override
    public int graphBaseSize() {
        return (int)this.db.size();
    }

    @Override
    protected void destroy() {
        this.db.close();
    }

    @Override
    public void clear() {
        this.db.close();
        this.db = this.createDataBag();
    }

    @Override
    protected ExtendedIterator<Triple> graphBaseFind(Triple m) {
        Iterator<Triple> iter = Iter.filter(this.db.iterator(), m::matches);
        return WrappedIterator.create(iter);
    }
}

