/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.transaction;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.zip.Adler32;
import org.apache.jena.atlas.iterator.IteratorSlotted;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.tdb.base.block.Block;
import org.apache.jena.tdb.base.file.BufferChannel;
import org.apache.jena.tdb.base.file.BufferChannelFile;
import org.apache.jena.tdb.base.file.BufferChannelMem;
import org.apache.jena.tdb.base.file.Location;
import org.apache.jena.tdb.sys.FileRef;
import org.apache.jena.tdb.transaction.JournalEntry;
import org.apache.jena.tdb.transaction.JournalEntryType;
import org.apache.jena.tdb.transaction.TDBTransactionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Journal
implements Sync,
Closeable {
    private static Logger log = LoggerFactory.getLogger(Journal.class);
    private BufferChannel channel;
    private long position;
    private static int Overhead = 16;
    private static final int NoId = 5;
    private ByteBuffer header = ByteBuffer.allocate(Overhead);
    private static int SizeofCRC = 4;
    private ByteBuffer crcTrailer = ByteBuffer.allocate(SizeofCRC);

    public static boolean exists(Location location) {
        if (location.isMem()) {
            return false;
        }
        return FileOps.exists(Journal.journalFilename(location));
    }

    public static Journal create(Location location) {
        String channelName = Journal.journalFilename(location);
        BufferChannel chan = location.isMem() ? BufferChannelMem.create(channelName) : BufferChannelFile.create(channelName);
        return new Journal(chan);
    }

    private static String journalFilename(Location location) {
        return location.absolute("journal.jrnl");
    }

    public Journal(BufferChannel channel) {
        this.channel = channel;
        this.position = 0L;
    }

    public synchronized long writeJournal(JournalEntry entry) {
        long posn = this.write(entry.getType(), entry.getFileRef(), entry.getBlock());
        if (entry.getPosition() < 0L) {
            entry.setPosition(posn);
            entry.setEndPosition(this.position);
        }
        return posn;
    }

    public synchronized long write(JournalEntryType type, FileRef fileRef, Block block) {
        ByteBuffer buffer = block == null ? null : block.getByteBuffer();
        long posn = this.position;
        int bufferCapacity = 0;
        int len = 0;
        if (buffer != null) {
            bufferCapacity = buffer.capacity();
            len = buffer.remaining();
        }
        this.header.clear();
        this.header.putInt(type.id);
        this.header.putInt(bufferCapacity);
        this.header.putInt(fileRef.getId());
        int blkId = block == null ? 5 : block.getId().intValue();
        this.header.putInt(blkId);
        this.header.flip();
        this.channel.write(this.header);
        Adler32 adler = new Adler32();
        adler.update(this.header.array());
        if (len > 0) {
            int bufferLimit = buffer.limit();
            int bufferPosition = buffer.position();
            buffer.position(0);
            buffer.limit(bufferCapacity);
            for (int i = len; i < bufferCapacity; ++i) {
                buffer.put(i, (byte)0);
            }
            this.channel.write(buffer);
            if (buffer.hasArray()) {
                adler.update(buffer.array());
            } else {
                byte[] data = new byte[bufferCapacity];
                buffer.position(0);
                buffer.limit(bufferCapacity);
                buffer.get(data);
                adler.update(data);
            }
            buffer.position(bufferPosition);
            buffer.limit(bufferLimit);
        }
        this.crcTrailer.clear();
        Bytes.setInt((int)adler.getValue(), this.crcTrailer.array());
        this.channel.write(this.crcTrailer);
        this.position += (long)(Overhead + len + SizeofCRC);
        return posn;
    }

    public synchronized JournalEntry readJournal(long id) {
        return this._readJournal(id);
    }

    private JournalEntry _readJournal(long id) {
        long x = this.channel.position();
        if (x != id) {
            this.channel.position(id);
        }
        JournalEntry entry = this._read();
        long x2 = this.channel.position();
        entry.setPosition(id);
        entry.setEndPosition(x2);
        if (x != id) {
            this.channel.position(x);
        }
        return entry;
    }

    private JournalEntry _read() {
        this.header.clear();
        int lenRead = this.channel.read(this.header);
        if (lenRead == -1) {
            throw new TDBTransactionException("Read off the end of a journal file");
        }
        this.header.rewind();
        int typeId = this.header.getInt();
        int len = this.header.getInt();
        int ref = this.header.getInt();
        int blockId = this.header.getInt();
        Adler32 adler = new Adler32();
        adler.update(this.header.array());
        ByteBuffer bb = ByteBuffer.allocate(len);
        lenRead = this.channel.read(bb);
        if (lenRead != len) {
            throw new TDBTransactionException("Failed to read the journal entry: wanted " + len + " bytes, got " + lenRead);
        }
        adler.update(bb.array());
        bb.rewind();
        this.crcTrailer.clear();
        lenRead = this.channel.read(this.crcTrailer);
        if (lenRead != SizeofCRC) {
            throw new TDBTransactionException("Failed to read block checksum (got " + lenRead + " bytes, not " + SizeofCRC + ").");
        }
        int checksum = Bytes.getInt(this.crcTrailer.array());
        if (checksum != (int)adler.getValue()) {
            throw new TDBTransactionException("Checksum error reading from the Journal.");
        }
        JournalEntryType type = JournalEntryType.type(typeId);
        FileRef fileRef = FileRef.get(ref);
        Block block = new Block(blockId, bb);
        return new JournalEntry(type, fileRef, block);
    }

    public Iterator<JournalEntry> entries() {
        return new IteratorEntries(0L);
    }

    public synchronized Iterator<JournalEntry> entries(long startPosition) {
        return new IteratorEntries(startPosition);
    }

    @Override
    public void sync() {
        this.channel.sync();
    }

    @Override
    public void close() {
        this.channel.close();
    }

    public long size() {
        return this.channel.size();
    }

    public boolean isEmpty() {
        return this.channel.size() == 0L;
    }

    public void truncate(long size) {
        this.channel.truncate(size);
    }

    public void append() {
        this.position(this.size());
    }

    public long position() {
        return this.channel.position();
    }

    public void position(long posn) {
        this.channel.position(posn);
    }

    public String getFilename() {
        return this.channel.getFilename();
    }

    private class IteratorEntries
    extends IteratorSlotted<JournalEntry> {
        JournalEntry slot = null;
        final long endPoint;
        long iterPosn;

        public IteratorEntries(long startPosition) {
            this.iterPosn = startPosition;
            this.endPoint = Journal.this.channel.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected JournalEntry moveToNext() {
            Journal journal = Journal.this;
            synchronized (journal) {
                if (this.iterPosn >= this.endPoint) {
                    return null;
                }
                JournalEntry e2 = Journal.this._readJournal(this.iterPosn);
                this.iterPosn = e2.getEndPosition();
                return e2;
            }
        }

        @Override
        protected boolean hasMore() {
            return this.iterPosn < this.endPoint;
        }
    }
}

