/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.loader;

import org.apache.jena.atlas.lib.ProgressMonitor;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.query.Dataset;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.system.ProgressStreamRDF;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.system.Txn;
import org.apache.jena.tdb2.store.DatasetGraphTDB;
import org.apache.jena.tdb2.sys.TDBInternal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Loader {
    private static Logger LOG = LoggerFactory.getLogger("Loader");

    public static void bulkLoad(Dataset ds, String ... files) {
        ProgressStreamRDF sMonitor;
        DatasetGraphTDB dsg = TDBInternal.getDatasetGraphTDB(ds);
        StreamRDF s1 = StreamRDFLib.dataset(dsg);
        ProgressMonitor plog = ProgressMonitor.create(LOG, "Triples", 100000L, 10);
        ProgressStreamRDF s3 = sMonitor = new ProgressStreamRDF(s1, plog);
        plog.start();
        Txn.executeWrite(ds, () -> {
            for (String fn : files) {
                if (files.length > 1) {
                    FmtLog.info(LOG, "File: %s", fn);
                }
                RDFDataMgr.parse(s3, fn);
            }
        });
        plog.finish();
        plog.finishMessage();
    }
}

