/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store;

import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphWrapper;
import org.apache.jena.sparql.core.DatasetPrefixStorage;
import org.apache.jena.tdb2.store.DatasetGraphTDB;
import org.apache.jena.tdb2.store.GraphViewSwitchable;

public final class DatasetGraphSwitchable
extends DatasetGraphWrapper {
    private final AtomicReference<DatasetGraph> dsgx = new AtomicReference();
    private final Path basePath;
    private final Location location;
    private Graph dftGraph = GraphViewSwitchable.createDefaultGraph(this);
    private Cache<Node, Graph> ngCache = CacheFactory.createOneSlotCache();

    public DatasetGraphSwitchable(Path base, Location location, DatasetGraph dsg) {
        super(null);
        this.dsgx.set(dsg);
        this.basePath = base;
        this.location = location;
    }

    public boolean hasContainerPath() {
        return this.basePath != null;
    }

    public Path getContainerPath() {
        return this.basePath;
    }

    public Location getLocation() {
        return this.location;
    }

    @Override
    public DatasetGraph get() {
        return this.dsgx.get();
    }

    public DatasetGraph set(DatasetGraph dsg) {
        return this.dsgx.getAndSet(dsg);
    }

    public boolean change(DatasetGraph oldDSG, DatasetGraph newDSG) {
        return this.dsgx.compareAndSet(oldDSG, newDSG);
    }

    @Override
    public Graph getDefaultGraph() {
        return this.dftGraph;
    }

    @Override
    public Graph getGraph(Node gn) {
        return this.ngCache.getOrFill(gn, () -> GraphViewSwitchable.createNamedGraph(this, gn));
    }

    private PrefixMapping prefixMapping(final Node graphName) {
        final String gn = graphName == null ? "" : graphName.getURI();
        return new PrefixMappingImpl(){

            DatasetPrefixStorage dps() {
                return ((DatasetGraphTDB)DatasetGraphSwitchable.this.dsgx.get()).getPrefixes();
            }

            Graph graph() {
                DatasetGraphTDB dsg = (DatasetGraphTDB)DatasetGraphSwitchable.this.dsgx.get();
                if (gn == null) {
                    return dsg.getDefaultGraph();
                }
                return dsg.getGraph(graphName);
            }

            PrefixMapping prefixMapping() {
                if (gn == null) {
                    return this.dps().getPrefixMapping();
                }
                return this.dps().getPrefixMapping(gn);
            }

            @Override
            protected void set(String prefix, String uri) {
                this.dps().insertPrefix(gn, prefix, uri);
                super.set(prefix, uri);
            }

            @Override
            protected String get(String prefix) {
                return this.dps().readPrefix(gn, prefix);
            }

            @Override
            protected void remove(String prefix) {
                this.dps().getPrefixMapping().removeNsPrefix(prefix);
                super.remove(prefix);
            }

            @Override
            public Map<String, String> getNsPrefixMap() {
                return this.prefixMapping().getNsPrefixMap();
            }
        };
    }
}

