/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.shared.PrefixMapping;

public class PrefixMappingCache
implements PrefixMapping {
    private final PrefixMapping other;
    private Cache<String, String> prefixToUri = CacheFactory.createCache(100);
    private Cache<String, String> uriToPrefix = CacheFactory.createCache(100);

    public PrefixMappingCache(PrefixMapping other) {
        this.other = other;
    }

    private void add(String prefix, String uri) {
        this.prefixToUri.put(prefix, uri);
        this.uriToPrefix.put(uri, prefix);
    }

    private void remove(String prefix, String uri) {
        this.prefixToUri.remove(prefix);
        this.uriToPrefix.remove(uri);
    }

    private void clear() {
        this.prefixToUri.clear();
        this.uriToPrefix.clear();
    }

    @Override
    public PrefixMapping setNsPrefix(String prefix, String uri) {
        this.other.setNsPrefix(prefix, uri);
        this.add(prefix, uri);
        return this;
    }

    @Override
    public PrefixMapping removeNsPrefix(String prefix) {
        String uri = this.getNsPrefixURI(prefix);
        if (uri != null) {
            this.remove(prefix, uri);
        }
        this.other.removeNsPrefix(prefix);
        return this;
    }

    @Override
    public PrefixMapping clearNsPrefixMap() {
        this.prefixToUri.clear();
        this.uriToPrefix.clear();
        this.other.clearNsPrefixMap();
        return this;
    }

    @Override
    public PrefixMapping setNsPrefixes(PrefixMapping pmap) {
        this.setNsPrefixes(pmap.getNsPrefixMap());
        return this;
    }

    @Override
    public PrefixMapping setNsPrefixes(Map<String, String> map) {
        map.entrySet().forEach(entry -> this.setNsPrefix((String)entry.getKey(), (String)entry.getValue()));
        return this;
    }

    @Override
    public PrefixMapping withDefaultMappings(PrefixMapping map) {
        this.other.withDefaultMappings(map);
        this.clear();
        return this;
    }

    @Override
    public String getNsPrefixURI(String prefix) {
        String x = this.prefixToUri.getIfPresent(prefix);
        if (x == null && (x = this.other.getNsPrefixURI(prefix)) != null) {
            this.prefixToUri.put(prefix, x);
        }
        return x;
    }

    @Override
    public String getNsURIPrefix(String uri) {
        String x = this.uriToPrefix.getIfPresent(uri);
        if (x == null && (x = this.other.getNsURIPrefix(uri)) != null) {
            this.uriToPrefix.put(uri, x);
        }
        return x;
    }

    @Override
    public Map<String, String> getNsPrefixMap() {
        return this.other.getNsPrefixMap();
    }

    @Override
    public String expandPrefix(String prefixed) {
        int colon = prefixed.indexOf(58);
        if (colon < 0) {
            return prefixed;
        }
        String prefix = prefixed.substring(0, colon);
        String uri = this.getNsPrefixURI(prefix);
        return uri == null ? prefixed : uri + prefixed.substring(colon + 1);
    }

    @Override
    public String qnameFor(String uri) {
        int split = Util.splitNamespaceXML(uri);
        String ns = uri.substring(0, split);
        String local = uri.substring(split);
        if (local.equals("")) {
            return null;
        }
        String prefix = this.getNsURIPrefix(ns);
        return prefix == null ? null : prefix + ":" + local;
    }

    @Override
    public String shortForm(String uri) {
        Optional<Map.Entry<String, String>> e2 = this.findMapping(uri, true);
        if (!e2.isPresent()) {
            return uri;
        }
        return e2.get().getKey() + ":" + uri.substring(e2.get().getValue().length());
    }

    private Optional<Map.Entry<String, String>> findMapping(String uri, boolean partial) {
        return ((Stream)this.getNsPrefixMap().entrySet().stream().sequential()).filter(e2 -> {
            String ss = (String)e2.getValue();
            return uri.startsWith(ss) && (partial || ss.length() == uri.length());
        }).findFirst();
    }

    @Override
    public boolean samePrefixMappingAs(PrefixMapping other) {
        return other.samePrefixMappingAs(other);
    }

    @Override
    public PrefixMapping lock() {
        return this;
    }

    @Override
    public boolean hasNoMappings() {
        return this.other.hasNoMappings();
    }

    @Override
    public int numPrefixes() {
        return this.other.numPrefixes();
    }

    private static String str(PrefixMapping pmap) {
        return pmap.getNsPrefixMap().toString();
    }

    public String toString() {
        String x = Iter.iter(this.prefixToUri.keys()).map(k -> k + "->" + this.prefixToUri.getIfPresent((String)k)).asString(", ");
        return "pm cache: [" + this.prefixToUri.size() + "] " + x + " : " + PrefixMappingCache.str(this.other);
    }
}

