/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store.tupletable;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.NullIterator;
import org.apache.jena.atlas.iterator.SingletonIterator;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleMap;
import org.apache.jena.dboe.base.record.Record;
import org.apache.jena.dboe.base.record.RecordFactory;
import org.apache.jena.dboe.index.RangeIndex;
import org.apache.jena.tdb2.TDBException;
import org.apache.jena.tdb2.lib.Async;
import org.apache.jena.tdb2.lib.TupleLib;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.NodeIdFactory;
import org.apache.jena.tdb2.store.tupletable.TupleIndexBase;

public class TupleIndexRecordAsyncBulkAdd
extends TupleIndexBase {
    private static final boolean Check = false;
    private RangeIndex index;
    private RecordFactory factory;
    Async async = new Async(1, 2);
    Object lock = new Object();

    public TupleIndexRecordAsyncBulkAdd(int N, TupleMap tupleMapping, String name, RecordFactory factory, RangeIndex index) {
        super(N, tupleMapping, name);
        this.factory = factory;
        this.index = index;
        if (factory.keyLength() != N * 8) {
            throw new TDBException(String.format("Mismatch: TupleIndex of length %d is not comparative with a factory for key length %d", N, factory.keyLength()));
        }
    }

    @Override
    protected void performAdd(Tuple<NodeId> tuple) {
        this.switchToSync();
        Record r = TupleLib.record(this.factory, tuple, this.tupleMap);
        this.index.insert(r);
    }

    @Override
    protected void performDelete(Tuple<NodeId> tuple) {
        this.switchToSync();
        Record r = TupleLib.record(this.factory, tuple, this.tupleMap);
        this.index.delete(r);
    }

    private void switchToSync() {
        this.async.completeAsyncOperations();
    }

    @Override
    public void addAll(Collection<Tuple<NodeId>> tuples) {
        Object txn = null;
        this.async.execAsync(this.lock, () -> {
            System.out.println(">>Async");
            for (Tuple t : tuples) {
                Record r = TupleLib.record(this.factory, t, this.tupleMap);
                this.index.insert(r);
            }
            System.out.println("<<Async");
        });
    }

    @Override
    public void deleteAll(Collection<Tuple<NodeId>> tuples) {
        tuples.stream().forEach(this::delete);
    }

    @Override
    protected Iterator<Tuple<NodeId>> performFind(Tuple<NodeId> pattern) {
        this.switchToSync();
        return this.findOrScan(pattern);
    }

    final Iterator<Tuple<NodeId>> findOrScan(Tuple<NodeId> pattern) {
        return this.findWorker(pattern, true, true);
    }

    final Iterator<Tuple<NodeId>> findOrPartialScan(Tuple<NodeId> pattern) {
        return this.findWorker(pattern, true, false);
    }

    final Iterator<Tuple<NodeId>> findByIndex(Tuple<NodeId> pattern) {
        return this.findWorker(pattern, false, false);
    }

    private Iterator<Tuple<NodeId>> findWorker(Tuple<NodeId> patternNaturalOrder, boolean partialScanAllowed, boolean fullScanAllowed) {
        NodeId X;
        this.switchToSync();
        Tuple<NodeId> pattern = this.tupleMap.map(patternNaturalOrder);
        int numSlots = 0;
        int leadingIdx = -2;
        boolean leading = true;
        Record minRec = this.factory.createKeyOnly();
        Record maxRec = this.factory.createKeyOnly();
        for (int i = 0; i < pattern.len(); ++i) {
            X = pattern.get(i);
            if (NodeId.isAny(X)) {
                X = null;
                leading = false;
                continue;
            }
            ++numSlots;
            if (!leading) continue;
            leadingIdx = i;
            NodeIdFactory.set(X, minRec.getKey(), i * 8);
            NodeIdFactory.set(X, maxRec.getKey(), i * 8);
        }
        if (numSlots == pattern.len()) {
            if (this.index.contains(minRec)) {
                return new SingletonIterator<Tuple<NodeId>>(pattern);
            }
            return new NullIterator<Tuple<NodeId>>();
        }
        Iterator<Record> iter = null;
        if (leadingIdx < 0) {
            if (!fullScanAllowed) {
                return null;
            }
            iter = this.index.iterator();
        } else {
            X = pattern.get(leadingIdx);
            NodeIdFactory.setNext(X, maxRec.getKey(), leadingIdx * 8);
            iter = this.index.iterator(minRec, maxRec);
        }
        Iterator<Tuple<NodeId>> tuples = Iter.map(iter, item -> TupleLib.tuple(item, this.tupleMap));
        if (leadingIdx < numSlots - 1) {
            if (!partialScanAllowed) {
                return null;
            }
            tuples = this.scan(tuples, patternNaturalOrder);
        }
        return tuples;
    }

    @Override
    public Iterator<Tuple<NodeId>> all() {
        this.switchToSync();
        Iterator<Record> iter = this.index.iterator();
        return Iter.map(iter, item -> TupleLib.tuple(item, this.tupleMap));
    }

    private Iterator<Tuple<NodeId>> scan(Iterator<Tuple<NodeId>> iter, Tuple<NodeId> pattern) {
        Predicate<Tuple> filter = item -> {
            for (int i = 0; i < this.tupleLength; ++i) {
                NodeId n = (NodeId)pattern.get(i);
                if (NodeId.isAny(n) || ((NodeId)item.get(i)).equals(n)) continue;
                return false;
            }
            return true;
        };
        return Iter.filter(iter, filter);
    }

    @Override
    public void close() {
        this.switchToSync();
        this.index.close();
    }

    @Override
    public void sync() {
        this.switchToSync();
        this.index.sync();
    }

    public final RangeIndex getRangeIndex() {
        return this.index;
    }

    @Override
    public boolean isEmpty() {
        this.switchToSync();
        return this.index.isEmpty();
    }

    @Override
    public void clear() {
        this.switchToSync();
        this.index.clear();
    }

    @Override
    public long size() {
        this.switchToSync();
        return this.index.size();
    }
}

