/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.sys;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.dboe.base.file.ProcessFileLock;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.tdb2.TDBException;
import org.apache.jena.tdb2.setup.StoreParams;
import org.apache.jena.tdb2.store.DatasetGraphSwitchable;
import org.apache.jena.tdb2.sys.DatabaseOps;
import org.apache.jena.tdb2.sys.SystemTDB;

public class DatabaseConnection {
    private static Map<Location, DatabaseConnection> cache = new ConcurrentHashMap<Location, DatabaseConnection>();
    private final DatasetGraphSwitchable datasetGraphSwitchable;
    private final DatasetGraph datasetGraph;
    private final Location location;
    private final ProcessFileLock lock;
    private boolean isValid = true;

    public static synchronized DatabaseConnection connectCreate(Location location) {
        return DatabaseConnection.connectCreate(location, null);
    }

    public static synchronized DatabaseConnection connectCreate(Location location, StoreParams params) {
        return DatabaseConnection.make(location, params);
    }

    private static synchronized DatabaseConnection make(Location location, StoreParams params) {
        if (location.isMemUnique()) {
            DatasetGraph dsg = DatabaseOps.create(location);
            DatabaseConnection dbConn = new DatabaseConnection(dsg, location, null);
            return dbConn;
        }
        DatabaseConnection dbConn = cache.computeIfAbsent(location, loc -> DatabaseConnection.buildForCache(loc, params));
        return dbConn;
    }

    private static DatabaseConnection buildForCache(Location location, StoreParams params) {
        if (location.isMemUnique()) {
            throw new TDBException("Can't buildForCache a memory-unique location");
        }
        ProcessFileLock lock = null;
        if (SystemTDB.DiskLocationMultiJvmUsagePrevention && !location.isMem()) {
            lock = DatabaseConnection.lockForLocation(location);
            lock.lockEx();
        }
        DatasetGraph dsg = DatabaseOps.create(location);
        return new DatabaseConnection(dsg, location, lock);
    }

    public static ProcessFileLock lockForLocation(Location location) {
        FileOps.ensureDir(location.getDirectoryPath());
        String lockFilename = location.getPath("tdb.lock");
        Path path = Paths.get(lockFilename, new String[0]);
        try {
            path.toFile().createNewFile();
        }
        catch (IOException ex) {
            IO.exception(ex);
            return null;
        }
        return ProcessFileLock.create(lockFilename);
    }

    public static synchronized void internalExpel(Location location, boolean force) {
        DatabaseConnection dbConn = cache.get(location);
        if (dbConn == null) {
            return;
        }
        dbConn.isValid = false;
        cache.remove(location);
        if (SystemTDB.DiskLocationMultiJvmUsagePrevention && !location.isMem()) {
            if (!dbConn.lock.isLockedHere()) {
                SystemTDB.errlog.warn("Location " + location.getDirectoryPath() + " was not locked by this process.");
            }
            dbConn.lock.unlock();
            ProcessFileLock.release(dbConn.lock);
        }
    }

    public static synchronized void internalReset() {
        HashSet<Location> x = new HashSet<Location>(cache.keySet());
        for (Location loc : x) {
            DatabaseConnection.internalExpel(loc, true);
        }
        if (!cache.isEmpty()) {
            System.err.println("DatabaseConnection: Cache not empty!");
        }
        cache.clear();
    }

    private DatabaseConnection(DatasetGraph dsg, Location location, ProcessFileLock fileLock) {
        this.datasetGraph = dsg;
        this.datasetGraphSwitchable = dsg instanceof DatasetGraphSwitchable ? (DatasetGraphSwitchable)dsg : null;
        this.location = location;
        this.lock = fileLock;
    }

    public DatasetGraph getDatasetGraph() {
        return this.datasetGraph;
    }

    public DatasetGraphSwitchable getDatasetGraphSwitchable() {
        return this.datasetGraphSwitchable;
    }

    public Location getLocation() {
        return this.location;
    }

    public ProcessFileLock getLock() {
        return this.lock;
    }
}

