/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.sys;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.PropertyUtils;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.dboe.base.block.FileMode;
import org.apache.jena.dboe.base.record.RecordFactory;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderLib;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.system.JenaSystem;
import org.apache.jena.tdb2.TDB2;
import org.apache.jena.tdb2.TDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemTDB {
    private static final Logger log;
    public static final Logger syslog;
    public static final Logger errlog;
    public static final int SizeOfNodeId = 8;
    public static final int SizeOfPointer = 4;
    public static final int LenIndexTripleRecord = 24;
    public static final int LenIndexQuadRecord = 32;
    public static final int LenNodeHash = 16;
    public static final RecordFactory indexRecordTripleFactory;
    public static final RecordFactory indexRecordQuadFactory;
    public static final RecordFactory nodeRecordFactory;
    public static final String symbolNamespace1 = "http://jena.hpl.hp.com/TDB#";
    public static final String symbolNamespace2 = "http://jena.apache.org/TDB#";
    public static final String symbolNamespace = "http://jena.apache.org/TDB#";
    public static final String tdbSymbolPrefix = "tdb2";
    public static final String tdbPropertyRoot = "org.apache.jena.tdb";
    public static final Symbol symLogDuplicates;
    public static final Symbol symFileMode;
    public static final Symbol symIndexType;
    public static final Symbol symTupleFilter;
    private static final String propertyFileKey1 = "org.apache.jena.tdb.settings";
    private static final String propertyFileKey2 = "tdb2:settings";
    private static String propertyFileName;
    public static final boolean is64bitSystem;
    private static Properties properties;
    public static final int BlockSize = 8192;
    public static final int BlockSizeTest = 1024;
    public static final int BlockSizeTestMem = 500;
    public static final int OrderMem = 5;
    public static final int SegmentSize = 0x800000;
    public static final int ObjectFileWriteCacheSize = 8192;
    public static final int Node2NodeIdCacheSize;
    public static final int NodeId2NodeCacheSize;
    public static final int NodeMissCacheSize = 1000;
    public static final int BlockWriteCacheSize;
    public static final int BlockReadCacheSize;
    public static ReorderTransformation defaultReorderTransform;
    private static String propertyEnableInlineLiterals1;
    private static String propertyEnableInlineLiterals2;
    public static final boolean enableInlineLiterals;
    public static boolean NullOut;
    public static final byte FillByte = -1;
    public static final boolean Checking = false;
    public static boolean DiskLocationMultiJvmUsagePrevention;
    public static final boolean isWindows;
    private static FileMode fileMode;

    public static void init() {
    }

    public static void panic(Class<?> clazz, String string) {
        Log.error(clazz, string);
        throw new TDBException(string);
    }

    public static Symbol allocSymbol(String shortName) {
        if (shortName.startsWith(tdbSymbolPrefix)) {
            throw new TDBException("Symbol short name begins with the TDB namespace prefix: " + shortName);
        }
        if (shortName.startsWith("http:")) {
            throw new TDBException("Symbol short name begins with http: " + shortName);
        }
        return SystemTDB.allocSymbol("http://jena.apache.org/TDB#", shortName);
    }

    public static Symbol allocSymbol(String namespace2, String shortName) {
        return Symbol.create(namespace2 + shortName);
    }

    private static int intValue(String prefix, String name, int defaultValue) {
        name = !prefix.endsWith(".") ? prefix + "." + name : prefix + name;
        return SystemTDB.intValue(name, defaultValue);
    }

    private static int intValue(String name, int defaultValue) {
        if (name == null) {
            return defaultValue;
        }
        if (name.length() == 0) {
            throw new TDBException("Empty string for value name");
        }
        if (properties == null) {
            return defaultValue;
        }
        String x = properties.getProperty(name);
        if (x == null) {
            return defaultValue;
        }
        TDB2.logInfo.info("Set: " + name + " = " + x);
        int v = Integer.parseInt(x);
        return v;
    }

    private static Properties readPropertiesFile() {
        if (propertyFileName == null) {
            return null;
        }
        Properties p = new Properties();
        try {
            TDB2.logInfo.info("Using properties from '" + propertyFileName + "'");
            PropertyUtils.loadFromFile(p, propertyFileName);
        }
        catch (FileNotFoundException ex) {
            log.debug("No system properties file (" + propertyFileName + ")");
            return null;
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
        return p;
    }

    private static boolean determineIfWindows() {
        String s = System.getProperty("os.name");
        if (s == null) {
            return false;
        }
        return s.startsWith("Windows ");
    }

    private static boolean determineIf64Bit() {
        String s = System.getProperty("sun.arch.data.model");
        if (s != null) {
            boolean b = s.equals("64");
            TDB2.logInfo.debug("System architecture: " + (b ? "64 bit" : "32 bit"));
            return b;
        }
        s = System.getProperty("java.vm.info");
        if (s == null) {
            log.warn("Can't determine the data model");
            return false;
        }
        log.debug("Can't determine the data model from 'sun.arch.data.model' - using java.vm.info");
        boolean b = s.contains("64");
        TDB2.logInfo.debug("System architecture: (from java.vm.info) " + (b ? "64 bit" : "32 bit"));
        return b;
    }

    public static FileMode fileMode() {
        if (fileMode == null) {
            fileMode = SystemTDB.determineFileMode();
        }
        return fileMode;
    }

    public static void setFileMode(FileMode newFileMode) {
        if (fileMode != null) {
            log.warn("System file mode already determined - setting it has no effect");
            return;
        }
        fileMode = newFileMode;
    }

    static void internalSetFileMode(FileMode newFileMode) {
        fileMode = newFileMode;
    }

    private static FileMode determineFileMode() {
        String x = ARQ.getContext().getAsString(symFileMode, "default");
        if (x.equalsIgnoreCase("direct")) {
            TDB2.logInfo.info("File mode: direct (forced)");
            return FileMode.direct;
        }
        if (x.equalsIgnoreCase("mapped")) {
            TDB2.logInfo.info("File mode: mapped (forced)");
            return FileMode.mapped;
        }
        if (x.equalsIgnoreCase("default")) {
            if (is64bitSystem) {
                TDB2.logInfo.debug("File mode: Mapped");
                return FileMode.mapped;
            }
            TDB2.logInfo.debug("File mode: Direct");
            return FileMode.direct;
        }
        throw new TDBException("Unrecognized file mode (not one of 'default', 'direct' or 'mapped': " + x);
    }

    static {
        JenaSystem.init();
        log = LoggerFactory.getLogger(TDB2.class);
        syslog = LoggerFactory.getLogger("TDB");
        errlog = LoggerFactory.getLogger("TDB");
        indexRecordTripleFactory = new RecordFactory(24, 0);
        indexRecordQuadFactory = new RecordFactory(32, 0);
        nodeRecordFactory = new RecordFactory(16, 8);
        symLogDuplicates = SystemTDB.allocSymbol("logDuplicates");
        symFileMode = SystemTDB.allocSymbol("fileMode");
        symIndexType = SystemTDB.allocSymbol("indexType");
        symTupleFilter = SystemTDB.allocSymbol("tupleFilter");
        propertyFileName = null;
        propertyFileName = System.getProperty(propertyFileKey1);
        if (propertyFileName == null) {
            propertyFileName = System.getProperty(propertyFileKey2);
        }
        is64bitSystem = SystemTDB.determineIf64Bit();
        properties = SystemTDB.readPropertiesFile();
        Node2NodeIdCacheSize = SystemTDB.intValue("Node2NodeIdCacheSize", is64bitSystem ? 200000 : 20000);
        NodeId2NodeCacheSize = SystemTDB.intValue("NodeId2NodeCacheSize", is64bitSystem ? 750000 : 20000);
        BlockWriteCacheSize = SystemTDB.intValue("BlockWriteCacheSize", 1000);
        BlockReadCacheSize = SystemTDB.intValue("BlockReadCacheSize", 5000);
        defaultReorderTransform = ReorderLib.fixed();
        propertyEnableInlineLiterals1 = "org.apache.jena.tdb.store.enableInlineLiterals";
        propertyEnableInlineLiterals2 = "tdb:store.enableInlineLiterals";
        Properties sysProperties = System.getProperties();
        String key = null;
        if (sysProperties.containsKey(propertyEnableInlineLiterals1)) {
            key = propertyFileKey1;
        } else if (sysProperties.containsKey(propertyEnableInlineLiterals2)) {
            key = propertyFileKey2;
        }
        enableInlineLiterals = key == null ? true : Boolean.valueOf(sysProperties.getProperty(key));
        NullOut = false;
        DiskLocationMultiJvmUsagePrevention = true;
        isWindows = SystemTDB.determineIfWindows();
        fileMode = null;
    }
}

