/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.web;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.web.DatasetGraphAccessor;

public class DatasetGraphAccessorBasic
implements DatasetGraphAccessor {
    private DatasetGraph dataset;

    public DatasetGraphAccessorBasic(DatasetGraph dataset) {
        this.dataset = dataset;
    }

    @Override
    public Graph httpGet() {
        return this.dataset.getDefaultGraph();
    }

    @Override
    public Graph httpGet(Node graphName) {
        return this.dataset.getGraph(graphName);
    }

    @Override
    public boolean httpHead() {
        return true;
    }

    @Override
    public boolean httpHead(Node graphName) {
        return this.dataset.containsGraph(graphName);
    }

    @Override
    public void httpPut(Graph data) {
        this.putGraph(this.dataset.getDefaultGraph(), data);
    }

    @Override
    public void httpPut(Node graphName, Graph data) {
        Graph ng = this.dataset.getGraph(graphName);
        if (ng == null) {
            this.dataset.addGraph(graphName, ng);
        } else {
            this.putGraph(ng, data);
        }
    }

    @Override
    public void httpDelete() {
        this.clearGraph(this.dataset.getDefaultGraph());
    }

    @Override
    public void httpDelete(Node graphName) {
        Graph ng = this.dataset.getGraph(graphName);
        if (ng == null) {
            return;
        }
        this.dataset.removeGraph(graphName);
    }

    @Override
    public void httpPost(Graph data) {
        this.mergeGraph(this.dataset.getDefaultGraph(), data);
    }

    @Override
    public void httpPost(Node graphName, Graph data) {
        Graph ng = this.dataset.getGraph(graphName);
        if (ng == null) {
            this.dataset.addGraph(graphName, data);
            return;
        }
        this.mergeGraph(ng, data);
    }

    @Override
    public void httpPatch(Graph data) {
        this.httpPost(data);
    }

    @Override
    public void httpPatch(Node graphName, Graph data) {
        this.httpPost(graphName, data);
    }

    private void putGraph(Graph destGraph, Graph data) {
        this.clearGraph(destGraph);
        this.mergeGraph(destGraph, data);
    }

    private void clearGraph(Graph graph) {
        if (!graph.isEmpty()) {
            graph.clear();
        }
    }

    private void mergeGraph(Graph graph, Graph data) {
        GraphUtil.addInto(graph, data);
    }
}

