/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.RangeFieldQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;

public class IntRangeField
extends Field {
    public static final int BYTES = 4;

    public IntRangeField(String name, int[] min2, int[] max2) {
        super(name, IntRangeField.getType(min2.length));
        this.setRangeValues(min2, max2);
    }

    private static FieldType getType(int dimensions) {
        if (dimensions > 4) {
            throw new IllegalArgumentException("IntRangeField does not support greater than 4 dimensions");
        }
        FieldType ft = new FieldType();
        ft.setDimensions(dimensions * 2, 4);
        ft.freeze();
        return ft;
    }

    public void setRangeValues(int[] min2, int[] max2) {
        byte[] bytes;
        IntRangeField.checkArgs(min2, max2);
        if (min2.length * 2 != this.type.pointDimensionCount() || max2.length * 2 != this.type.pointDimensionCount()) {
            throw new IllegalArgumentException("field (name=" + this.name + ") uses " + this.type.pointDimensionCount() / 2 + " dimensions; cannot change to (incoming) " + min2.length + " dimensions");
        }
        if (this.fieldsData == null) {
            bytes = new byte[8 * min2.length];
            this.fieldsData = new BytesRef(bytes);
        } else {
            bytes = ((BytesRef)this.fieldsData).bytes;
        }
        IntRangeField.verifyAndEncode(min2, max2, bytes);
    }

    private static void checkArgs(int[] min2, int[] max2) {
        if (min2 == null || max2 == null || min2.length == 0 || max2.length == 0) {
            throw new IllegalArgumentException("min/max range values cannot be null or empty");
        }
        if (min2.length != max2.length) {
            throw new IllegalArgumentException("min/max ranges must agree");
        }
        if (min2.length > 4) {
            throw new IllegalArgumentException("IntRangeField does not support greater than 4 dimensions");
        }
    }

    private static byte[] encode(int[] min2, int[] max2) {
        IntRangeField.checkArgs(min2, max2);
        byte[] b = new byte[8 * min2.length];
        IntRangeField.verifyAndEncode(min2, max2, b);
        return b;
    }

    static void verifyAndEncode(int[] min2, int[] max2, byte[] bytes) {
        int d = 0;
        int i = 0;
        int j = min2.length * 4;
        while (d < min2.length) {
            if (Double.isNaN(min2[d])) {
                throw new IllegalArgumentException("invalid min value (NaN) in IntRangeField");
            }
            if (Double.isNaN(max2[d])) {
                throw new IllegalArgumentException("invalid max value (NaN) in IntRangeField");
            }
            if (min2[d] > max2[d]) {
                throw new IllegalArgumentException("min value (" + min2[d] + ") is greater than max value (" + max2[d] + ")");
            }
            IntRangeField.encode(min2[d], bytes, i);
            IntRangeField.encode(max2[d], bytes, j);
            ++d;
            i += 4;
            j += 4;
        }
    }

    private static void encode(int val, byte[] bytes, int offset) {
        NumericUtils.intToSortableBytes(val, bytes, offset);
    }

    public int getMin(int dimension) {
        if (dimension < 0 || dimension >= this.type.pointDimensionCount() / 2) {
            throw new IllegalArgumentException("dimension request (" + dimension + ") out of bounds for field (name=" + this.name + " dimensions=" + this.type.pointDimensionCount() / 2 + "). ");
        }
        return IntRangeField.decodeMin(((BytesRef)this.fieldsData).bytes, dimension);
    }

    public int getMax(int dimension) {
        if (dimension < 0 || dimension >= this.type.pointDimensionCount() / 2) {
            throw new IllegalArgumentException("dimension request (" + dimension + ") out of bounds for field (name=" + this.name + " dimensions=" + this.type.pointDimensionCount() / 2 + "). ");
        }
        return IntRangeField.decodeMax(((BytesRef)this.fieldsData).bytes, dimension);
    }

    static int decodeMin(byte[] b, int dimension) {
        int offset = dimension * 4;
        return NumericUtils.sortableBytesToInt(b, offset);
    }

    static int decodeMax(byte[] b, int dimension) {
        int offset = b.length / 2 + dimension * 4;
        return NumericUtils.sortableBytesToInt(b, offset);
    }

    public static Query newIntersectsQuery(String field, int[] min2, int[] max2) {
        return new RangeFieldQuery(field, IntRangeField.encode(min2, max2), min2.length, RangeFieldQuery.QueryType.INTERSECTS){

            @Override
            protected String toString(byte[] ranges, int dimension) {
                return IntRangeField.toString(ranges, dimension);
            }
        };
    }

    public static Query newContainsQuery(String field, int[] min2, int[] max2) {
        return new RangeFieldQuery(field, IntRangeField.encode(min2, max2), min2.length, RangeFieldQuery.QueryType.CONTAINS){

            @Override
            protected String toString(byte[] ranges, int dimension) {
                return IntRangeField.toString(ranges, dimension);
            }
        };
    }

    public static Query newWithinQuery(String field, int[] min2, int[] max2) {
        IntRangeField.checkArgs(min2, max2);
        return new RangeFieldQuery(field, IntRangeField.encode(min2, max2), min2.length, RangeFieldQuery.QueryType.WITHIN){

            @Override
            protected String toString(byte[] ranges, int dimension) {
                return IntRangeField.toString(ranges, dimension);
            }
        };
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" <");
        sb.append(this.name);
        sb.append(':');
        byte[] b = ((BytesRef)this.fieldsData).bytes;
        IntRangeField.toString(b, 0);
        for (int d = 1; d < this.type.pointDimensionCount(); ++d) {
            sb.append(' ');
            IntRangeField.toString(b, d);
        }
        sb.append('>');
        return sb.toString();
    }

    private static String toString(byte[] ranges, int dimension) {
        return "[" + Integer.toString(IntRangeField.decodeMin(ranges, dimension)) + " : " + Integer.toString(IntRangeField.decodeMax(ranges, dimension)) + "]";
    }
}

