/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.BufferedUpdates;
import org.apache.lucene.index.BufferedUpdatesStream;
import org.apache.lucene.index.DocValuesUpdate;
import org.apache.lucene.index.FieldTermIterator;
import org.apache.lucene.index.FrozenBufferedUpdates;
import org.apache.lucene.index.MergedPrefixCodedTermsIterator;
import org.apache.lucene.index.PrefixCodedTerms;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;

class CoalescedUpdates {
    final Map<Query, Integer> queries = new HashMap<Query, Integer>();
    final List<PrefixCodedTerms> terms = new ArrayList<PrefixCodedTerms>();
    final List<List<DocValuesUpdate>> numericDVUpdates = new ArrayList<List<DocValuesUpdate>>();
    final List<List<DocValuesUpdate>> binaryDVUpdates = new ArrayList<List<DocValuesUpdate>>();
    long totalTermCount;

    CoalescedUpdates() {
    }

    public String toString() {
        return "CoalescedUpdates(termSets=" + this.terms.size() + ",totalTermCount=" + this.totalTermCount + ",queries=" + this.queries.size() + ",numericDVUpdates=" + this.numericDVUpdates.size() + ",binaryDVUpdates=" + this.binaryDVUpdates.size() + ")";
    }

    void update(FrozenBufferedUpdates in) {
        this.totalTermCount += in.terms.size();
        this.terms.add(in.terms);
        for (int queryIdx = 0; queryIdx < in.queries.length; ++queryIdx) {
            DocValuesUpdate.NumericDocValuesUpdate[] query2 = in.queries[queryIdx];
            this.queries.put((Query)query2, BufferedUpdates.MAX_INT);
        }
        ArrayList<DocValuesUpdate.NumericDocValuesUpdate> numericPacket = new ArrayList<DocValuesUpdate.NumericDocValuesUpdate>();
        this.numericDVUpdates.add(numericPacket);
        for (DocValuesUpdate.NumericDocValuesUpdate nu : in.numericDVUpdates) {
            DocValuesUpdate.NumericDocValuesUpdate clone = new DocValuesUpdate.NumericDocValuesUpdate(nu.term, nu.field, (Long)nu.value);
            clone.docIDUpto = Integer.MAX_VALUE;
            numericPacket.add(clone);
        }
        ArrayList<DocValuesUpdate.BinaryDocValuesUpdate> binaryPacket = new ArrayList<DocValuesUpdate.BinaryDocValuesUpdate>();
        this.binaryDVUpdates.add(binaryPacket);
        for (DocValuesUpdate.BinaryDocValuesUpdate bu : in.binaryDVUpdates) {
            DocValuesUpdate.BinaryDocValuesUpdate clone = new DocValuesUpdate.BinaryDocValuesUpdate(bu.term, bu.field, (BytesRef)bu.value);
            clone.docIDUpto = Integer.MAX_VALUE;
            binaryPacket.add(clone);
        }
    }

    public FieldTermIterator termIterator() {
        if (this.terms.size() == 1) {
            return this.terms.get(0).iterator();
        }
        return new MergedPrefixCodedTermsIterator(this.terms);
    }

    public Iterable<BufferedUpdatesStream.QueryAndLimit> queriesIterable() {
        return new Iterable<BufferedUpdatesStream.QueryAndLimit>(){

            @Override
            public Iterator<BufferedUpdatesStream.QueryAndLimit> iterator() {
                return new Iterator<BufferedUpdatesStream.QueryAndLimit>(){
                    private final Iterator<Map.Entry<Query, Integer>> iter;
                    {
                        this.iter = CoalescedUpdates.this.queries.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public BufferedUpdatesStream.QueryAndLimit next() {
                        Map.Entry<Query, Integer> ent = this.iter.next();
                        return new BufferedUpdatesStream.QueryAndLimit(ent.getKey(), ent.getValue());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

