/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.BaseCompositeReader;
import org.apache.lucene.index.CompositeReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ParallelLeafReader;

public class ParallelCompositeReader
extends BaseCompositeReader<LeafReader> {
    private final boolean closeSubReaders;
    private final Set<IndexReader> completeReaderSet = Collections.newSetFromMap(new IdentityHashMap());

    public ParallelCompositeReader(CompositeReader ... readers) throws IOException {
        this(true, readers);
    }

    public ParallelCompositeReader(boolean closeSubReaders, CompositeReader ... readers) throws IOException {
        this(closeSubReaders, readers, readers);
    }

    public ParallelCompositeReader(boolean closeSubReaders, CompositeReader[] readers, CompositeReader[] storedFieldReaders) throws IOException {
        super((IndexReader[])ParallelCompositeReader.prepareLeafReaders(readers, storedFieldReaders));
        this.closeSubReaders = closeSubReaders;
        Collections.addAll(this.completeReaderSet, readers);
        Collections.addAll(this.completeReaderSet, storedFieldReaders);
        if (!closeSubReaders) {
            for (IndexReader reader : this.completeReaderSet) {
                reader.incRef();
            }
        }
        this.completeReaderSet.addAll(this.getSequentialSubReaders());
    }

    private static LeafReader[] prepareLeafReaders(CompositeReader[] readers, CompositeReader[] storedFieldsReaders) throws IOException {
        if (readers.length == 0) {
            if (storedFieldsReaders.length > 0) {
                throw new IllegalArgumentException("There must be at least one main reader if storedFieldsReaders are used.");
            }
            return new LeafReader[0];
        }
        List<LeafReaderContext> firstLeaves = readers[0].leaves();
        int maxDoc = readers[0].maxDoc();
        int noLeaves = firstLeaves.size();
        int[] leafMaxDoc = new int[noLeaves];
        for (int i = 0; i < noLeaves; ++i) {
            LeafReader r = firstLeaves.get(i).reader();
            leafMaxDoc[i] = r.maxDoc();
        }
        ParallelCompositeReader.validate(readers, maxDoc, leafMaxDoc);
        ParallelCompositeReader.validate(storedFieldsReaders, maxDoc, leafMaxDoc);
        LeafReader[] wrappedLeaves = new LeafReader[noLeaves];
        for (int i = 0; i < wrappedLeaves.length; ++i) {
            LeafReader[] subs = new LeafReader[readers.length];
            for (int j = 0; j < readers.length; ++j) {
                subs[j] = readers[j].leaves().get(i).reader();
            }
            LeafReader[] storedSubs = new LeafReader[storedFieldsReaders.length];
            for (int j = 0; j < storedFieldsReaders.length; ++j) {
                storedSubs[j] = storedFieldsReaders[j].leaves().get(i).reader();
            }
            wrappedLeaves[i] = new ParallelLeafReader(true, subs, storedSubs){

                @Override
                protected void doClose() {
                }
            };
        }
        return wrappedLeaves;
    }

    private static void validate(CompositeReader[] readers, int maxDoc, int[] leafMaxDoc) {
        for (int i = 0; i < readers.length; ++i) {
            CompositeReader reader = readers[i];
            List<LeafReaderContext> subs = reader.leaves();
            if (reader.maxDoc() != maxDoc) {
                throw new IllegalArgumentException("All readers must have same maxDoc: " + maxDoc + "!=" + reader.maxDoc());
            }
            int noSubs = subs.size();
            if (noSubs != leafMaxDoc.length) {
                throw new IllegalArgumentException("All readers must have same number of leaf readers");
            }
            for (int subIDX = 0; subIDX < noSubs; ++subIDX) {
                LeafReader r = subs.get(subIDX).reader();
                if (r.maxDoc() == leafMaxDoc[subIDX]) continue;
                throw new IllegalArgumentException("All leaf readers must have same corresponding subReader maxDoc");
            }
        }
    }

    @Override
    protected synchronized void doClose() throws IOException {
        IOException ioe = null;
        for (IndexReader reader : this.completeReaderSet) {
            try {
                if (this.closeSubReaders) {
                    reader.close();
                    continue;
                }
                reader.decRef();
            }
            catch (IOException e2) {
                if (ioe != null) continue;
                ioe = e2;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }
}

