/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.Version;

public final class SegmentInfos
implements Cloneable,
Iterable<SegmentCommitInfo> {
    public static final int VERSION_50 = 4;
    public static final int VERSION_51 = 5;
    public static final int VERSION_53 = 6;
    static final int VERSION_CURRENT = 6;
    public int counter;
    public long version;
    private long generation;
    private long lastGeneration;
    public Map<String, String> userData = Collections.emptyMap();
    private List<SegmentCommitInfo> segments = new ArrayList<SegmentCommitInfo>();
    private static PrintStream infoStream = null;
    private byte[] id;
    private Version luceneVersion;
    private Version minSegmentLuceneVersion;
    private static final List<String> unsupportedCodecs = Arrays.asList("Lucene3x", "Lucene40", "Lucene41", "Lucene42", "Lucene45", "Lucene46", "Lucene49", "Lucene410");
    boolean pendingCommit;

    public SegmentCommitInfo info(int i) {
        return this.segments.get(i);
    }

    public static long getLastCommitGeneration(String[] files) {
        long max2 = -1L;
        for (String file : files) {
            long gen;
            if (!file.startsWith("segments") || file.equals("segments.gen") || (gen = SegmentInfos.generationFromSegmentsFileName(file)) <= max2) continue;
            max2 = gen;
        }
        return max2;
    }

    public static long getLastCommitGeneration(Directory directory) throws IOException {
        return SegmentInfos.getLastCommitGeneration(directory.listAll());
    }

    public static String getLastCommitSegmentsFileName(String[] files) {
        return IndexFileNames.fileNameFromGeneration("segments", "", SegmentInfos.getLastCommitGeneration(files));
    }

    public static String getLastCommitSegmentsFileName(Directory directory) throws IOException {
        return IndexFileNames.fileNameFromGeneration("segments", "", SegmentInfos.getLastCommitGeneration(directory));
    }

    public String getSegmentsFileName() {
        return IndexFileNames.fileNameFromGeneration("segments", "", this.lastGeneration);
    }

    public static long generationFromSegmentsFileName(String fileName) {
        if (fileName.equals("segments")) {
            return 0L;
        }
        if (fileName.startsWith("segments")) {
            return Long.parseLong(fileName.substring(1 + "segments".length()), 36);
        }
        throw new IllegalArgumentException("fileName \"" + fileName + "\" is not a segments file");
    }

    private long getNextPendingGeneration() {
        if (this.generation == -1L) {
            return 1L;
        }
        return this.generation + 1L;
    }

    public byte[] getId() {
        return (byte[])this.id.clone();
    }

    public static final SegmentInfos readCommit(Directory directory, String segmentFileName) throws IOException {
        long generation = SegmentInfos.generationFromSegmentsFileName(segmentFileName);
        Throwable throwable = null;
        try (ChecksumIndexInput input = directory.openChecksumInput(segmentFileName, IOContext.READ);){
            SegmentInfos segmentInfos = SegmentInfos.readCommit(directory, input, generation);
            return segmentInfos;
        }
        catch (EOFException e2) {
            try {
                throw new CorruptIndexException("Unexpected end of file while reading index.", input, (Throwable)e2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static final SegmentInfos readCommit(Directory directory, ChecksumIndexInput input, long generation) throws IOException {
        int magic = input.readInt();
        if (magic != 1071082519) {
            throw new IndexFormatTooOldException(input, magic, 1071082519, 1071082519);
        }
        int format = CodecUtil.checkHeaderNoMagic(input, "segments", 4, 6);
        byte[] id = new byte[16];
        input.readBytes(id, 0, id.length);
        CodecUtil.checkIndexHeaderSuffix(input, Long.toString(generation, 36));
        SegmentInfos infos = new SegmentInfos();
        infos.id = id;
        infos.generation = generation;
        infos.lastGeneration = generation;
        if (format >= 6) {
            infos.luceneVersion = Version.fromBits(input.readVInt(), input.readVInt(), input.readVInt());
        }
        infos.version = input.readLong();
        infos.counter = input.readInt();
        int numSegments = input.readInt();
        if (numSegments < 0) {
            throw new CorruptIndexException("invalid segment count: " + numSegments, input);
        }
        if (format >= 6 && numSegments > 0) {
            infos.minSegmentLuceneVersion = Version.fromBits(input.readVInt(), input.readVInt(), input.readVInt());
            if (!infos.minSegmentLuceneVersion.onOrAfter(Version.LUCENE_5_0_0)) {
                throw new IndexFormatTooOldException(input, "this index contains a too-old segment (version: " + infos.minSegmentLuceneVersion + ")");
            }
        }
        long totalDocs = 0L;
        for (int seg = 0; seg < numSegments; ++seg) {
            Map<Integer, Set<String>> dvUpdateFiles;
            String segName = input.readString();
            byte hasID = input.readByte();
            if (hasID != 1) {
                if (hasID == 0) {
                    throw new IndexFormatTooOldException(input, "Segment is from Lucene 4.x");
                }
                throw new CorruptIndexException("invalid hasID byte, got: " + hasID, input);
            }
            byte[] segmentID = new byte[16];
            input.readBytes(segmentID, 0, segmentID.length);
            Codec codec = SegmentInfos.readCodec(input, format < 6);
            SegmentInfo info = codec.segmentInfoFormat().read(directory, segName, segmentID, IOContext.READ);
            info.setCodec(codec);
            totalDocs += (long)info.maxDoc();
            long delGen = input.readLong();
            int delCount = input.readInt();
            if (delCount < 0 || delCount > info.maxDoc()) {
                throw new CorruptIndexException("invalid deletion count: " + delCount + " vs maxDoc=" + info.maxDoc(), input);
            }
            long fieldInfosGen = input.readLong();
            long dvGen = input.readLong();
            SegmentCommitInfo siPerCommit = new SegmentCommitInfo(info, delCount, delGen, fieldInfosGen, dvGen);
            if (format >= 5) {
                siPerCommit.setFieldInfosFiles(input.readSetOfStrings());
            } else {
                siPerCommit.setFieldInfosFiles(Collections.unmodifiableSet(input.readStringSet()));
            }
            int numDVFields = input.readInt();
            if (numDVFields == 0) {
                dvUpdateFiles = Collections.emptyMap();
            } else {
                HashMap<Integer, Set<String>> map = new HashMap<Integer, Set<String>>(numDVFields);
                for (int i = 0; i < numDVFields; ++i) {
                    if (format >= 5) {
                        map.put(input.readInt(), input.readSetOfStrings());
                        continue;
                    }
                    map.put(input.readInt(), Collections.unmodifiableSet(input.readStringSet()));
                }
                dvUpdateFiles = Collections.unmodifiableMap(map);
            }
            siPerCommit.setDocValuesUpdatesFiles(dvUpdateFiles);
            infos.add(siPerCommit);
            Version segmentVersion = info.getVersion();
            if (format < 6) {
                if (infos.minSegmentLuceneVersion != null && segmentVersion.onOrAfter(infos.minSegmentLuceneVersion)) continue;
                infos.minSegmentLuceneVersion = segmentVersion;
                continue;
            }
            if (segmentVersion.onOrAfter(infos.minSegmentLuceneVersion)) continue;
            throw new CorruptIndexException("segments file recorded minSegmentLuceneVersion=" + infos.minSegmentLuceneVersion + " but segment=" + info + " has older version=" + segmentVersion, input);
        }
        infos.userData = format >= 5 ? input.readMapOfStrings() : Collections.unmodifiableMap(input.readStringStringMap());
        CodecUtil.checkFooter(input);
        if (totalDocs > (long)IndexWriter.getActualMaxDocs()) {
            throw new CorruptIndexException("Too many documents: an index cannot exceed " + IndexWriter.getActualMaxDocs() + " but readers have total maxDoc=" + totalDocs, input);
        }
        return infos;
    }

    private static Codec readCodec(DataInput input, boolean unsupportedAllowed) throws IOException {
        String name = input.readString();
        try {
            return Codec.forName(name);
        }
        catch (IllegalArgumentException e2) {
            if (unsupportedCodecs.contains(name)) {
                assert (unsupportedAllowed);
                IndexFormatTooOldException newExc = new IndexFormatTooOldException(input, "Codec '" + name + "' is too old");
                newExc.initCause(e2);
                throw newExc;
            }
            if (name.startsWith("Lucene")) {
                throw new IllegalArgumentException("Could not load codec '" + name + "'.  Did you forget to add lucene-backward-codecs.jar?", e2);
            }
            throw e2;
        }
    }

    public static final SegmentInfos readLatestCommit(Directory directory) throws IOException {
        return (SegmentInfos)new FindSegmentsFile<SegmentInfos>(directory){

            @Override
            protected SegmentInfos doBody(String segmentFileName) throws IOException {
                return SegmentInfos.readCommit(this.directory, segmentFileName);
            }
        }.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(Directory directory) throws IOException {
        IndexOutput segnOutput;
        String segmentFileName;
        block4: {
            long nextGeneration = this.getNextPendingGeneration();
            segmentFileName = IndexFileNames.fileNameFromGeneration("pending_segments", "", nextGeneration);
            this.generation = nextGeneration;
            segnOutput = null;
            boolean success = false;
            try {
                segnOutput = directory.createOutput(segmentFileName, IOContext.DEFAULT);
                this.write(directory, segnOutput);
                segnOutput.close();
                directory.sync(Collections.singleton(segmentFileName));
                success = true;
                if (!success) break block4;
                this.pendingCommit = true;
            }
            catch (Throwable throwable) {
                if (success) {
                    this.pendingCommit = true;
                } else {
                    IOUtils.closeWhileHandlingException(segnOutput);
                    IOUtils.deleteFilesIgnoringExceptions(directory, segmentFileName);
                }
                throw throwable;
            }
        }
        IOUtils.closeWhileHandlingException(segnOutput);
        IOUtils.deleteFilesIgnoringExceptions(directory, segmentFileName);
    }

    public void write(Directory directory, IndexOutput out) throws IOException {
        CodecUtil.writeIndexHeader(out, "segments", 6, StringHelper.randomId(), Long.toString(this.generation, 36));
        out.writeVInt(Version.LATEST.major);
        out.writeVInt(Version.LATEST.minor);
        out.writeVInt(Version.LATEST.bugfix);
        out.writeLong(this.version);
        out.writeInt(this.counter);
        out.writeInt(this.size());
        if (this.size() > 0) {
            Version minSegmentVersion = null;
            for (SegmentCommitInfo siPerCommit : this) {
                Version segmentVersion = siPerCommit.info.getVersion();
                if (minSegmentVersion != null && segmentVersion.onOrAfter(minSegmentVersion)) continue;
                minSegmentVersion = segmentVersion;
            }
            out.writeVInt(minSegmentVersion.major);
            out.writeVInt(minSegmentVersion.minor);
            out.writeVInt(minSegmentVersion.bugfix);
        }
        for (SegmentCommitInfo siPerCommit : this) {
            SegmentInfo si = siPerCommit.info;
            out.writeString(si.name);
            byte[] segmentID = si.getId();
            if (segmentID == null) {
                out.writeByte((byte)0);
            } else {
                if (segmentID.length != 16) {
                    throw new IllegalStateException("cannot write segment: invalid id segment=" + si.name + "id=" + StringHelper.idToString(segmentID));
                }
                out.writeByte((byte)1);
                out.writeBytes(segmentID, segmentID.length);
            }
            out.writeString(si.getCodec().getName());
            out.writeLong(siPerCommit.getDelGen());
            int delCount = siPerCommit.getDelCount();
            if (delCount < 0 || delCount > si.maxDoc()) {
                throw new IllegalStateException("cannot write segment: invalid maxDoc segment=" + si.name + " maxDoc=" + si.maxDoc() + " delCount=" + delCount);
            }
            out.writeInt(delCount);
            out.writeLong(siPerCommit.getFieldInfosGen());
            out.writeLong(siPerCommit.getDocValuesGen());
            out.writeSetOfStrings(siPerCommit.getFieldInfosFiles());
            Map<Integer, Set<String>> dvUpdatesFiles = siPerCommit.getDocValuesUpdatesFiles();
            out.writeInt(dvUpdatesFiles.size());
            for (Map.Entry<Integer, Set<String>> e2 : dvUpdatesFiles.entrySet()) {
                out.writeInt(e2.getKey());
                out.writeSetOfStrings(e2.getValue());
            }
        }
        out.writeMapOfStrings(this.userData);
        CodecUtil.writeFooter(out);
    }

    public SegmentInfos clone() {
        try {
            SegmentInfos sis = (SegmentInfos)super.clone();
            sis.segments = new ArrayList<SegmentCommitInfo>(this.size());
            for (SegmentCommitInfo info : this) {
                assert (info.info.getCodec() != null);
                sis.add(info.clone());
            }
            sis.userData = new HashMap<String, String>(this.userData);
            return sis;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException("should not happen", e2);
        }
    }

    public long getVersion() {
        return this.version;
    }

    public long getGeneration() {
        return this.generation;
    }

    public long getLastGeneration() {
        return this.lastGeneration;
    }

    public static void setInfoStream(PrintStream infoStream) {
        SegmentInfos.infoStream = infoStream;
    }

    public static PrintStream getInfoStream() {
        return infoStream;
    }

    private static void message(String message) {
        infoStream.println("SIS [" + Thread.currentThread().getName() + "]: " + message);
    }

    public void updateGeneration(SegmentInfos other) {
        this.lastGeneration = other.lastGeneration;
        this.generation = other.generation;
    }

    void updateGenerationVersionAndCounter(SegmentInfos other) {
        this.updateGeneration(other);
        this.version = other.version;
        this.counter = other.counter;
    }

    public void setNextWriteGeneration(long generation) {
        if (generation < this.generation) {
            throw new IllegalStateException("cannot decrease generation to " + generation + " from current generation " + this.generation);
        }
        this.generation = generation;
    }

    final void rollbackCommit(Directory dir) {
        if (this.pendingCommit) {
            this.pendingCommit = false;
            String pending = IndexFileNames.fileNameFromGeneration("pending_segments", "", this.generation);
            IOUtils.deleteFilesIgnoringExceptions(dir, pending);
        }
    }

    final void prepareCommit(Directory dir) throws IOException {
        if (this.pendingCommit) {
            throw new IllegalStateException("prepareCommit was already called");
        }
        this.write(dir);
    }

    public Collection<String> files(boolean includeSegmentsFile) throws IOException {
        String segmentFileName;
        HashSet<String> files = new HashSet<String>();
        if (includeSegmentsFile && (segmentFileName = this.getSegmentsFileName()) != null) {
            files.add(segmentFileName);
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            SegmentCommitInfo info = this.info(i);
            files.addAll(info.files());
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String finishCommit(Directory dir) throws IOException {
        String dest;
        if (!this.pendingCommit) {
            throw new IllegalStateException("prepareCommit was not called");
        }
        boolean success = false;
        try {
            String src = IndexFileNames.fileNameFromGeneration("pending_segments", "", this.generation);
            dest = IndexFileNames.fileNameFromGeneration("segments", "", this.generation);
            dir.rename(src, dest);
            dir.syncMetaData();
            success = true;
        }
        finally {
            if (!success) {
                this.rollbackCommit(dir);
            }
        }
        this.pendingCommit = false;
        this.lastGeneration = this.generation;
        return dest;
    }

    public final void commit(Directory dir) throws IOException {
        this.prepareCommit(dir);
        this.finishCommit(dir);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getSegmentsFileName()).append(": ");
        int count = this.size();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                buffer.append(' ');
            }
            SegmentCommitInfo info = this.info(i);
            buffer.append(info.toString(0));
        }
        return buffer.toString();
    }

    public Map<String, String> getUserData() {
        return this.userData;
    }

    public void setUserData(Map<String, String> data, boolean doIncrementVersion) {
        this.userData = data == null ? Collections.emptyMap() : data;
        if (doIncrementVersion) {
            this.changed();
        }
    }

    void replace(SegmentInfos other) {
        this.rollbackSegmentInfos(other.asList());
        this.lastGeneration = other.lastGeneration;
    }

    public int totalMaxDoc() {
        long count = 0L;
        for (SegmentCommitInfo info : this) {
            count += (long)info.info.maxDoc();
        }
        assert (count <= (long)IndexWriter.getActualMaxDocs());
        return Math.toIntExact(count);
    }

    public void changed() {
        ++this.version;
    }

    void setVersion(long newVersion) {
        if (newVersion < this.version) {
            throw new IllegalArgumentException("newVersion (=" + newVersion + ") cannot be less than current version (=" + this.version + ")");
        }
        this.version = newVersion;
    }

    void applyMergeChanges(MergePolicy.OneMerge merge, boolean dropSegment) {
        HashSet<SegmentCommitInfo> mergedAway = new HashSet<SegmentCommitInfo>(merge.segments);
        boolean inserted = false;
        int newSegIdx = 0;
        int cnt = this.segments.size();
        for (int segIdx = 0; segIdx < cnt; ++segIdx) {
            assert (segIdx >= newSegIdx);
            SegmentCommitInfo info = this.segments.get(segIdx);
            if (mergedAway.contains(info)) {
                if (inserted || dropSegment) continue;
                this.segments.set(segIdx, merge.info);
                inserted = true;
                ++newSegIdx;
                continue;
            }
            this.segments.set(newSegIdx, info);
            ++newSegIdx;
        }
        this.segments.subList(newSegIdx, this.segments.size()).clear();
        if (!inserted && !dropSegment) {
            this.segments.add(0, merge.info);
        }
    }

    List<SegmentCommitInfo> createBackupSegmentInfos() {
        ArrayList<SegmentCommitInfo> list = new ArrayList<SegmentCommitInfo>(this.size());
        for (SegmentCommitInfo info : this) {
            assert (info.info.getCodec() != null);
            list.add(info.clone());
        }
        return list;
    }

    void rollbackSegmentInfos(List<SegmentCommitInfo> infos) {
        this.clear();
        this.addAll(infos);
    }

    @Override
    public Iterator<SegmentCommitInfo> iterator() {
        return this.asList().iterator();
    }

    public List<SegmentCommitInfo> asList() {
        return Collections.unmodifiableList(this.segments);
    }

    public int size() {
        return this.segments.size();
    }

    public void add(SegmentCommitInfo si) {
        this.segments.add(si);
    }

    public void addAll(Iterable<SegmentCommitInfo> sis) {
        for (SegmentCommitInfo si : sis) {
            this.add(si);
        }
    }

    public void clear() {
        this.segments.clear();
    }

    public void remove(SegmentCommitInfo si) {
        this.segments.remove(si);
    }

    void remove(int index) {
        this.segments.remove(index);
    }

    boolean contains(SegmentCommitInfo si) {
        return this.segments.contains(si);
    }

    int indexOf(SegmentCommitInfo si) {
        return this.segments.indexOf(si);
    }

    public Version getCommitLuceneVersion() {
        return this.luceneVersion;
    }

    public Version getMinSegmentLuceneVersion() {
        return this.minSegmentLuceneVersion;
    }

    public static abstract class FindSegmentsFile<T> {
        final Directory directory;

        public FindSegmentsFile(Directory directory) {
            this.directory = directory;
        }

        public T run() throws IOException {
            return this.run(null);
        }

        public T run(IndexCommit commit) throws IOException {
            if (commit != null) {
                if (this.directory != commit.getDirectory()) {
                    throw new IOException("the specified commit does not match the specified Directory");
                }
                return this.doBody(commit.getSegmentsFileName());
            }
            long lastGen = -1L;
            long gen = -1L;
            IOException exc = null;
            while (true) {
                lastGen = gen;
                Object[] files = this.directory.listAll();
                Object[] files2 = this.directory.listAll();
                Arrays.sort(files);
                Arrays.sort(files2);
                if (!Arrays.equals(files, files2)) continue;
                gen = SegmentInfos.getLastCommitGeneration((String[])files);
                if (infoStream != null) {
                    SegmentInfos.message("directory listing gen=" + gen);
                }
                if (gen == -1L) {
                    throw new IndexNotFoundException("no segments* file found in " + this.directory + ": files: " + Arrays.toString(files));
                }
                if (gen <= lastGen) break;
                String segmentFileName = IndexFileNames.fileNameFromGeneration("segments", "", gen);
                try {
                    T t = this.doBody(segmentFileName);
                    if (infoStream != null) {
                        SegmentInfos.message("success on " + segmentFileName);
                    }
                    return t;
                }
                catch (IOException err) {
                    if (exc == null) {
                        exc = err;
                    }
                    if (infoStream == null) continue;
                    SegmentInfos.message("primary Exception on '" + segmentFileName + "': " + err + "'; will retry: gen = " + gen);
                    continue;
                }
                break;
            }
            throw exc;
        }

        protected abstract T doBody(String var1) throws IOException;
    }
}

