/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.xml.builders;

import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.queryparser.xml.DOMUtils;
import org.apache.lucene.queryparser.xml.ParserException;
import org.apache.lucene.queryparser.xml.QueryBuilder;
import org.apache.lucene.search.Query;
import org.w3c.dom.Element;

public class PointRangeQueryBuilder
implements QueryBuilder {
    @Override
    public Query getQuery(Element e2) throws ParserException {
        String field = DOMUtils.getAttributeWithInheritanceOrFail(e2, "fieldName");
        String lowerTerm = DOMUtils.getAttribute(e2, "lowerTerm", null);
        String upperTerm = DOMUtils.getAttribute(e2, "upperTerm", null);
        String type = DOMUtils.getAttribute(e2, "type", "int");
        try {
            if (type.equalsIgnoreCase("int")) {
                return IntPoint.newRangeQuery(field, lowerTerm == null ? Integer.MIN_VALUE : Integer.valueOf(lowerTerm), upperTerm == null ? Integer.MAX_VALUE : Integer.valueOf(upperTerm));
            }
            if (type.equalsIgnoreCase("long")) {
                return LongPoint.newRangeQuery(field, lowerTerm == null ? Long.MIN_VALUE : Long.valueOf(lowerTerm), upperTerm == null ? Long.MAX_VALUE : Long.valueOf(upperTerm));
            }
            if (type.equalsIgnoreCase("double")) {
                return DoublePoint.newRangeQuery(field, lowerTerm == null ? Double.NEGATIVE_INFINITY : Double.valueOf(lowerTerm), upperTerm == null ? Double.POSITIVE_INFINITY : Double.valueOf(upperTerm));
            }
            if (type.equalsIgnoreCase("float")) {
                return FloatPoint.newRangeQuery(field, lowerTerm == null ? Float.NEGATIVE_INFINITY : Float.valueOf(lowerTerm).floatValue(), upperTerm == null ? Float.POSITIVE_INFINITY : Float.valueOf(upperTerm).floatValue());
            }
            throw new ParserException("type attribute must be one of: [long, int, double, float]");
        }
        catch (NumberFormatException nfe) {
            throw new ParserException("Could not parse lowerTerm or upperTerm into a number", nfe);
        }
    }
}

