/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RandomAccessWeight;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.LongBitSet;

public final class DocValuesRewriteMethod
extends MultiTermQuery.RewriteMethod {
    @Override
    public Query rewrite(IndexReader reader, MultiTermQuery query2) {
        return new ConstantScoreQuery(new MultiTermQueryDocValuesWrapper(query2));
    }

    public boolean equals(Object other) {
        return other != null && this.getClass() == other.getClass();
    }

    public int hashCode() {
        return 641;
    }

    static class MultiTermQueryDocValuesWrapper
    extends Query {
        protected final MultiTermQuery query;

        protected MultiTermQueryDocValuesWrapper(MultiTermQuery query2) {
            this.query = query2;
        }

        @Override
        public String toString(String field) {
            return this.query.toString(field);
        }

        @Override
        public final boolean equals(Object other) {
            return this.sameClassAs(other) && this.query.equals(((MultiTermQueryDocValuesWrapper)other).query);
        }

        @Override
        public final int hashCode() {
            return 31 * this.classHash() + this.query.hashCode();
        }

        public final String getField() {
            return this.query.getField();
        }

        @Override
        public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
            return new RandomAccessWeight(this){

                @Override
                protected Bits getMatchingDocs(final LeafReaderContext context) throws IOException {
                    final SortedSetDocValues fcsi = DocValues.getSortedSet(context.reader(), query.field);
                    TermsEnum termsEnum = query.getTermsEnum(new Terms(){

                        @Override
                        public TermsEnum iterator() {
                            return fcsi.termsEnum();
                        }

                        @Override
                        public long getSumTotalTermFreq() {
                            return -1L;
                        }

                        @Override
                        public long getSumDocFreq() {
                            return -1L;
                        }

                        @Override
                        public int getDocCount() {
                            return -1;
                        }

                        @Override
                        public long size() {
                            return -1L;
                        }

                        @Override
                        public boolean hasFreqs() {
                            return false;
                        }

                        @Override
                        public boolean hasOffsets() {
                            return false;
                        }

                        @Override
                        public boolean hasPositions() {
                            return false;
                        }

                        @Override
                        public boolean hasPayloads() {
                            return false;
                        }
                    });
                    assert (termsEnum != null);
                    if (termsEnum.next() == null) {
                        return null;
                    }
                    final LongBitSet termSet = new LongBitSet(fcsi.getValueCount());
                    do {
                        long ord;
                        if ((ord = termsEnum.ord()) < 0L) continue;
                        termSet.set(ord);
                    } while (termsEnum.next() != null);
                    return new Bits(){

                        @Override
                        public boolean get(int doc) {
                            fcsi.setDocument(doc);
                            long ord = fcsi.nextOrd();
                            while (ord != -1L) {
                                if (termSet.get(ord)) {
                                    return true;
                                }
                                ord = fcsi.nextOrd();
                            }
                            return false;
                        }

                        @Override
                        public int length() {
                            return context.reader().maxDoc();
                        }
                    };
                }
            };
        }
    }
}

