/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;

public final class GraphQuery
extends Query {
    private final Query[] queries;
    private boolean hasBoolean = false;
    private boolean hasPhrase = false;

    public GraphQuery(Query ... queries) {
        this.queries = (Query[])Objects.requireNonNull(queries).clone();
        for (Query query2 : queries) {
            if (query2 instanceof BooleanQuery) {
                this.hasBoolean = true;
                continue;
            }
            if (!(query2 instanceof PhraseQuery)) continue;
            this.hasPhrase = true;
        }
    }

    public List<Query> getQueries() {
        return Collections.unmodifiableList(Arrays.asList(this.queries));
    }

    public boolean hasBoolean() {
        return this.hasBoolean;
    }

    public boolean hasPhrase() {
        return this.hasPhrase;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.queries.length == 0) {
            return new BooleanQuery.Builder().build();
        }
        if (this.queries.length == 1) {
            return this.queries[0];
        }
        BooleanQuery.Builder q = new BooleanQuery.Builder();
        q.setDisableCoord(true);
        for (Query clause : this.queries) {
            q.add(clause, BooleanClause.Occur.SHOULD);
        }
        return q.build();
    }

    @Override
    public String toString(String field) {
        StringBuilder builder = new StringBuilder("Graph(");
        for (int i = 0; i < this.queries.length; ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            builder.append(Objects.toString(this.queries[i]));
        }
        if (this.queries.length > 0) {
            builder.append(", ");
        }
        builder.append("hasBoolean=").append(this.hasBoolean).append(", hasPhrase=").append(this.hasPhrase).append(")");
        return builder.toString();
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.hasBoolean == ((GraphQuery)other).hasBoolean && this.hasPhrase == ((GraphQuery)other).hasPhrase && Arrays.equals(this.queries, ((GraphQuery)other).queries);
    }

    @Override
    public int hashCode() {
        return 31 * this.classHash() + Arrays.deepHashCode(new Object[]{this.hasBoolean, this.hasPhrase, this.queries});
    }
}

