/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Objects;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LegacyNumericUtils;
import org.apache.lucene.util.NumericUtils;

@Deprecated
public final class LegacyNumericRangeQuery<T extends Number>
extends MultiTermQuery {
    final int precisionStep;
    final FieldType.LegacyNumericType dataType;
    final T min;
    final T max;
    final boolean minInclusive;
    final boolean maxInclusive;
    static final long LONG_NEGATIVE_INFINITY = NumericUtils.doubleToSortableLong(Double.NEGATIVE_INFINITY);
    static final long LONG_POSITIVE_INFINITY = NumericUtils.doubleToSortableLong(Double.POSITIVE_INFINITY);
    static final int INT_NEGATIVE_INFINITY = NumericUtils.floatToSortableInt(Float.NEGATIVE_INFINITY);
    static final int INT_POSITIVE_INFINITY = NumericUtils.floatToSortableInt(Float.POSITIVE_INFINITY);

    private LegacyNumericRangeQuery(String field, int precisionStep, FieldType.LegacyNumericType dataType, T min2, T max2, boolean minInclusive, boolean maxInclusive) {
        super(field);
        if (precisionStep < 1) {
            throw new IllegalArgumentException("precisionStep must be >=1");
        }
        this.precisionStep = precisionStep;
        this.dataType = Objects.requireNonNull(dataType, "LegacyNumericType must not be null");
        this.min = min2;
        this.max = max2;
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
    }

    public static LegacyNumericRangeQuery<Long> newLongRange(String field, int precisionStep, Long min2, Long max2, boolean minInclusive, boolean maxInclusive) {
        return new LegacyNumericRangeQuery<Long>(field, precisionStep, FieldType.LegacyNumericType.LONG, min2, max2, minInclusive, maxInclusive);
    }

    public static LegacyNumericRangeQuery<Long> newLongRange(String field, Long min2, Long max2, boolean minInclusive, boolean maxInclusive) {
        return new LegacyNumericRangeQuery<Long>(field, 16, FieldType.LegacyNumericType.LONG, min2, max2, minInclusive, maxInclusive);
    }

    public static LegacyNumericRangeQuery<Integer> newIntRange(String field, int precisionStep, Integer min2, Integer max2, boolean minInclusive, boolean maxInclusive) {
        return new LegacyNumericRangeQuery<Integer>(field, precisionStep, FieldType.LegacyNumericType.INT, min2, max2, minInclusive, maxInclusive);
    }

    public static LegacyNumericRangeQuery<Integer> newIntRange(String field, Integer min2, Integer max2, boolean minInclusive, boolean maxInclusive) {
        return new LegacyNumericRangeQuery<Integer>(field, 8, FieldType.LegacyNumericType.INT, min2, max2, minInclusive, maxInclusive);
    }

    public static LegacyNumericRangeQuery<Double> newDoubleRange(String field, int precisionStep, Double min2, Double max2, boolean minInclusive, boolean maxInclusive) {
        return new LegacyNumericRangeQuery<Double>(field, precisionStep, FieldType.LegacyNumericType.DOUBLE, min2, max2, minInclusive, maxInclusive);
    }

    public static LegacyNumericRangeQuery<Double> newDoubleRange(String field, Double min2, Double max2, boolean minInclusive, boolean maxInclusive) {
        return new LegacyNumericRangeQuery<Double>(field, 16, FieldType.LegacyNumericType.DOUBLE, min2, max2, minInclusive, maxInclusive);
    }

    public static LegacyNumericRangeQuery<Float> newFloatRange(String field, int precisionStep, Float min2, Float max2, boolean minInclusive, boolean maxInclusive) {
        return new LegacyNumericRangeQuery<Float>(field, precisionStep, FieldType.LegacyNumericType.FLOAT, min2, max2, minInclusive, maxInclusive);
    }

    public static LegacyNumericRangeQuery<Float> newFloatRange(String field, Float min2, Float max2, boolean minInclusive, boolean maxInclusive) {
        return new LegacyNumericRangeQuery<Float>(field, 8, FieldType.LegacyNumericType.FLOAT, min2, max2, minInclusive, maxInclusive);
    }

    @Override
    protected TermsEnum getTermsEnum(Terms terms, AttributeSource atts) throws IOException {
        if (this.min != null && this.max != null && ((Comparable)this.min).compareTo(this.max) > 0) {
            return TermsEnum.EMPTY;
        }
        return new NumericRangeTermsEnum(terms.iterator());
    }

    public boolean includesMin() {
        return this.minInclusive;
    }

    public boolean includesMax() {
        return this.maxInclusive;
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }

    public int getPrecisionStep() {
        return this.precisionStep;
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        if (!this.getField().equals(field)) {
            sb.append(this.getField()).append(':');
        }
        return sb.append(this.minInclusive ? (char)'[' : '{').append(this.min == null ? "*" : this.min.toString()).append(" TO ").append(this.max == null ? "*" : this.max.toString()).append(this.maxInclusive ? (char)']' : '}').toString();
    }

    @Override
    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (o instanceof LegacyNumericRangeQuery) {
            LegacyNumericRangeQuery q = (LegacyNumericRangeQuery)o;
            return (q.min == null ? this.min == null : q.min.equals(this.min)) && (q.max == null ? this.max == null : q.max.equals(this.max)) && this.minInclusive == q.minInclusive && this.maxInclusive == q.maxInclusive && this.precisionStep == q.precisionStep;
        }
        return false;
    }

    @Override
    public final int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + this.precisionStep;
        hash = 31 * hash + Objects.hashCode(this.min);
        hash = 31 * hash + Objects.hashCode(this.max);
        hash = 31 * hash + Objects.hashCode(this.minInclusive);
        hash = 31 * hash + Objects.hashCode(this.maxInclusive);
        return hash;
    }

    private final class NumericRangeTermsEnum
    extends FilteredTermsEnum {
        private BytesRef currentLowerBound;
        private BytesRef currentUpperBound;
        private final LinkedList<BytesRef> rangeBounds;

        NumericRangeTermsEnum(TermsEnum tenum) {
            super(tenum);
            this.rangeBounds = new LinkedList();
            switch (LegacyNumericRangeQuery.this.dataType) {
                case LONG: 
                case DOUBLE: {
                    long maxBound;
                    long minBound;
                    if (LegacyNumericRangeQuery.this.dataType == FieldType.LegacyNumericType.LONG) {
                        minBound = LegacyNumericRangeQuery.this.min == null ? Long.MIN_VALUE : ((Number)LegacyNumericRangeQuery.this.min).longValue();
                    } else {
                        assert (LegacyNumericRangeQuery.this.dataType == FieldType.LegacyNumericType.DOUBLE);
                        long l = minBound = LegacyNumericRangeQuery.this.min == null ? LONG_NEGATIVE_INFINITY : NumericUtils.doubleToSortableLong(((Number)LegacyNumericRangeQuery.this.min).doubleValue());
                    }
                    if (!LegacyNumericRangeQuery.this.minInclusive && LegacyNumericRangeQuery.this.min != null) {
                        if (minBound == Long.MAX_VALUE) break;
                        ++minBound;
                    }
                    if (LegacyNumericRangeQuery.this.dataType == FieldType.LegacyNumericType.LONG) {
                        maxBound = LegacyNumericRangeQuery.this.max == null ? Long.MAX_VALUE : ((Number)LegacyNumericRangeQuery.this.max).longValue();
                    } else {
                        assert (LegacyNumericRangeQuery.this.dataType == FieldType.LegacyNumericType.DOUBLE);
                        long l = maxBound = LegacyNumericRangeQuery.this.max == null ? LONG_POSITIVE_INFINITY : NumericUtils.doubleToSortableLong(((Number)LegacyNumericRangeQuery.this.max).doubleValue());
                    }
                    if (!LegacyNumericRangeQuery.this.maxInclusive && LegacyNumericRangeQuery.this.max != null) {
                        if (maxBound == Long.MIN_VALUE) break;
                        --maxBound;
                    }
                    LegacyNumericUtils.splitLongRange(new LegacyNumericUtils.LongRangeBuilder(){

                        @Override
                        public final void addRange(BytesRef minPrefixCoded, BytesRef maxPrefixCoded) {
                            NumericRangeTermsEnum.this.rangeBounds.add(minPrefixCoded);
                            NumericRangeTermsEnum.this.rangeBounds.add(maxPrefixCoded);
                        }
                    }, LegacyNumericRangeQuery.this.precisionStep, minBound, maxBound);
                    break;
                }
                case INT: 
                case FLOAT: {
                    int maxBound;
                    int minBound;
                    if (LegacyNumericRangeQuery.this.dataType == FieldType.LegacyNumericType.INT) {
                        minBound = LegacyNumericRangeQuery.this.min == null ? Integer.MIN_VALUE : ((Number)LegacyNumericRangeQuery.this.min).intValue();
                    } else {
                        assert (LegacyNumericRangeQuery.this.dataType == FieldType.LegacyNumericType.FLOAT);
                        int n = minBound = LegacyNumericRangeQuery.this.min == null ? INT_NEGATIVE_INFINITY : NumericUtils.floatToSortableInt(((Number)LegacyNumericRangeQuery.this.min).floatValue());
                    }
                    if (!LegacyNumericRangeQuery.this.minInclusive && LegacyNumericRangeQuery.this.min != null) {
                        if (minBound == Integer.MAX_VALUE) break;
                        ++minBound;
                    }
                    if (LegacyNumericRangeQuery.this.dataType == FieldType.LegacyNumericType.INT) {
                        maxBound = LegacyNumericRangeQuery.this.max == null ? Integer.MAX_VALUE : ((Number)LegacyNumericRangeQuery.this.max).intValue();
                    } else {
                        assert (LegacyNumericRangeQuery.this.dataType == FieldType.LegacyNumericType.FLOAT);
                        int n = maxBound = LegacyNumericRangeQuery.this.max == null ? INT_POSITIVE_INFINITY : NumericUtils.floatToSortableInt(((Number)LegacyNumericRangeQuery.this.max).floatValue());
                    }
                    if (!LegacyNumericRangeQuery.this.maxInclusive && LegacyNumericRangeQuery.this.max != null) {
                        if (maxBound == Integer.MIN_VALUE) break;
                        --maxBound;
                    }
                    LegacyNumericUtils.splitIntRange(new LegacyNumericUtils.IntRangeBuilder(){

                        @Override
                        public final void addRange(BytesRef minPrefixCoded, BytesRef maxPrefixCoded) {
                            NumericRangeTermsEnum.this.rangeBounds.add(minPrefixCoded);
                            NumericRangeTermsEnum.this.rangeBounds.add(maxPrefixCoded);
                        }
                    }, LegacyNumericRangeQuery.this.precisionStep, minBound, maxBound);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid LegacyNumericType");
                }
            }
        }

        private void nextRange() {
            assert (this.rangeBounds.size() % 2 == 0);
            this.currentLowerBound = this.rangeBounds.removeFirst();
            assert (this.currentUpperBound == null || this.currentUpperBound.compareTo(this.currentLowerBound) <= 0) : "The current upper bound must be <= the new lower bound";
            this.currentUpperBound = this.rangeBounds.removeFirst();
        }

        @Override
        protected final BytesRef nextSeekTerm(BytesRef term) {
            while (this.rangeBounds.size() >= 2) {
                this.nextRange();
                if (term != null && term.compareTo(this.currentUpperBound) > 0) continue;
                return term != null && term.compareTo(this.currentLowerBound) > 0 ? term : this.currentLowerBound;
            }
            assert (this.rangeBounds.isEmpty());
            this.currentUpperBound = null;
            this.currentLowerBound = null;
            return null;
        }

        @Override
        protected final FilteredTermsEnum.AcceptStatus accept(BytesRef term) {
            while (this.currentUpperBound == null || term.compareTo(this.currentUpperBound) > 0) {
                if (this.rangeBounds.isEmpty()) {
                    return FilteredTermsEnum.AcceptStatus.END;
                }
                if (term.compareTo(this.rangeBounds.getFirst()) < 0) {
                    return FilteredTermsEnum.AcceptStatus.NO_AND_SEEK;
                }
                this.nextRange();
            }
            return FilteredTermsEnum.AcceptStatus.YES;
        }
    }
}

