/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostAttribute;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermCollectingRewrite;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.RamUsageEstimator;

public abstract class ScoringRewrite<B>
extends TermCollectingRewrite<B> {
    public static final ScoringRewrite<BooleanQuery.Builder> SCORING_BOOLEAN_REWRITE = new ScoringRewrite<BooleanQuery.Builder>(){

        @Override
        protected BooleanQuery.Builder getTopLevelBuilder() {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.setDisableCoord(true);
            return builder;
        }

        @Override
        protected Query build(BooleanQuery.Builder builder) {
            return builder.build();
        }

        @Override
        protected void addClause(BooleanQuery.Builder topLevel, Term term, int docCount, float boost, TermContext states) {
            TermQuery tq = new TermQuery(term, states);
            topLevel.add(new BoostQuery(tq, boost), BooleanClause.Occur.SHOULD);
        }

        @Override
        protected void checkMaxClauseCount(int count) {
            if (count > BooleanQuery.getMaxClauseCount()) {
                throw new BooleanQuery.TooManyClauses();
            }
        }
    };
    public static final MultiTermQuery.RewriteMethod CONSTANT_SCORE_BOOLEAN_REWRITE = new MultiTermQuery.RewriteMethod(){

        @Override
        public Query rewrite(IndexReader reader, MultiTermQuery query2) throws IOException {
            Query bq = SCORING_BOOLEAN_REWRITE.rewrite(reader, query2);
            return new ConstantScoreQuery(bq);
        }
    };

    protected abstract void checkMaxClauseCount(int var1) throws IOException;

    @Override
    public final Query rewrite(IndexReader reader, MultiTermQuery query2) throws IOException {
        Object builder = this.getTopLevelBuilder();
        ParallelArraysTermCollector col = new ParallelArraysTermCollector();
        this.collectTerms(reader, query2, col);
        int size = col.terms.size();
        if (size > 0) {
            int[] sort = col.terms.sort();
            float[] boost = col.array.boost;
            TermContext[] termStates = col.array.termState;
            for (int i = 0; i < size; ++i) {
                int pos = sort[i];
                Term term = new Term(query2.getField(), col.terms.get(pos, new BytesRef()));
                assert (reader.docFreq(term) == termStates[pos].docFreq());
                this.addClause(builder, term, termStates[pos].docFreq(), boost[pos], termStates[pos]);
            }
        }
        return this.build(builder);
    }

    static final class TermFreqBoostByteStart
    extends BytesRefHash.DirectBytesStartArray {
        float[] boost;
        TermContext[] termState;

        public TermFreqBoostByteStart(int initSize) {
            super(initSize);
        }

        @Override
        public int[] init() {
            int[] ord = super.init();
            this.boost = new float[ArrayUtil.oversize(ord.length, 4)];
            this.termState = new TermContext[ArrayUtil.oversize(ord.length, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            assert (this.termState.length >= ord.length && this.boost.length >= ord.length);
            return ord;
        }

        @Override
        public int[] grow() {
            int[] ord = super.grow();
            this.boost = ArrayUtil.grow(this.boost, ord.length);
            if (this.termState.length < ord.length) {
                TermContext[] tmpTermState = new TermContext[ArrayUtil.oversize(ord.length, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
                System.arraycopy(this.termState, 0, tmpTermState, 0, this.termState.length);
                this.termState = tmpTermState;
            }
            assert (this.termState.length >= ord.length && this.boost.length >= ord.length);
            return ord;
        }

        @Override
        public int[] clear() {
            this.boost = null;
            this.termState = null;
            return super.clear();
        }
    }

    final class ParallelArraysTermCollector
    extends TermCollectingRewrite.TermCollector {
        final TermFreqBoostByteStart array = new TermFreqBoostByteStart(16);
        final BytesRefHash terms = new BytesRefHash(new ByteBlockPool(new ByteBlockPool.DirectAllocator()), 16, this.array);
        TermsEnum termsEnum;
        private BoostAttribute boostAtt;

        ParallelArraysTermCollector() {
        }

        @Override
        public void setNextEnum(TermsEnum termsEnum) {
            this.termsEnum = termsEnum;
            this.boostAtt = termsEnum.attributes().addAttribute(BoostAttribute.class);
        }

        @Override
        public boolean collect(BytesRef bytes) throws IOException {
            int e2 = this.terms.add(bytes);
            TermState state = this.termsEnum.termState();
            assert (state != null);
            if (e2 < 0) {
                int pos = -e2 - 1;
                this.array.termState[pos].register(state, this.readerContext.ord, this.termsEnum.docFreq(), this.termsEnum.totalTermFreq());
                assert (this.array.boost[pos] == this.boostAtt.getBoost()) : "boost should be equal in all segment TermsEnums";
            } else {
                this.array.boost[e2] = this.boostAtt.getBoost();
                this.array.termState[e2] = new TermContext(this.topReaderContext, state, this.readerContext.ord, this.termsEnum.docFreq(), this.termsEnum.totalTermFreq());
                ScoringRewrite.this.checkMaxClauseCount(this.terms.size());
            }
            return true;
        }
    }
}

