/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.MultiTermQueryConstantScoreWrapper;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.FrequencyTrackingRingBuffer;

public final class UsageTrackingQueryCachingPolicy
implements QueryCachingPolicy {
    private static final int SENTINEL = Integer.MIN_VALUE;
    private final FrequencyTrackingRingBuffer recentlyUsedFilters;

    private static boolean isPointQuery(Query query2) {
        for (Class<?> clazz = query2.getClass(); clazz != Query.class; clazz = clazz.getSuperclass()) {
            String simpleName = clazz.getSimpleName();
            if (!simpleName.startsWith("Point") || !simpleName.endsWith("Query")) continue;
            return true;
        }
        return false;
    }

    static boolean isCostly(Query query2) {
        return query2 instanceof MultiTermQuery || query2 instanceof MultiTermQueryConstantScoreWrapper || UsageTrackingQueryCachingPolicy.isPointQuery(query2) || "TermsQuery".equals(query2.getClass().getSimpleName());
    }

    static boolean isCheap(Query query2) {
        return query2 instanceof TermQuery;
    }

    public UsageTrackingQueryCachingPolicy(int historySize) {
        this.recentlyUsedFilters = new FrequencyTrackingRingBuffer(historySize, Integer.MIN_VALUE);
    }

    public UsageTrackingQueryCachingPolicy() {
        this(256);
    }

    protected int minFrequencyToCache(Query query2) {
        if (UsageTrackingQueryCachingPolicy.isCostly(query2)) {
            return 2;
        }
        if (UsageTrackingQueryCachingPolicy.isCheap(query2)) {
            return 20;
        }
        return 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUse(Query query2) {
        assert (!(query2 instanceof BoostQuery));
        assert (!(query2 instanceof ConstantScoreQuery));
        int hashCode = query2.hashCode();
        UsageTrackingQueryCachingPolicy usageTrackingQueryCachingPolicy = this;
        synchronized (usageTrackingQueryCachingPolicy) {
            this.recentlyUsedFilters.add(hashCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int frequency(Query query2) {
        assert (!(query2 instanceof BoostQuery));
        assert (!(query2 instanceof ConstantScoreQuery));
        int hashCode = query2.hashCode();
        UsageTrackingQueryCachingPolicy usageTrackingQueryCachingPolicy = this;
        synchronized (usageTrackingQueryCachingPolicy) {
            return this.recentlyUsedFilters.frequency(hashCode);
        }
    }

    @Override
    public boolean shouldCache(Query query2) throws IOException {
        int minFrequency;
        DisjunctionMaxQuery dmq;
        BooleanQuery bq;
        if (query2 instanceof MatchAllDocsQuery || query2 instanceof MatchNoDocsQuery) {
            return false;
        }
        if (query2 instanceof BooleanQuery && (bq = (BooleanQuery)query2).clauses().isEmpty()) {
            return false;
        }
        if (query2 instanceof DisjunctionMaxQuery && (dmq = (DisjunctionMaxQuery)query2).getDisjuncts().isEmpty()) {
            return false;
        }
        int frequency = this.frequency(query2);
        return frequency >= (minFrequency = this.minFrequencyToCache(query2));
    }
}

