/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.highlight;

import java.io.IOException;
import java.util.HashSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.WeightedTerm;

public final class QueryTermExtractor {
    private static final IndexSearcher EMPTY_INDEXSEARCHER;

    public static final WeightedTerm[] getTerms(Query query2) {
        return QueryTermExtractor.getTerms(query2, false);
    }

    public static final WeightedTerm[] getIdfWeightedTerms(Query query2, IndexReader reader, String fieldName) {
        WeightedTerm[] terms = QueryTermExtractor.getTerms(query2, false, fieldName);
        int totalNumDocs = reader.maxDoc();
        for (int i = 0; i < terms.length; ++i) {
            try {
                int docFreq = reader.docFreq(new Term(fieldName, terms[i].term));
                float idf = (float)(Math.log((double)totalNumDocs / (double)(docFreq + 1)) + 1.0);
                terms[i].weight *= idf;
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return terms;
    }

    public static final WeightedTerm[] getTerms(Query query2, boolean prohibited, String fieldName) {
        HashSet<WeightedTerm> terms = new HashSet<WeightedTerm>();
        QueryTermExtractor.getTerms(query2, 1.0f, terms, prohibited, fieldName);
        return terms.toArray(new WeightedTerm[0]);
    }

    public static final WeightedTerm[] getTerms(Query query2, boolean prohibited) {
        return QueryTermExtractor.getTerms(query2, prohibited, null);
    }

    private static final void getTerms(Query query2, float boost, HashSet<WeightedTerm> terms, boolean prohibited, String fieldName) {
        block7: {
            try {
                if (query2 instanceof BoostQuery) {
                    BoostQuery boostQuery = (BoostQuery)query2;
                    QueryTermExtractor.getTerms(boostQuery.getQuery(), boost * boostQuery.getBoost(), terms, prohibited, fieldName);
                    break block7;
                }
                if (query2 instanceof BooleanQuery) {
                    QueryTermExtractor.getTermsFromBooleanQuery((BooleanQuery)query2, boost, terms, prohibited, fieldName);
                    break block7;
                }
                HashSet<Term> nonWeightedTerms = new HashSet<Term>();
                try {
                    EMPTY_INDEXSEARCHER.createNormalizedWeight(query2, false).extractTerms(nonWeightedTerms);
                }
                catch (IOException bogus) {
                    throw new RuntimeException("Should not happen on an empty index", bogus);
                }
                for (Term term : nonWeightedTerms) {
                    if (fieldName != null && !term.field().equals(fieldName)) continue;
                    terms.add(new WeightedTerm(boost, term.text()));
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    private static final void getTermsFromBooleanQuery(BooleanQuery query2, float boost, HashSet<WeightedTerm> terms, boolean prohibited, String fieldName) {
        for (BooleanClause clause : query2) {
            if (!prohibited && clause.getOccur() == BooleanClause.Occur.MUST_NOT) continue;
            QueryTermExtractor.getTerms(clause.getQuery(), boost, terms, prohibited, fieldName);
        }
    }

    static {
        try {
            MultiReader emptyReader = new MultiReader(new IndexReader[0]);
            EMPTY_INDEXSEARCHER = new IndexSearcher(emptyReader);
            EMPTY_INDEXSEARCHER.setQueryCache(null);
        }
        catch (IOException bogus) {
            throw new RuntimeException(bogus);
        }
    }
}

