/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FilterWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BaseGlobalOrdinalScorer;
import org.apache.lucene.search.join.GlobalOrdinalsWithScoreCollector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;

final class GlobalOrdinalsWithScoreQuery
extends Query {
    private final GlobalOrdinalsWithScoreCollector collector;
    private final String joinField;
    private final MultiDocValues.OrdinalMap globalOrds;
    private final Query toQuery;
    private final Query fromQuery;
    private final int min;
    private final int max;
    private final IndexReader indexReader;

    GlobalOrdinalsWithScoreQuery(GlobalOrdinalsWithScoreCollector collector, String joinField, MultiDocValues.OrdinalMap globalOrds, Query toQuery, Query fromQuery, int min2, int max2, IndexReader indexReader) {
        this.collector = collector;
        this.joinField = joinField;
        this.globalOrds = globalOrds;
        this.toQuery = toQuery;
        this.fromQuery = fromQuery;
        this.min = min2;
        this.max = max2;
        this.indexReader = indexReader;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new W(this, this.toQuery.createWeight(searcher, false));
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((GlobalOrdinalsWithScoreQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(GlobalOrdinalsWithScoreQuery other) {
        return this.min == other.min && this.max == other.max && this.joinField.equals(other.joinField) && this.fromQuery.equals(other.fromQuery) && this.toQuery.equals(other.toQuery) && this.indexReader.equals(other.indexReader);
    }

    @Override
    public int hashCode() {
        int result = this.classHash();
        result = 31 * result + this.joinField.hashCode();
        result = 31 * result + this.toQuery.hashCode();
        result = 31 * result + this.fromQuery.hashCode();
        result = 31 * result + this.min;
        result = 31 * result + this.max;
        result = 31 * result + this.indexReader.hashCode();
        return result;
    }

    @Override
    public String toString(String field) {
        return "GlobalOrdinalsQuery{joinField=" + this.joinField + "min=" + this.min + "max=" + this.max + "fromQuery=" + this.fromQuery + '}';
    }

    static final class SegmentOrdinalScorer
    extends BaseGlobalOrdinalScorer {
        final GlobalOrdinalsWithScoreCollector collector;

        public SegmentOrdinalScorer(Weight weight, GlobalOrdinalsWithScoreCollector collector, SortedDocValues values, DocIdSetIterator approximation) {
            super(weight, values, approximation);
            this.collector = collector;
        }

        @Override
        protected TwoPhaseIterator createTwoPhaseIterator(DocIdSetIterator approximation) {
            return new TwoPhaseIterator(approximation){

                @Override
                public boolean matches() throws IOException {
                    int segmentOrd = values.getOrd(this.approximation.docID());
                    if (segmentOrd != -1 && collector.match(segmentOrd)) {
                        score = collector.score(segmentOrd);
                        return true;
                    }
                    return false;
                }

                @Override
                public float matchCost() {
                    return 100.0f;
                }
            };
        }
    }

    static final class OrdinalMapScorer
    extends BaseGlobalOrdinalScorer {
        final LongValues segmentOrdToGlobalOrdLookup;
        final GlobalOrdinalsWithScoreCollector collector;

        public OrdinalMapScorer(Weight weight, GlobalOrdinalsWithScoreCollector collector, SortedDocValues values, DocIdSetIterator approximation, LongValues segmentOrdToGlobalOrdLookup) {
            super(weight, values, approximation);
            this.segmentOrdToGlobalOrdLookup = segmentOrdToGlobalOrdLookup;
            this.collector = collector;
        }

        @Override
        protected TwoPhaseIterator createTwoPhaseIterator(DocIdSetIterator approximation) {
            return new TwoPhaseIterator(approximation){

                @Override
                public boolean matches() throws IOException {
                    int globalOrd;
                    long segmentOrd = values.getOrd(this.approximation.docID());
                    if (segmentOrd != -1L && collector.match(globalOrd = (int)segmentOrdToGlobalOrdLookup.get(segmentOrd))) {
                        score = collector.score(globalOrd);
                        return true;
                    }
                    return false;
                }

                @Override
                public float matchCost() {
                    return 100.0f;
                }
            };
        }
    }

    final class W
    extends FilterWeight {
        W(Query query2, Weight approximationWeight) {
            super(query2, approximationWeight);
        }

        @Override
        public void extractTerms(Set<Term> terms) {
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            SortedDocValues values = DocValues.getSorted(context.reader(), GlobalOrdinalsWithScoreQuery.this.joinField);
            if (values == null) {
                return Explanation.noMatch("Not a match", new Explanation[0]);
            }
            int segmentOrd = values.getOrd(doc);
            if (segmentOrd == -1) {
                return Explanation.noMatch("Not a match", new Explanation[0]);
            }
            BytesRef joinValue = values.lookupOrd(segmentOrd);
            int ord = GlobalOrdinalsWithScoreQuery.this.globalOrds != null ? (int)GlobalOrdinalsWithScoreQuery.this.globalOrds.getGlobalOrds(context.ord).get(segmentOrd) : segmentOrd;
            if (!GlobalOrdinalsWithScoreQuery.this.collector.match(ord)) {
                return Explanation.noMatch("Not a match, join value " + Term.toString(joinValue), new Explanation[0]);
            }
            float score = GlobalOrdinalsWithScoreQuery.this.collector.score(ord);
            return Explanation.match(score, "A match, join value " + Term.toString(joinValue), new Explanation[0]);
        }

        @Override
        public float getValueForNormalization() throws IOException {
            return 1.0f;
        }

        @Override
        public void normalize(float norm, float boost) {
        }

        @Override
        public Scorer scorer(LeafReaderContext context) throws IOException {
            SortedDocValues values = DocValues.getSorted(context.reader(), GlobalOrdinalsWithScoreQuery.this.joinField);
            if (values == null) {
                return null;
            }
            Scorer approximationScorer = this.in.scorer(context);
            if (approximationScorer == null) {
                return null;
            }
            if (GlobalOrdinalsWithScoreQuery.this.globalOrds != null) {
                return new OrdinalMapScorer(this, GlobalOrdinalsWithScoreQuery.this.collector, values, approximationScorer.iterator(), GlobalOrdinalsWithScoreQuery.this.globalOrds.getGlobalOrds(context.ord));
            }
            return new SegmentOrdinalScorer(this, GlobalOrdinalsWithScoreQuery.this.collector, values, approximationScorer.iterator());
        }
    }
}

