/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.BitSet;

public class QueryBitSetProducer
implements BitSetProducer {
    private final Query query;
    private final Map<Object, DocIdSet> cache = Collections.synchronizedMap(new WeakHashMap());

    public QueryBitSetProducer(Query query2) {
        this.query = query2;
    }

    public Query getQuery() {
        return this.query;
    }

    @Override
    public BitSet getBitSet(LeafReaderContext context) throws IOException {
        LeafReader reader = context.reader();
        Object key = reader.getCoreCacheKey();
        DocIdSet docIdSet = this.cache.get(key);
        if (docIdSet == null) {
            IndexReaderContext topLevelContext = ReaderUtil.getTopLevelContext(context);
            IndexSearcher searcher = new IndexSearcher(topLevelContext);
            searcher.setQueryCache(null);
            Weight weight = searcher.createNormalizedWeight(this.query, false);
            Scorer s = weight.scorer(context);
            docIdSet = s == null ? DocIdSet.EMPTY : new BitDocIdSet(BitSet.of(s.iterator(), context.reader().maxDoc()));
            this.cache.put(key, docIdSet);
        }
        return docIdSet == DocIdSet.EMPTY ? null : ((BitDocIdSet)docIdSet).bits();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.query.toString() + ")";
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryBitSetProducer other = (QueryBitSetProducer)o;
        return this.query.equals(other.query);
    }

    public int hashCode() {
        return 31 * this.getClass().hashCode() + this.query.hashCode();
    }
}

