/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.postingshighlight;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.postingshighlight.DefaultPassageFormatter;
import org.apache.lucene.search.postingshighlight.MultiTermHighlighting;
import org.apache.lucene.search.postingshighlight.Passage;
import org.apache.lucene.search.postingshighlight.PassageFormatter;
import org.apache.lucene.search.postingshighlight.PassageScorer;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;

public class PostingsHighlighter {
    private static final IndexSearcher EMPTY_INDEXSEARCHER;
    public static final int DEFAULT_MAX_LENGTH = 10000;
    private final int maxLength;
    private PassageFormatter defaultFormatter;
    private PassageScorer defaultScorer;
    private static final PostingsEnum EMPTY;

    public PostingsHighlighter() {
        this(10000);
    }

    public PostingsHighlighter(int maxLength) {
        if (maxLength < 0 || maxLength == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("maxLength must be < Integer.MAX_VALUE");
        }
        this.maxLength = maxLength;
    }

    protected BreakIterator getBreakIterator(String field) {
        return BreakIterator.getSentenceInstance(Locale.ROOT);
    }

    protected PassageFormatter getFormatter(String field) {
        if (this.defaultFormatter == null) {
            this.defaultFormatter = new DefaultPassageFormatter();
        }
        return this.defaultFormatter;
    }

    protected PassageScorer getScorer(String field) {
        if (this.defaultScorer == null) {
            this.defaultScorer = new PassageScorer();
        }
        return this.defaultScorer;
    }

    public String[] highlight(String field, Query query2, IndexSearcher searcher, TopDocs topDocs) throws IOException {
        return this.highlight(field, query2, searcher, topDocs, 1);
    }

    public String[] highlight(String field, Query query2, IndexSearcher searcher, TopDocs topDocs, int maxPassages) throws IOException {
        Map<String, String[]> res = this.highlightFields(new String[]{field}, query2, searcher, topDocs, new int[]{maxPassages});
        return res.get(field);
    }

    public Map<String, String[]> highlightFields(String[] fields, Query query2, IndexSearcher searcher, TopDocs topDocs) throws IOException {
        int[] maxPassages = new int[fields.length];
        Arrays.fill(maxPassages, 1);
        return this.highlightFields(fields, query2, searcher, topDocs, maxPassages);
    }

    public Map<String, String[]> highlightFields(String[] fields, Query query2, IndexSearcher searcher, TopDocs topDocs, int[] maxPassages) throws IOException {
        ScoreDoc[] scoreDocs = topDocs.scoreDocs;
        int[] docids = new int[scoreDocs.length];
        for (int i = 0; i < docids.length; ++i) {
            docids[i] = scoreDocs[i].doc;
        }
        return this.highlightFields(fields, query2, searcher, docids, maxPassages);
    }

    public Map<String, String[]> highlightFields(String[] fieldsIn, Query query2, IndexSearcher searcher, int[] docidsIn, int[] maxPassagesIn) throws IOException {
        HashMap<String, String[]> snippets = new HashMap<String, String[]>();
        for (Map.Entry<String, Object[]> ent : this.highlightFieldsAsObjects(fieldsIn, query2, searcher, docidsIn, maxPassagesIn).entrySet()) {
            Object[] snippetObjects = ent.getValue();
            String[] snippetStrings = new String[snippetObjects.length];
            snippets.put(ent.getKey(), snippetStrings);
            for (int i = 0; i < snippetObjects.length; ++i) {
                Object snippet = snippetObjects[i];
                if (snippet == null) continue;
                snippetStrings[i] = snippet.toString();
            }
        }
        return snippets;
    }

    protected Map<String, Object[]> highlightFieldsAsObjects(String[] fieldsIn, Query query2, IndexSearcher searcher, int[] docidsIn, int[] maxPassagesIn) throws IOException {
        if (fieldsIn.length < 1) {
            throw new IllegalArgumentException("fieldsIn must not be empty");
        }
        if (fieldsIn.length != maxPassagesIn.length) {
            throw new IllegalArgumentException("invalid number of maxPassagesIn");
        }
        TreeSet<Term> queryTerms = new TreeSet<Term>();
        EMPTY_INDEXSEARCHER.createNormalizedWeight(query2, false).extractTerms(queryTerms);
        IndexReaderContext readerContext = searcher.getIndexReader().getContext();
        List<LeafReaderContext> leaves = readerContext.leaves();
        int[] docids = new int[docidsIn.length];
        System.arraycopy(docidsIn, 0, docids, 0, docidsIn.length);
        final String[] fields = new String[fieldsIn.length];
        System.arraycopy(fieldsIn, 0, fields, 0, fieldsIn.length);
        final int[] maxPassages = new int[maxPassagesIn.length];
        System.arraycopy(maxPassagesIn, 0, maxPassages, 0, maxPassagesIn.length);
        Arrays.sort(docids);
        new InPlaceMergeSorter(){

            @Override
            protected void swap(int i, int j) {
                String tmp = fields[i];
                fields[i] = fields[j];
                fields[j] = tmp;
                int tmp2 = maxPassages[i];
                maxPassages[i] = maxPassages[j];
                maxPassages[j] = tmp2;
            }

            @Override
            protected int compare(int i, int j) {
                return fields[i].compareTo(fields[j]);
            }
        }.sort(0, fields.length);
        String[][] contents = this.loadFieldValues(searcher, fields, docids, this.maxLength);
        HashMap<String, Object[]> highlights = new HashMap<String, Object[]>();
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            int numPassages = maxPassages[i];
            Term floor = new Term(field, "");
            Term ceiling = new Term(field, UnicodeUtil.BIG_TERM);
            SortedSet<Term> fieldTerms = queryTerms.subSet(floor, ceiling);
            BytesRef[] terms = new BytesRef[fieldTerms.size()];
            int termUpto = 0;
            for (Term term : fieldTerms) {
                terms[termUpto++] = term.bytes();
            }
            Map<Integer, Object> fieldHighlights = this.highlightField(field, contents[i], this.getBreakIterator(field), terms, docids, leaves, numPassages, query2);
            Object[] result = new Object[docids.length];
            for (int j = 0; j < docidsIn.length; ++j) {
                result[j] = fieldHighlights.get(docidsIn[j]);
            }
            highlights.put(field, result);
        }
        return highlights;
    }

    protected String[][] loadFieldValues(IndexSearcher searcher, String[] fields, int[] docids, int maxLength) throws IOException {
        String[][] contents = new String[fields.length][docids.length];
        char[] valueSeparators = new char[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            valueSeparators[i] = this.getMultiValuedSeparator(fields[i]);
        }
        LimitedStoredFieldVisitor visitor = new LimitedStoredFieldVisitor(fields, valueSeparators, maxLength);
        for (int i = 0; i < docids.length; ++i) {
            searcher.doc(docids[i], visitor);
            for (int j = 0; j < fields.length; ++j) {
                contents[j][i] = visitor.getValue(j).toString();
            }
            visitor.reset();
        }
        return contents;
    }

    protected char getMultiValuedSeparator(String field) {
        return ' ';
    }

    protected Analyzer getIndexAnalyzer(String field) {
        return null;
    }

    private Map<Integer, Object> highlightField(String field, String[] contents, BreakIterator bi, BytesRef[] terms, int[] docids, List<LeafReaderContext> leaves, int maxPassages, Query query2) throws IOException {
        HashMap<Integer, Object> highlights = new HashMap<Integer, Object>();
        PassageFormatter fieldFormatter = this.getFormatter(field);
        if (fieldFormatter == null) {
            throw new NullPointerException("PassageFormatter must not be null");
        }
        Analyzer analyzer = this.getIndexAnalyzer(field);
        CharacterRunAutomaton[] automata = new CharacterRunAutomaton[]{};
        if (analyzer != null) {
            automata = MultiTermHighlighting.extractAutomata(query2, field);
        }
        if (automata.length > 0) {
            BytesRef[] newTerms = new BytesRef[terms.length + 1];
            System.arraycopy(terms, 0, newTerms, 0, terms.length);
            terms = newTerms;
        }
        PostingsEnum[] postings = null;
        TermsEnum termsEnum = null;
        int lastLeaf = -1;
        for (int i = 0; i < docids.length; ++i) {
            Passage[] passages;
            String content = contents[i];
            if (content.length() == 0) continue;
            bi.setText(content);
            int doc = docids[i];
            int leaf = ReaderUtil.subIndex(doc, leaves);
            LeafReaderContext subContext = leaves.get(leaf);
            LeafReader r = subContext.reader();
            assert (leaf >= lastLeaf);
            if (leaf != lastLeaf) {
                Terms t = r.terms(field);
                if (t != null) {
                    if (!t.hasOffsets()) {
                        throw new IllegalArgumentException("field '" + field + "' was indexed without offsets, cannot highlight");
                    }
                    termsEnum = t.iterator();
                    postings = new PostingsEnum[terms.length];
                } else {
                    termsEnum = null;
                }
            }
            if (termsEnum == null) continue;
            if (automata.length > 0) {
                PostingsEnum dp = MultiTermHighlighting.getDocsEnum(analyzer.tokenStream(field, content), automata);
                dp.advance(doc - subContext.docBase);
                postings[terms.length - 1] = dp;
            }
            if ((passages = this.highlightDoc(field, terms, content.length(), bi, doc - subContext.docBase, termsEnum, postings, maxPassages)).length == 0) {
                passages = this.getEmptyHighlight(field, bi, maxPassages);
            }
            if (passages.length > 0) {
                highlights.put(doc, fieldFormatter.format(passages, content));
            }
            lastLeaf = leaf;
        }
        return highlights;
    }

    private Passage[] highlightDoc(String field, BytesRef[] terms, int contentLength, BreakIterator bi, int doc, TermsEnum termsEnum, PostingsEnum[] postings, int n) throws IOException {
        OffsetsEnum off;
        PassageScorer scorer = this.getScorer(field);
        if (scorer == null) {
            throw new NullPointerException("PassageScorer must not be null");
        }
        PriorityQueue<OffsetsEnum> pq = new PriorityQueue<OffsetsEnum>();
        float[] weights = new float[terms.length];
        for (int i = 0; i < terms.length; ++i) {
            int pDoc;
            PostingsEnum de = postings[i];
            if (de == EMPTY) continue;
            if (de == null) {
                postings[i] = EMPTY;
                if (!termsEnum.seekExact(terms[i])) continue;
                de = postings[i] = termsEnum.postings(null, 56);
                assert (de != null);
                pDoc = de.advance(doc);
            } else {
                pDoc = de.docID();
                if (pDoc < doc) {
                    pDoc = de.advance(doc);
                }
            }
            if (doc != pDoc) continue;
            weights[i] = scorer.weight(contentLength, de.freq());
            de.nextPosition();
            pq.add(new OffsetsEnum(de, i));
        }
        pq.add(new OffsetsEnum(EMPTY, Integer.MAX_VALUE));
        PriorityQueue<Passage> passageQueue = new PriorityQueue<Passage>(n, new Comparator<Passage>(){

            @Override
            public int compare(Passage left, Passage right) {
                if (left.score < right.score) {
                    return -1;
                }
                if (left.score > right.score) {
                    return 1;
                }
                return left.startOffset - right.startOffset;
            }
        });
        Passage current = new Passage();
        while ((off = (OffsetsEnum)pq.poll()) != null) {
            int tf;
            block21: {
                PostingsEnum dp = off.dp;
                int start = dp.startOffset();
                assert (start >= 0);
                int end = dp.endOffset();
                assert (EMPTY.startOffset() == Integer.MAX_VALUE);
                if (start < contentLength && end > contentLength) continue;
                if (start >= current.endOffset) {
                    if (current.startOffset >= 0) {
                        current.score *= scorer.norm(current.startOffset);
                        if (passageQueue.size() == n && current.score < passageQueue.peek().score) {
                            current.reset();
                        } else {
                            passageQueue.offer(current);
                            if (passageQueue.size() > n) {
                                current = passageQueue.poll();
                                current.reset();
                            } else {
                                current = new Passage();
                            }
                        }
                    }
                    if (start >= contentLength) {
                        Passage[] passages = new Passage[passageQueue.size()];
                        passageQueue.toArray(passages);
                        for (Passage p : passages) {
                            p.sort();
                        }
                        Arrays.sort(passages, new Comparator<Passage>(){

                            @Override
                            public int compare(Passage left, Passage right) {
                                return left.startOffset - right.startOffset;
                            }
                        });
                        return passages;
                    }
                    current.startOffset = Math.max(bi.preceding(start + 1), 0);
                    current.endOffset = Math.min(bi.next(), contentLength);
                }
                tf = 0;
                do {
                    ++tf;
                    BytesRef term = terms[off.id];
                    if (term == null) {
                        term = off.dp.getPayload();
                        assert (term != null);
                    }
                    current.addMatch(start, end, term);
                    if (off.pos == dp.freq()) break block21;
                    ++off.pos;
                    dp.nextPosition();
                    start = dp.startOffset();
                    end = dp.endOffset();
                } while (start < current.endOffset && end <= contentLength);
                pq.offer(off);
            }
            current.score += weights[off.id] * scorer.tf(tf, current.endOffset - current.startOffset);
        }
        assert (false);
        return null;
    }

    protected Passage[] getEmptyHighlight(String fieldName, BreakIterator bi, int maxPassages) {
        int next;
        ArrayList<Passage> passages = new ArrayList<Passage>();
        int pos = bi.current();
        assert (pos == 0);
        while (passages.size() < maxPassages && (next = bi.next()) != -1) {
            Passage passage = new Passage();
            passage.score = Float.NaN;
            passage.startOffset = pos;
            passage.endOffset = next;
            passages.add(passage);
            pos = next;
        }
        return passages.toArray(new Passage[passages.size()]);
    }

    static {
        try {
            MultiReader emptyReader = new MultiReader(new IndexReader[0]);
            EMPTY_INDEXSEARCHER = new IndexSearcher(emptyReader);
            EMPTY_INDEXSEARCHER.setQueryCache(null);
        }
        catch (IOException bogus) {
            throw new RuntimeException(bogus);
        }
        EMPTY = new PostingsEnum(){

            @Override
            public int nextPosition() throws IOException {
                return -1;
            }

            @Override
            public int startOffset() throws IOException {
                return Integer.MAX_VALUE;
            }

            @Override
            public int endOffset() throws IOException {
                return Integer.MAX_VALUE;
            }

            @Override
            public BytesRef getPayload() throws IOException {
                return null;
            }

            @Override
            public int freq() throws IOException {
                return 0;
            }

            @Override
            public int docID() {
                return Integer.MAX_VALUE;
            }

            @Override
            public int nextDoc() throws IOException {
                return Integer.MAX_VALUE;
            }

            @Override
            public int advance(int target) throws IOException {
                return Integer.MAX_VALUE;
            }

            @Override
            public long cost() {
                return 0L;
            }
        };
    }

    private static class LimitedStoredFieldVisitor
    extends StoredFieldVisitor {
        private final String[] fields;
        private final char[] valueSeparators;
        private final int maxLength;
        private final StringBuilder[] builders;
        private int currentField = -1;

        public LimitedStoredFieldVisitor(String[] fields, char[] valueSeparators, int maxLength) {
            assert (fields.length == valueSeparators.length);
            this.fields = fields;
            this.valueSeparators = valueSeparators;
            this.maxLength = maxLength;
            this.builders = new StringBuilder[fields.length];
            for (int i = 0; i < this.builders.length; ++i) {
                this.builders[i] = new StringBuilder();
            }
        }

        @Override
        public void stringField(FieldInfo fieldInfo, byte[] bytes) throws IOException {
            String value = new String(bytes, StandardCharsets.UTF_8);
            assert (this.currentField >= 0);
            StringBuilder builder = this.builders[this.currentField];
            if (builder.length() > 0 && builder.length() < this.maxLength) {
                builder.append(this.valueSeparators[this.currentField]);
            }
            if (builder.length() + value.length() > this.maxLength) {
                builder.append(value, 0, this.maxLength - builder.length());
            } else {
                builder.append(value);
            }
        }

        @Override
        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
            this.currentField = Arrays.binarySearch(this.fields, fieldInfo.name);
            if (this.currentField < 0) {
                return StoredFieldVisitor.Status.NO;
            }
            if (this.builders[this.currentField].length() > this.maxLength) {
                return this.fields.length == 1 ? StoredFieldVisitor.Status.STOP : StoredFieldVisitor.Status.NO;
            }
            return StoredFieldVisitor.Status.YES;
        }

        String getValue(int i) {
            return this.builders[i].toString();
        }

        void reset() {
            this.currentField = -1;
            for (int i = 0; i < this.fields.length; ++i) {
                this.builders[i].setLength(0);
            }
        }
    }

    private static class OffsetsEnum
    implements Comparable<OffsetsEnum> {
        PostingsEnum dp;
        int pos;
        int id;

        OffsetsEnum(PostingsEnum dp, int id) throws IOException {
            this.dp = dp;
            this.id = id;
            this.pos = 1;
        }

        @Override
        public int compareTo(OffsetsEnum other) {
            try {
                int off = this.dp.startOffset();
                int otherOff = other.dp.startOffset();
                if (off == otherOff) {
                    return this.id - other.id;
                }
                return Integer.compare(off, otherOff);
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
    }
}

