/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.FilterSpans;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.Spans;

public abstract class SpanPositionCheckQuery
extends SpanQuery
implements Cloneable {
    protected SpanQuery match;

    public SpanPositionCheckQuery(SpanQuery match) {
        this.match = Objects.requireNonNull(match);
    }

    public SpanQuery getMatch() {
        return this.match;
    }

    @Override
    public String getField() {
        return this.match.getField();
    }

    protected abstract FilterSpans.AcceptStatus acceptPosition(Spans var1) throws IOException;

    @Override
    public SpanWeight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        SpanWeight matchWeight = this.match.createWeight(searcher, false);
        return new SpanPositionCheckWeight(matchWeight, searcher, needsScores ? SpanPositionCheckQuery.getTermContexts(matchWeight) : null);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        SpanQuery rewritten = (SpanQuery)this.match.rewrite(reader);
        if (rewritten != this.match) {
            try {
                SpanPositionCheckQuery clone = (SpanPositionCheckQuery)this.clone();
                clone.match = rewritten;
                return clone;
            }
            catch (CloneNotSupportedException e2) {
                throw new AssertionError((Object)e2);
            }
        }
        return super.rewrite(reader);
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.match.equals(((SpanPositionCheckQuery)other).match);
    }

    @Override
    public int hashCode() {
        return this.classHash() ^ this.match.hashCode();
    }

    public class SpanPositionCheckWeight
    extends SpanWeight {
        final SpanWeight matchWeight;

        public SpanPositionCheckWeight(SpanWeight matchWeight, IndexSearcher searcher, Map<Term, TermContext> terms) throws IOException {
            super(SpanPositionCheckQuery.this, searcher, terms);
            this.matchWeight = matchWeight;
        }

        @Override
        public void extractTerms(Set<Term> terms) {
            this.matchWeight.extractTerms(terms);
        }

        @Override
        public void extractTermContexts(Map<Term, TermContext> contexts) {
            this.matchWeight.extractTermContexts(contexts);
        }

        @Override
        public Spans getSpans(LeafReaderContext context, SpanWeight.Postings requiredPostings) throws IOException {
            Spans matchSpans = this.matchWeight.getSpans(context, requiredPostings);
            return matchSpans == null ? null : new FilterSpans(matchSpans){

                @Override
                protected FilterSpans.AcceptStatus accept(Spans candidate) throws IOException {
                    return SpanPositionCheckQuery.this.acceptPosition(candidate);
                }
            };
        }
    }
}

