/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geopoint.search;

import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.spatial.geopoint.document.GeoPointField;
import org.apache.lucene.spatial.geopoint.search.GeoPointMultiTermQuery;
import org.apache.lucene.spatial.geopoint.search.GeoPointTermsEnum;
import org.apache.lucene.util.BytesRef;

final class GeoPointPrefixTermsEnum
extends GeoPointTermsEnum {
    private short shift;
    private long start;
    private long end;
    private boolean hasNext = false;

    public GeoPointPrefixTermsEnum(TermsEnum tenum, GeoPointMultiTermQuery query2) {
        super(tenum, query2);
        this.currentRange = new GeoPointTermsEnum.Range(this, -1L, this.shift, true);
        this.shift = this.maxShift;
        long mask = (1L << this.shift) - 1L;
        this.start = query2.minEncoded & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        this.end = this.start | mask;
    }

    private boolean nextRelation() {
        do {
            PointValues.Relation relation;
            if (this.shift % 9 == 0 && (relation = this.relationImpl.relate(GeoPointField.decodeLatitude(this.start), GeoPointField.decodeLatitude(this.end), GeoPointField.decodeLongitude(this.start), GeoPointField.decodeLongitude(this.end))) != PointValues.Relation.CELL_OUTSIDE_QUERY && (this.shift == this.maxShift || relation == PointValues.Relation.CELL_INSIDE_QUERY)) {
                this.setRange(relation == PointValues.Relation.CELL_CROSSES_QUERY);
                this.advanceVariables();
                return true;
            }
            if (this.shift != this.maxShift && this.relationImpl.cellIntersectsMBR(this.start, this.end)) {
                this.shift = (short)(this.shift - 1);
                this.end = this.start | (1L << this.shift) - 1L;
                continue;
            }
            this.advanceVariables();
        } while (this.shift < 62);
        return false;
    }

    private void setRange(boolean boundary) {
        this.currentRange.start = this.start;
        this.currentRange.shift = this.shift;
        this.currentRange.boundary = boundary;
        this.hasNext = true;
    }

    private void advanceVariables() {
        long shiftMask = 1L << this.shift;
        while ((this.start & shiftMask) == shiftMask) {
            this.shift = (short)(this.shift + 1);
            shiftMask = 1L << this.shift;
        }
        long shiftMOne = shiftMask - 1L;
        this.start = this.start & (shiftMOne ^ 0xFFFFFFFFFFFFFFFFL) | shiftMask;
        this.end = this.start | shiftMOne;
    }

    protected void seek(long term, short res) {
        if (term < this.start && res < this.maxShift) {
            throw new IllegalArgumentException("trying to seek backwards");
        }
        if (term == this.start) {
            return;
        }
        this.shift = res;
        this.start = term;
        this.end = this.start | (1L << this.shift) - 1L;
    }

    @Override
    protected final boolean hasNext() {
        if (!this.hasNext) {
            return this.nextRelation();
        }
        return true;
    }

    @Override
    protected final BytesRef nextSeekTerm(BytesRef term) {
        if (!this.hasNext()) {
            return null;
        }
        GeoPointField.geoCodedToPrefixCoded(this.currentRange.start, this.currentRange.shift, this.currentCellBRB);
        this.hasNext = false;
        return this.currentCellBRB.get();
    }

    @Override
    protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) {
        long encodedTerm = GeoPointField.prefixCodedToGeoCoded(term);
        short termShift = (short)(64 - GeoPointField.getPrefixCodedShift(term));
        while (this.currentRange.compare(encodedTerm, termShift) < 0) {
            if (!this.hasNext()) {
                return FilteredTermsEnum.AcceptStatus.END;
            }
            int peekCompare = this.currentRange.compare(encodedTerm, termShift);
            if (peekCompare > 0) {
                return FilteredTermsEnum.AcceptStatus.NO_AND_SEEK;
            }
            if (peekCompare < 0) {
                this.seek(encodedTerm, termShift);
            }
            this.hasNext = false;
        }
        return FilteredTermsEnum.AcceptStatus.YES;
    }

    @Override
    public boolean boundaryTerm() {
        if (this.currentRange.start == -1L) {
            throw new IllegalStateException("GeoPointTermsEnum empty or not initialized");
        }
        return this.currentRange.boundary;
    }
}

