/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geopoint.search;

import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.spatial.geopoint.document.GeoPointField;
import org.apache.lucene.spatial.geopoint.search.GeoPointMultiTermQuery;
import org.apache.lucene.spatial.geopoint.search.GeoPointNumericTermsEnum;
import org.apache.lucene.spatial.geopoint.search.GeoPointPrefixTermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;

abstract class GeoPointTermsEnum
extends FilteredTermsEnum {
    protected final short maxShift;
    protected Range currentRange;
    protected BytesRef currentCell;
    protected final BytesRefBuilder currentCellBRB = new BytesRefBuilder();
    protected final GeoPointMultiTermQuery.CellComparator relationImpl;

    GeoPointTermsEnum(TermsEnum tenum, GeoPointMultiTermQuery query2) {
        super(tenum);
        this.maxShift = query2.maxShift;
        this.relationImpl = query2.cellComparator;
    }

    static GeoPointTermsEnum newInstance(TermsEnum terms, GeoPointMultiTermQuery query2) {
        if (query2.termEncoding == GeoPointField.TermEncoding.PREFIX) {
            return new GeoPointPrefixTermsEnum(terms, query2);
        }
        if (query2.termEncoding == GeoPointField.TermEncoding.NUMERIC) {
            return new GeoPointNumericTermsEnum(terms, query2);
        }
        throw new IllegalArgumentException("Invalid GeoPoint TermEncoding " + (Object)((Object)query2.termEncoding));
    }

    public boolean boundaryTerm() {
        if (this.currentCell == null) {
            throw new IllegalStateException("GeoPointTermsEnum empty or not initialized");
        }
        return this.currentRange.boundary;
    }

    protected abstract boolean hasNext();

    protected boolean postFilter(double lat, double lon) {
        return this.relationImpl.postFilter(lat, lon);
    }

    class Range
    implements Comparable<Range> {
        protected short shift;
        protected long start;
        protected boolean boundary;

        Range(long lower, short shift, boolean boundary) {
            this.boundary = boundary;
            this.start = lower;
            this.shift = shift;
        }

        @Override
        public int compareTo(Range other) {
            int result = Short.compare(this.shift, other.shift);
            if (result == 0) {
                return Long.compare(this.start, other.start);
            }
            return result;
        }

        protected void set(Range other) {
            this.start = other.start;
            this.shift = other.shift;
            this.boundary = other.boundary;
        }

        protected int compare(long encoded, short shift) {
            int result = Long.compare(this.start, encoded);
            if (result == 0) {
                return Short.compare(shift, this.shift);
            }
            return result;
        }
    }
}

