/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.vector;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.spatial.vector.PointVectorStrategy;
import org.apache.lucene.util.Bits;
import org.locationtech.spatial4j.distance.DistanceCalculator;
import org.locationtech.spatial4j.shape.Point;

public class DistanceValueSource
extends ValueSource {
    private PointVectorStrategy strategy;
    private final Point from;
    private final double multiplier;

    public DistanceValueSource(PointVectorStrategy strategy, Point from, double multiplier) {
        this.strategy = strategy;
        this.from = from;
        this.multiplier = multiplier;
    }

    @Override
    public String description() {
        return "DistanceValueSource(" + this.strategy + ", " + this.from + ")";
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        LeafReader reader = readerContext.reader();
        final NumericDocValues ptX = DocValues.getNumeric(reader, this.strategy.getFieldNameX());
        final NumericDocValues ptY = DocValues.getNumeric(reader, this.strategy.getFieldNameY());
        final Bits validX = DocValues.getDocsWithField(reader, this.strategy.getFieldNameX());
        final Bits validY = DocValues.getDocsWithField(reader, this.strategy.getFieldNameY());
        return new FunctionValues(){
            private final Point from;
            private final DistanceCalculator calculator;
            private final double nullValue;
            {
                this.from = DistanceValueSource.this.from;
                this.calculator = DistanceValueSource.this.strategy.getSpatialContext().getDistCalc();
                this.nullValue = DistanceValueSource.this.strategy.getSpatialContext().isGeo() ? 180.0 * DistanceValueSource.this.multiplier : Double.MAX_VALUE;
            }

            @Override
            public float floatVal(int doc) {
                return (float)this.doubleVal(doc);
            }

            @Override
            public double doubleVal(int doc) {
                if (validX.get(doc)) {
                    assert (validY.get(doc));
                    return this.calculator.distance(this.from, Double.longBitsToDouble(ptX.get(doc)), Double.longBitsToDouble(ptY.get(doc))) * DistanceValueSource.this.multiplier;
                }
                return this.nullValue;
            }

            @Override
            public String toString(int doc) {
                return DistanceValueSource.this.description() + "=" + this.floatVal(doc);
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DistanceValueSource that = (DistanceValueSource)o;
        if (!this.from.equals(that.from)) {
            return false;
        }
        if (!this.strategy.equals(that.strategy)) {
            return false;
        }
        return this.multiplier == that.multiplier;
    }

    @Override
    public int hashCode() {
        return this.from.hashCode();
    }
}

