/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial3d.geom;

import org.apache.lucene.spatial3d.geom.Membership;
import org.apache.lucene.spatial3d.geom.Plane;
import org.apache.lucene.spatial3d.geom.PlanetModel;
import org.apache.lucene.spatial3d.geom.Vector;

public class SidedPlane
extends Plane
implements Membership {
    public final double sigNum;

    public SidedPlane(SidedPlane sidedPlane) {
        super((Vector)sidedPlane, sidedPlane.D);
        this.sigNum = -sidedPlane.sigNum;
    }

    public SidedPlane(double pX, double pY, double pZ, Vector A, Vector B) {
        super(A, B);
        this.sigNum = Math.signum(this.evaluate(pX, pY, pZ));
        if (this.sigNum == 0.0) {
            throw new IllegalArgumentException("Cannot determine sidedness because check point is on plane.");
        }
    }

    public SidedPlane(Vector p, Vector A, Vector B) {
        super(A, B);
        this.sigNum = Math.signum(this.evaluate(p));
        if (this.sigNum == 0.0) {
            throw new IllegalArgumentException("Cannot determine sidedness because check point is on plane.");
        }
    }

    public SidedPlane(Vector p, Vector A, double BX, double BY, double BZ) {
        super(A, BX, BY, BZ);
        this.sigNum = Math.signum(this.evaluate(p));
        if (this.sigNum == 0.0) {
            throw new IllegalArgumentException("Cannot determine sidedness because check point is on plane.");
        }
    }

    public SidedPlane(Vector p, boolean onSide, Vector A, Vector B) {
        super(A, B);
        double d = this.sigNum = onSide ? Math.signum(this.evaluate(p)) : -Math.signum(this.evaluate(p));
        if (this.sigNum == 0.0) {
            throw new IllegalArgumentException("Cannot determine sidedness because check point is on plane.");
        }
    }

    public SidedPlane(Vector p, PlanetModel planetModel, double sinLat) {
        super(planetModel, sinLat);
        this.sigNum = Math.signum(this.evaluate(p));
        if (this.sigNum == 0.0) {
            throw new IllegalArgumentException("Cannot determine sidedness because check point is on plane.");
        }
    }

    public SidedPlane(Vector p, double x, double y) {
        super(x, y);
        this.sigNum = Math.signum(this.evaluate(p));
        if (this.sigNum == 0.0) {
            throw new IllegalArgumentException("Cannot determine sidedness because check point is on plane.");
        }
    }

    public SidedPlane(Vector p, Vector v, double D) {
        super(v, D);
        this.sigNum = Math.signum(this.evaluate(p));
        if (this.sigNum == 0.0) {
            throw new IllegalArgumentException("Cannot determine sidedness because check point is on plane.");
        }
    }

    public SidedPlane(double pX, double pY, double pZ, Vector v, double D) {
        super(v, D);
        this.sigNum = Math.signum(this.evaluate(pX, pY, pZ));
        if (this.sigNum == 0.0) {
            throw new IllegalArgumentException("Cannot determine sidedness because check point is on plane.");
        }
    }

    public static SidedPlane constructNormalizedPerpendicularSidedPlane(Vector insidePoint, Vector normalVector, Vector point1, Vector point2) {
        Vector pointsVector = new Vector(point1.x - point2.x, point1.y - point2.y, point1.z - point2.z);
        Vector newNormalVector = new Vector(normalVector, pointsVector);
        try {
            return new SidedPlane(insidePoint, newNormalVector, -newNormalVector.dotProduct(point1));
        }
        catch (IllegalArgumentException e2) {
            return null;
        }
    }

    public static SidedPlane constructNormalizedThreePointSidedPlane(Vector insidePoint, Vector point1, Vector point2, Vector point3) {
        try {
            Vector planeNormal = new Vector(new Vector(point1.x - point2.x, point1.y - point2.y, point1.z - point2.z), new Vector(point2.x - point3.x, point2.y - point3.y, point2.z - point3.z));
            return new SidedPlane(insidePoint, planeNormal, -planeNormal.dotProduct(point2));
        }
        catch (IllegalArgumentException e2) {
            return null;
        }
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        double evalResult = this.evaluate(x, y, z);
        if (Math.abs(evalResult) < 1.0E-12) {
            return true;
        }
        double sigNum = Math.signum(evalResult);
        return sigNum == this.sigNum;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SidedPlane)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SidedPlane that = (SidedPlane)o;
        return Double.compare(that.sigNum, this.sigNum) == 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.sigNum);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public String toString() {
        return "[A=" + this.x + ", B=" + this.y + ", C=" + this.z + ", D=" + this.D + ", side=" + this.sigNum + "]";
    }
}

