/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaVersion {
    private static final Pattern PRE_JDK9 = Pattern.compile("1\\.(\\d)(\\.(\\d+)(_(\\d+))?)?(-.+)?");
    private static final Pattern JDK9 = Pattern.compile("(\\d+)(\\.(\\d+))?(\\.(\\d+))?((-.+)?(\\+(\\d+)?(-.+)?)?)");
    public static final JavaVersion VERSION = JavaVersion.parse(System.getProperty("java.version"));
    private final String version;
    private final int platform;
    private final int major;
    private final int minor;
    private final int micro;
    private final int update;
    private final String suffix;

    public static JavaVersion parse(String version2) {
        if (version2.startsWith("1.")) {
            return JavaVersion.parsePreJDK9(version2);
        }
        return JavaVersion.parseJDK9(version2);
    }

    private static JavaVersion parsePreJDK9(String version2) {
        Matcher matcher = PRE_JDK9.matcher(version2);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid Java version " + version2);
        }
        int major = 1;
        int minor = Integer.parseInt(matcher.group(1));
        String microGroup = matcher.group(3);
        int micro = microGroup == null || microGroup.isEmpty() ? 0 : Integer.parseInt(microGroup);
        String updateGroup = matcher.group(5);
        int update2 = updateGroup == null || updateGroup.isEmpty() ? 0 : Integer.parseInt(updateGroup);
        String suffix = matcher.group(6);
        return new JavaVersion(version2, minor, major, minor, micro, update2, suffix);
    }

    private static JavaVersion parseJDK9(String version2) {
        Matcher matcher = JDK9.matcher(version2);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid Java version " + version2);
        }
        int major = Integer.parseInt(matcher.group(1));
        String minorGroup = matcher.group(3);
        int minor = minorGroup == null || minorGroup.isEmpty() ? 0 : Integer.parseInt(minorGroup);
        String microGroup = matcher.group(5);
        int micro = microGroup == null || microGroup.isEmpty() ? 0 : Integer.parseInt(microGroup);
        String suffix = matcher.group(6);
        return new JavaVersion(version2, major, major, minor, micro, 0, suffix);
    }

    private JavaVersion(String version2, int platform, int major, int minor, int micro, int update2, String suffix) {
        this.version = version2;
        this.platform = platform;
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.update = update2;
        this.suffix = suffix;
    }

    public String getVersion() {
        return this.version;
    }

    public int getPlatform() {
        return this.platform;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public int getUpdate() {
        return this.update;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String toString() {
        return this.version;
    }
}

