/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.graph;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.GraphWithPerform;
import com.hp.hpl.jena.graph.impl.SimpleBulkUpdateHandler;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTable;
import com.hp.hpl.jena.tdb.store.GraphTDBBase;
import com.hp.hpl.jena.tdb.store.NodeId;
import java.util.Iterator;
import org.openjena.atlas.lib.Tuple;

public class BulkUpdateHandlerTDB
extends SimpleBulkUpdateHandler
implements BulkUpdateHandler {
    GraphTDBBase graphTDB;
    private static final int sliceSize = 1000;

    public BulkUpdateHandlerTDB(GraphTDBBase graph) {
        super((GraphWithPerform)graph);
        this.graphTDB = graph;
    }

    public void remove(Node s, Node p, Node o) {
        s = BulkUpdateHandlerTDB.fix(s);
        p = BulkUpdateHandlerTDB.fix(p);
        o = BulkUpdateHandlerTDB.fix(o);
        this.removeWorker(s, p, o);
        this.manager.notifyEvent((Graph)this.graph, (Object)GraphEvents.remove((Node)s, (Node)p, (Node)o));
    }

    private static Node fix(Node n) {
        return n != null ? n : Node.ANY;
    }

    public void removeAll() {
        this.removeWorker(null, null, null);
        this.notifyRemoveAll();
    }

    private void removeWorker(Node s, Node p, Node o) {
        int len;
        this.graphTDB.startUpdate();
        NodeTupleTable t = this.graphTDB.getNodeTupleTable();
        Node gn = this.graphTDB.getGraphNode();
        Tuple[] array = new Tuple[1000];
        do {
            Iterator<Tuple<NodeId>> iter = null;
            iter = gn == null ? t.findAsNodeIds(s, p, o) : t.findAsNodeIds(gn, s, p, o);
            if (iter == null) {
                return;
            }
            for (len = 0; len < 1000 && iter.hasNext(); ++len) {
                array[len] = iter.next();
            }
            for (int i = 0; i < len; ++i) {
                t.getTupleTable().delete((Tuple<NodeId>)array[i]);
                array[i] = null;
            }
        } while (len >= 1000);
        this.graphTDB.finishUpdate();
    }
}

