/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.migrate;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.ReadWrite;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.sparql.SystemARQ;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.tdb.migrate.DatasetGraphTrackActive;
import org.openjena.atlas.lib.Sync;

public class DatasetGraphWithLock
extends DatasetGraphTrackActive
implements Sync {
    private DatasetGraph dsg;
    private boolean locked;
    private ReadWrite readWrite;

    public DatasetGraphWithLock(DatasetGraph dsg) {
        this.dsg = dsg;
        this.locked = false;
        this.readWrite = null;
    }

    @Override
    protected DatasetGraph get() {
        return this.dsg;
    }

    @Override
    protected void checkActive() {
        if (!this.isInTransaction()) {
            throw new JenaLockException("Not in a locked region");
        }
    }

    @Override
    protected void checkNotActive() {
        if (this.isInTransaction()) {
            throw new JenaLockException("Currently in a locked region");
        }
    }

    @Override
    protected void _begin(ReadWrite readWrite) {
        this.readWrite = readWrite;
        boolean b = readWrite == ReadWrite.READ;
        this.dsg.getLock().enterCriticalSection(b);
        this.locked = true;
    }

    @Override
    protected void _commit() {
        if (this.readWrite == ReadWrite.WRITE) {
            this.sync();
        }
        this.locked = false;
        this.dsg.getLock().leaveCriticalSection();
    }

    @Override
    protected void _abort() {
        this.locked = false;
        throw new JenaLockException("Can't abort a locked update");
    }

    @Override
    protected void _end() {
        if (this.locked) {
            this.dsg.getLock().leaveCriticalSection();
        }
        this.locked = false;
    }

    @Override
    protected void _close() {
        if (this.dsg != null) {
            this.dsg.close();
        }
        this.dsg = null;
    }

    public void sync() {
        SystemARQ.sync((DatasetGraph)this.dsg);
        SystemARQ.sync((Graph)this.dsg.getDefaultGraph());
    }

    static class JenaLockException
    extends JenaException {
        public JenaLockException() {
        }

        public JenaLockException(String message) {
            super(message);
        }

        public JenaLockException(Throwable cause) {
            super(cause);
        }

        public JenaLockException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

