/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.migrate;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.tdb.migrate.GraphUnionRead;
import java.util.Iterator;
import java.util.List;
import org.openjena.atlas.iterator.Iter;

public class GraphOps {
    public static boolean containsGraph(DatasetGraph dsg, Node gn) {
        if (Quad.isDefaultGraphExplicit((Node)gn)) {
            return true;
        }
        if (Quad.isUnionGraph((Node)gn)) {
            return true;
        }
        return dsg.containsGraph(gn);
    }

    public static Graph getGraph(DatasetGraph dsg, Node gn) {
        if (Quad.isDefaultGraphExplicit((Node)gn)) {
            return dsg.getDefaultGraph();
        }
        if (Quad.isUnionGraph((Node)gn)) {
            return GraphOps.unionGraph(dsg);
        }
        return dsg.getGraph(gn);
    }

    public static Graph unionGraph(DatasetGraph dsg) {
        List x = Iter.toList((Iterator)dsg.listGraphNodes());
        return new GraphUnionRead(dsg, x);
    }
}

