/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.nodetable;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.index.TupleIndex;
import com.hp.hpl.jena.tdb.index.TupleTable;
import com.hp.hpl.jena.tdb.lib.TupleLib;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTable;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.sys.DatasetControl;
import java.util.Iterator;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.iterator.NullIterator;
import org.openjena.atlas.lib.Tuple;

public class NodeTupleTableConcrete
implements NodeTupleTable {
    protected final NodeTable nodeTable;
    protected final TupleTable tupleTable;
    private final DatasetControl dsPolicy;

    public NodeTupleTableConcrete(int N, TupleIndex[] indexes, NodeTable nodeTable, DatasetControl dsControl) {
        if (indexes.length == 0 || indexes[0] == null) {
            throw new TDBException("A primary index is required");
        }
        for (TupleIndex index : indexes) {
            if (N == index.getTupleLength()) continue;
            throw new TDBException(String.format("Inconsistent: TupleTable width is %d but index %s is %d", N, index.getMapping(), index.getTupleLength()));
        }
        this.dsPolicy = dsControl;
        this.tupleTable = new TupleTable(N, indexes);
        this.nodeTable = nodeTable;
    }

    private void startWrite() {
        this.dsPolicy.startUpdate();
    }

    private void finishWrite() {
        this.dsPolicy.finishUpdate();
    }

    private void startRead() {
        this.dsPolicy.startRead();
    }

    private void finishRead() {
        this.dsPolicy.finishRead();
    }

    @Override
    public DatasetControl getPolicy() {
        return this.dsPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addRow(Node ... nodes) {
        try {
            this.startWrite();
            Object[] n = new NodeId[nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                n[i] = this.nodeTable.getAllocateNodeId(nodes[i]);
            }
            Tuple t = Tuple.create((Object[])n);
            boolean bl = this.tupleTable.add((Tuple<NodeId>)t);
            return bl;
        }
        finally {
            this.finishWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteRow(Node ... nodes) {
        try {
            this.startWrite();
            Object[] n = new NodeId[nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                NodeId id = this.idForNode(nodes[i]);
                if (NodeId.isDoesNotExist(id)) {
                    boolean bl = false;
                    return bl;
                }
                n[i] = id;
            }
            Tuple t = Tuple.create((Object[])n);
            boolean bl = this.tupleTable.delete((Tuple<NodeId>)t);
            return bl;
        }
        finally {
            this.finishWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Tuple<Node>> find(Node ... nodes) {
        try {
            this.startRead();
            Iterator<Tuple<NodeId>> iter1 = this.findAsNodeIds(nodes);
            if (iter1 == null) {
                NullIterator nullIterator = new NullIterator();
                return nullIterator;
            }
            Iterator<Tuple<Node>> iter2 = TupleLib.convertToNodes(this.nodeTable, iter1);
            Iterator<Tuple<Node>> iterator = this.iteratorControl(iter2);
            return iterator;
        }
        finally {
            this.finishRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Tuple<NodeId>> findAsNodeIds(Node ... nodes) {
        NodeId[] n = new NodeId[nodes.length];
        try {
            this.startRead();
            for (int i = 0; i < nodes.length; ++i) {
                NodeId id = this.idForNode(nodes[i]);
                if (NodeId.isDoesNotExist(id)) {
                    Iterator iterator = Iter.nullIterator();
                    return iterator;
                }
                n[i] = id;
            }
            Iterator<Tuple<NodeId>> iterator = this.find(n);
            return iterator;
        }
        finally {
            this.finishRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Tuple<NodeId>> find(NodeId ... ids) {
        Tuple tuple = Tuple.create((Object[])ids);
        this.startRead();
        try {
            Iterator<Tuple<NodeId>> iterator = this.find((Tuple<NodeId>)tuple);
            return iterator;
        }
        finally {
            this.finishRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Tuple<NodeId>> find(Tuple<NodeId> tuple) {
        try {
            this.startRead();
            Iterator<Tuple<NodeId>> iter = this.tupleTable.find(tuple);
            Iterator<Tuple<NodeId>> iterator = this.iteratorControl(iter);
            return iterator;
        }
        finally {
            this.finishRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Tuple<NodeId>> findAll() {
        try {
            this.startRead();
            Iterator<Tuple<NodeId>> iterator = this.iteratorControl(this.tupleTable.getIndex(0).all());
            return iterator;
        }
        finally {
            this.finishRead();
        }
    }

    protected final NodeId idForNode(Node node) {
        if (node == null || node == Node.ANY) {
            return NodeId.NodeIdAny;
        }
        if (node.isVariable()) {
            throw new TDBException("Can't pass variables to NodeTupleTable.find*");
        }
        return this.nodeTable.getNodeIdForNode(node);
    }

    @Override
    public final TupleTable getTupleTable() {
        return this.tupleTable;
    }

    @Override
    public final NodeTable getNodeTable() {
        return this.nodeTable;
    }

    @Override
    public boolean isEmpty() {
        return this.tupleTable.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        try {
            this.startWrite();
            this.tupleTable.clear();
        }
        finally {
            this.finishWrite();
        }
    }

    @Override
    public long size() {
        return this.tupleTable.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        try {
            this.startWrite();
            this.tupleTable.close();
            this.nodeTable.close();
        }
        finally {
            this.finishWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sync() {
        try {
            this.startWrite();
            this.tupleTable.sync();
            this.nodeTable.sync();
        }
        finally {
            this.finishWrite();
        }
    }

    private <T> Iterator<T> iteratorControl(Iterator<T> iter) {
        return this.dsPolicy.iteratorControl(iter);
    }
}

