/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.setup;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderLib;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import com.hp.hpl.jena.sparql.sse.SSEParseException;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.file.BufferChannel;
import com.hp.hpl.jena.tdb.base.file.FileSet;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.index.TupleIndex;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.setup.BlockMgrBuilder;
import com.hp.hpl.jena.tdb.setup.Builder;
import com.hp.hpl.jena.tdb.setup.DatasetBuilder;
import com.hp.hpl.jena.tdb.setup.IndexBuilder;
import com.hp.hpl.jena.tdb.setup.NodeTableBuilder;
import com.hp.hpl.jena.tdb.setup.ObjectFileBuilder;
import com.hp.hpl.jena.tdb.setup.RangeIndexBuilder;
import com.hp.hpl.jena.tdb.setup.SystemParams;
import com.hp.hpl.jena.tdb.setup.TupleIndexBuilder;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.DatasetPrefixesTDB;
import com.hp.hpl.jena.tdb.store.QuadTable;
import com.hp.hpl.jena.tdb.store.StoreConfig;
import com.hp.hpl.jena.tdb.store.TripleTable;
import com.hp.hpl.jena.tdb.sys.DatasetControl;
import com.hp.hpl.jena.tdb.sys.DatasetControlMRSW;
import com.hp.hpl.jena.tdb.sys.FileRef;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import java.util.HashMap;
import java.util.Map;
import org.openjena.atlas.lib.ColumnMap;
import org.openjena.atlas.lib.StrUtils;
import org.slf4j.Logger;

public class DatasetBuilderStd
implements DatasetBuilder {
    private static final Logger log = TDB.logInfo;
    private NodeTableBuilder nodeTableBuilder;
    private TupleIndexBuilder tupleIndexBuilder;
    private SystemParams params;
    private Map<FileRef, BlockMgr> blockMgrs = new HashMap<FileRef, BlockMgr>();
    private Map<FileRef, BufferChannel> bufferChannels = new HashMap<FileRef, BufferChannel>();
    private Map<FileRef, NodeTable> nodeTables = new HashMap<FileRef, NodeTable>();
    private static boolean warnAboutOptimizer = true;

    public static DatasetGraphTDB build(Location location) {
        DatasetBuilderStd x = new DatasetBuilderStd();
        x.setStd();
        return x.build(location, null);
    }

    public static DatasetGraphTDB build() {
        DatasetBuilderStd x = new DatasetBuilderStd();
        x.setStd();
        return x.build(Location.mem(), null);
    }

    public static DatasetBuilderStd stdBuilder() {
        DatasetBuilderStd x = new DatasetBuilderStd();
        x.setStd();
        return x;
    }

    protected DatasetBuilderStd() {
    }

    public DatasetBuilderStd(BlockMgrBuilder blockMgrBuilder, NodeTableBuilder nodeTableBuilder) {
        this.set(blockMgrBuilder, nodeTableBuilder);
    }

    protected void setAll(NodeTableBuilder nodeTableBuilder, TupleIndexBuilder tupleIndexBuilder, IndexBuilder indexBuilder, RangeIndexBuilder rangeIndexBuilder, BlockMgrBuilder blockMgrBuilder, ObjectFileBuilder objectFileBuilder) {
        this.nodeTableBuilder = nodeTableBuilder;
        this.tupleIndexBuilder = tupleIndexBuilder;
    }

    protected void set(NodeTableBuilder nodeTableBuilder, TupleIndexBuilder tupleIndexBuilder, RangeIndexBuilder rangeIndexBuilder) {
        this.nodeTableBuilder = nodeTableBuilder;
        this.tupleIndexBuilder = tupleIndexBuilder;
    }

    protected void set(BlockMgrBuilder blockMgrBuilder, NodeTableBuilder nodeTableBuilder) {
        Recorder recorder = new Recorder(this);
        BlockMgrBuilderRecorder blockMgrBuilderRec = new BlockMgrBuilderRecorder(blockMgrBuilder, recorder);
        Builder.IndexBuilderStd indexBuilder = new Builder.IndexBuilderStd(blockMgrBuilderRec, blockMgrBuilderRec);
        Builder.RangeIndexBuilderStd rangeIndexBuilder = new Builder.RangeIndexBuilderStd(blockMgrBuilderRec, blockMgrBuilderRec);
        this.nodeTableBuilder = nodeTableBuilder;
        nodeTableBuilder = new NodeTableBuilderRecorder(nodeTableBuilder, recorder);
        Builder.TupleIndexBuilderStd tupleIndexBuilder = new Builder.TupleIndexBuilderStd(rangeIndexBuilder);
        this.set(nodeTableBuilder, tupleIndexBuilder, rangeIndexBuilder);
    }

    protected void setStd() {
        Builder.ObjectFileBuilderStd objectFileBuilder = new Builder.ObjectFileBuilderStd();
        Builder.BlockMgrBuilderStd blockMgrBuilder = new Builder.BlockMgrBuilderStd();
        Builder.IndexBuilderStd indexBuilderNT = new Builder.IndexBuilderStd(blockMgrBuilder, blockMgrBuilder);
        Builder.NodeTableBuilderStd nodeTableBuilder = new Builder.NodeTableBuilderStd(indexBuilderNT, objectFileBuilder);
        this.set(blockMgrBuilder, nodeTableBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatasetGraphTDB build(Location location, SystemParams params) {
        if (params == null) {
            params = SystemParams.getStdSystemParams();
        }
        Class<DatasetBuilderStd> clazz = DatasetBuilderStd.class;
        synchronized (DatasetBuilderStd.class) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this._build(location, params);
        }
    }

    protected DatasetGraphTDB _build(Location location, SystemParams _params) {
        this.params = _params;
        this.init(location);
        DatasetControl policy = this.createConcurrencyPolicy();
        NodeTable nodeTable = this.makeNodeTable(location, this.params.indexNode2Id, this.params.indexId2Node, this.params.Node2NodeIdCacheSize, this.params.NodeId2NodeCacheSize, this.params.NodeMissCacheSize);
        TripleTable tripleTable = this.makeTripleTable(location, nodeTable, policy);
        QuadTable quadTable = this.makeQuadTable(location, nodeTable, policy);
        DatasetPrefixesTDB prefixes = this.makePrefixTable(location, policy);
        ReorderTransformation transform = this.chooseReorderTransformation(location);
        StoreConfig storeConfig = new StoreConfig(location, this.params, this.blockMgrs, this.bufferChannels, this.nodeTables);
        DatasetGraphTDB dsg = new DatasetGraphTDB(tripleTable, quadTable, prefixes, transform, storeConfig);
        return dsg;
    }

    protected DatasetControl createConcurrencyPolicy() {
        return new DatasetControlMRSW();
    }

    protected void init(Location location) {
    }

    protected TripleTable makeTripleTable(Location location, NodeTable nodeTable, DatasetControl policy) {
        String primary = this.params.primaryIndexTriples;
        String[] indexes = this.params.tripleIndexes;
        if (indexes.length != 3) {
            DatasetBuilderStd.error(log, "Wrong number of triple table indexes: " + StrUtils.strjoin((String)",", (String[])indexes));
        }
        log.debug("Triple table: " + primary + " :: " + StrUtils.strjoin((String)",", (String[])indexes));
        TupleIndex[] tripleIndexes = this.makeTupleIndexes(location, primary, indexes);
        if (tripleIndexes.length != indexes.length) {
            DatasetBuilderStd.error(log, "Wrong number of triple table tuples indexes: " + tripleIndexes.length);
        }
        TripleTable tripleTable = new TripleTable(tripleIndexes, nodeTable, policy);
        return tripleTable;
    }

    protected QuadTable makeQuadTable(Location location, NodeTable nodeTable, DatasetControl policy) {
        String primary = this.params.primaryIndexQuads;
        String[] indexes = this.params.quadIndexes;
        if (indexes.length != 6) {
            DatasetBuilderStd.error(log, "Wrong number of quad table indexes: " + StrUtils.strjoin((String)",", (String[])indexes));
        }
        log.debug("Quad table: " + primary + " :: " + StrUtils.strjoin((String)",", (String[])indexes));
        TupleIndex[] quadIndexes = this.makeTupleIndexes(location, primary, indexes);
        if (quadIndexes.length != indexes.length) {
            DatasetBuilderStd.error(log, "Wrong number of quad table tuples indexes: " + quadIndexes.length);
        }
        QuadTable quadTable = new QuadTable(quadIndexes, nodeTable, policy);
        return quadTable;
    }

    protected DatasetPrefixesTDB makePrefixTable(Location location, DatasetControl policy) {
        String primary = this.params.primaryIndexPrefix;
        String[] indexes = this.params.prefixIndexes;
        TupleIndex[] prefixIndexes = this.makeTupleIndexes(location, primary, indexes, new String[]{this.params.indexPrefix});
        if (prefixIndexes.length != 1) {
            DatasetBuilderStd.error(log, "Wrong number of triple table tuples indexes: " + prefixIndexes.length);
        }
        String pnNode2Id = this.params.prefixNode2Id;
        String pnId2Node = this.params.prefixId2Node;
        NodeTable prefixNodes = this.makeNodeTable(location, pnNode2Id, pnId2Node, -1, -1, -1);
        DatasetPrefixesTDB prefixes = new DatasetPrefixesTDB(prefixIndexes, prefixNodes, policy);
        log.debug("Prefixes: " + primary + " :: " + StrUtils.strjoin((String)",", (String[])indexes));
        return prefixes;
    }

    protected ReorderTransformation chooseReorderTransformation(Location location) {
        return DatasetBuilderStd.chooseOptimizer(location);
    }

    private TupleIndex[] makeTupleIndexes(Location location, String primary, String[] indexNames) {
        return this.makeTupleIndexes(location, primary, indexNames, indexNames);
    }

    private TupleIndex[] makeTupleIndexes(Location location, String primary, String[] indexNames, String[] filenames) {
        if (primary.length() != 3 && primary.length() != 4) {
            DatasetBuilderStd.error(log, "Bad primary key length: " + primary.length());
        }
        int indexRecordLen = primary.length() * 8;
        TupleIndex[] indexes = new TupleIndex[indexNames.length];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = this.makeTupleIndex(location, filenames[i], primary, indexNames[i]);
        }
        return indexes;
    }

    protected TupleIndex makeTupleIndex(Location location, String name, String primary, String indexOrder) {
        FileSet fs = new FileSet(location, name);
        ColumnMap colMap = new ColumnMap(primary, indexOrder);
        return this.tupleIndexBuilder.buildTupleIndex(fs, colMap, indexOrder);
    }

    protected NodeTable makeNodeTable(Location location, String indexNode2Id, String indexId2Node, int sizeNode2NodeIdCache, int sizeNodeId2NodeCache, int sizeNodeMissCache) {
        FileSet fsNodeToId = new FileSet(location, indexNode2Id);
        FileSet fsId2Node = new FileSet(location, indexId2Node);
        NodeTable nt = this.nodeTableBuilder.buildNodeTable(fsNodeToId, fsId2Node, sizeNode2NodeIdCache, sizeNodeId2NodeCache, sizeNodeMissCache);
        return nt;
    }

    private static void error(Logger log, String msg) {
        if (log != null) {
            log.error(msg);
        }
        throw new TDBException(msg);
    }

    private static int parseInt(String str, String messageBase) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException ex) {
            DatasetBuilderStd.error(log, messageBase + ": " + str);
            return -1;
        }
    }

    public static void setOptimizerWarningFlag(boolean b) {
        warnAboutOptimizer = b;
    }

    public static ReorderTransformation chooseOptimizer(Location location) {
        if (location == null) {
            return ReorderLib.identity();
        }
        ReorderTransformation reorder = null;
        if (location.exists("stats.opt")) {
            try {
                reorder = ReorderLib.weighted((String)location.getPath("stats.opt"));
                log.debug("Statistics-based BGP optimizer");
            }
            catch (SSEParseException ex) {
                log.warn("Error in stats file: " + ex.getMessage());
                reorder = null;
            }
        }
        if (reorder == null && location.exists("fixed.opt")) {
            reorder = ReorderLib.fixed();
            log.debug("Fixed pattern BGP optimizer");
        }
        if (location.exists("none.opt")) {
            reorder = ReorderLib.identity();
            log.debug("Optimizer explicitly turned off");
        }
        if (reorder == null) {
            reorder = SystemTDB.defaultOptimizer;
        }
        if (reorder == null && warnAboutOptimizer) {
            ARQ.getExecLogger().warn("No BGP optimizer");
        }
        return reorder;
    }

    static class Recorder
    implements RecordBlockMgr,
    RecordNodeTable {
        private DatasetBuilderStd dsBuilder;

        Recorder(DatasetBuilderStd dsBuilder) {
            this.dsBuilder = dsBuilder;
        }

        @Override
        public void record(FileRef fileRef, BlockMgr blockMgr) {
            this.dsBuilder.blockMgrs.put(fileRef, blockMgr);
        }

        @Override
        public void record(FileRef fileRef, NodeTable nodeTable) {
            this.dsBuilder.nodeTables.put(fileRef, nodeTable);
        }
    }

    static class BlockMgrBuilderRecorder
    implements BlockMgrBuilder {
        private BlockMgrBuilder builder;
        private RecordBlockMgr recorder;

        BlockMgrBuilderRecorder(BlockMgrBuilder blkMgrBuilder, RecordBlockMgr recorder) {
            this.builder = blkMgrBuilder;
            this.recorder = recorder;
        }

        @Override
        public BlockMgr buildBlockMgr(FileSet fileSet, String ext, int blockSize) {
            BlockMgr blkMgr = this.builder.buildBlockMgr(fileSet, ext, blockSize);
            FileRef ref = FileRef.create(fileSet, ext);
            this.recorder.record(ref, blkMgr);
            return blkMgr;
        }
    }

    static class NodeTableBuilderRecorder
    implements NodeTableBuilder {
        private NodeTableBuilder builder;
        private RecordNodeTable recorder;

        NodeTableBuilderRecorder(NodeTableBuilder ntb, RecordNodeTable recorder) {
            this.builder = ntb;
            this.recorder = recorder;
        }

        @Override
        public NodeTable buildNodeTable(FileSet fsIndex, FileSet fsObjectFile, int sizeNode2NodeIdCache, int sizeNodeId2NodeCache, int sizeNodeMissCacheSize) {
            NodeTable nt = this.builder.buildNodeTable(fsIndex, fsObjectFile, sizeNode2NodeIdCache, sizeNodeId2NodeCache, sizeNodeMissCacheSize);
            FileRef ref = FileRef.create(fsObjectFile.filename("dat"));
            this.recorder.record(ref, nt);
            return nt;
        }
    }

    static interface RecordNodeTable {
        public void record(FileRef var1, NodeTable var2);
    }

    static interface RecordBlockMgr {
        public void record(FileRef var1, BlockMgr var2);
    }
}

