/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.transaction;

import com.hp.hpl.jena.query.ReadWrite;
import com.hp.hpl.jena.tdb.base.block.Block;
import com.hp.hpl.jena.tdb.base.block.BlockException;
import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.sys.FileRef;
import com.hp.hpl.jena.tdb.transaction.JournalEntryType;
import com.hp.hpl.jena.tdb.transaction.Transaction;
import com.hp.hpl.jena.tdb.transaction.TransactionLifecycle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openjena.atlas.logging.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockMgrJournal
implements BlockMgr,
TransactionLifecycle {
    private static Logger log = LoggerFactory.getLogger(BlockMgrJournal.class);
    private BlockMgr blockMgr;
    private Transaction transaction;
    private FileRef fileRef;
    private final Set<Long> readBlocks = new HashSet<Long>();
    private final Set<Long> iteratorBlocks = new HashSet<Long>();
    private final Map<Long, Block> writeBlocks = new HashMap<Long, Block>();
    private final Map<Long, Block> freedBlocks = new HashMap<Long, Block>();
    private boolean closed = false;

    public BlockMgrJournal(Transaction txn, FileRef fileRef, BlockMgr underlyingBlockMgr) {
        this.reset(txn, fileRef, underlyingBlockMgr);
        if (txn.getMode() == ReadWrite.READ && underlyingBlockMgr instanceof BlockMgrJournal) {
            System.err.println("Two level BlockMgrJournal");
        }
    }

    @Override
    public void begin(Transaction txn) {
        this.reset(txn, this.fileRef, this.blockMgr);
    }

    @Override
    public void commitPrepare(Transaction txn) {
        for (Block blk : this.writeBlocks.values()) {
            this.writeJournalEntry(blk);
        }
    }

    @Override
    public void commitEnact(Transaction txn) {
    }

    @Override
    public void abort(Transaction txn) {
    }

    @Override
    public void commitClearup(Transaction txn) {
        this.reset(txn);
    }

    private void reset(Transaction txn, FileRef fileRef, BlockMgr underlyingBlockMgr) {
        this.fileRef = fileRef;
        this.blockMgr = underlyingBlockMgr;
        this.reset(txn);
    }

    private void reset(Transaction txn) {
        this.transaction = txn;
        this.readBlocks.clear();
        this.iteratorBlocks.clear();
        this.writeBlocks.clear();
        this.freedBlocks.clear();
    }

    @Override
    public Block allocate(int blockSize) {
        this.checkIfClosed();
        Block block = this.blockMgr.allocate(blockSize);
        block = block.replicate();
        this.writeBlocks.put(block.getId(), block);
        return block;
    }

    @Override
    public Block getRead(long id) {
        this.checkIfClosed();
        Block block = this.localBlock(id);
        if (block != null) {
            return block;
        }
        block = this.blockMgr.getRead(id);
        this.readBlocks.add(block.getId());
        return block;
    }

    @Override
    public Block getReadIterator(long id) {
        this.checkIfClosed();
        Block block = this.localBlock(id);
        if (block == null) {
            block = this.blockMgr.getReadIterator(id);
        }
        if (block == null) {
            throw new BlockException("No such block: " + this.getLabel() + " " + id);
        }
        this.iteratorBlocks.add(block.getId());
        return block;
    }

    @Override
    public Block getWrite(long id) {
        this.checkIfClosed();
        Block block = this.localBlock(id);
        if (block != null) {
            return block;
        }
        block = this.blockMgr.getRead(id);
        block = this._promote(block);
        return block;
    }

    private Block localBlock(long id) {
        this.checkIfClosed();
        return this.writeBlocks.get(id);
    }

    @Override
    public Block promote(Block block) {
        this.checkIfClosed();
        if (this.writeBlocks.containsKey(block.getId())) {
            return block;
        }
        return this._promote(block);
    }

    private Block _promote(Block block) {
        block = block.replicate();
        this.writeBlocks.put(block.getId(), block);
        return block;
    }

    @Override
    public void release(Block block) {
        this.checkIfClosed();
        Long id = block.getId();
        if (!this.writeBlocks.containsKey(id)) {
            this.blockMgr.release(block);
        }
    }

    @Override
    public void write(Block block) {
        this.checkIfClosed();
        if (!block.isModified()) {
            Log.warn((Object)this, (String)("Page for block " + this.fileRef + "/" + block.getId() + " not modified"));
        }
        if (!this.writeBlocks.containsKey(block.getId())) {
            Log.warn((Object)this, (String)("Block not recognized: " + block.getId()));
            this.writeBlocks.put(block.getId(), block);
        }
    }

    @Override
    public void overwrite(Block block) {
        this.blockMgr.overwrite(block);
    }

    @Override
    public void free(Block block) {
        this.checkIfClosed();
        this.freedBlocks.put(block.getId(), block);
    }

    @Override
    public boolean isEmpty() {
        this.checkIfClosed();
        return this.writeBlocks.isEmpty() && this.blockMgr.isEmpty();
    }

    @Override
    public boolean valid(int id) {
        this.checkIfClosed();
        if (this.writeBlocks.containsKey(id)) {
            return true;
        }
        return this.blockMgr.valid(id);
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    private void checkIfClosed() {
        if (this.closed) {
            Log.fatal((Object)this, (String)("Already closed: " + this.transaction.getTxnId()));
        }
    }

    @Override
    public void sync() {
        this.checkIfClosed();
    }

    @Override
    public void syncForce() {
        this.blockMgr.syncForce();
    }

    @Override
    public void beginUpdate() {
        this.checkIfClosed();
        this.blockMgr.beginRead();
    }

    @Override
    public void endUpdate() {
        this.checkIfClosed();
        this.blockMgr.endRead();
    }

    private void writeJournalEntry(Block blk) {
        blk.getByteBuffer().rewind();
        this.transaction.getJournal().write(JournalEntryType.Block, this.fileRef, blk);
    }

    private void logState() {
        Log.info((Object)this, (String)("state: " + this.getLabel()));
        Log.info((Object)this, (String)("  readBlocks:      " + this.readBlocks));
        Log.info((Object)this, (String)("  writeBlocks:     " + this.writeBlocks));
        Log.info((Object)this, (String)("  iteratorBlocks:  " + this.iteratorBlocks));
        Log.info((Object)this, (String)("  freedBlocks:     " + this.freedBlocks));
    }

    @Override
    public void beginRead() {
        this.checkIfClosed();
        this.blockMgr.beginRead();
    }

    @Override
    public void endRead() {
        this.checkIfClosed();
        this.blockMgr.endRead();
    }

    @Override
    public void beginIterator(Iterator<?> iterator) {
        this.checkIfClosed();
        this.transaction.addIterator(iterator);
    }

    @Override
    public void endIterator(Iterator<?> iterator) {
        this.checkIfClosed();
        this.transaction.removeIterator(iterator);
    }

    public String toString() {
        return "Journal:" + this.fileRef.getFilename() + " (" + this.blockMgr.getClass().getSimpleName() + ")";
    }

    @Override
    public String getLabel() {
        return this.fileRef.getFilename();
    }
}

