/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.transaction;

import com.hp.hpl.jena.query.ReadWrite;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockMgrLogger;
import com.hp.hpl.jena.tdb.base.block.BlockMgrReadonly;
import com.hp.hpl.jena.tdb.base.file.FileFactory;
import com.hp.hpl.jena.tdb.base.file.FileSet;
import com.hp.hpl.jena.tdb.base.objectfile.ObjectFile;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.IndexMap;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.nodetable.NodeTableInline;
import com.hp.hpl.jena.tdb.nodetable.NodeTableReadonly;
import com.hp.hpl.jena.tdb.setup.BlockMgrBuilder;
import com.hp.hpl.jena.tdb.setup.DatasetBuilderStd;
import com.hp.hpl.jena.tdb.setup.NodeTableBuilder;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.sys.FileRef;
import com.hp.hpl.jena.tdb.transaction.BlockMgrJournal;
import com.hp.hpl.jena.tdb.transaction.DatasetGraphTxn;
import com.hp.hpl.jena.tdb.transaction.NodeTableTrans;
import com.hp.hpl.jena.tdb.transaction.Transaction;
import com.hp.hpl.jena.tdb.transaction.TransactionManager;
import java.util.Map;

public class DatasetBuilderTxn {
    private TransactionManager txnMgr;
    private Map<FileRef, BlockMgr> blockMgrs;
    private Map<FileRef, NodeTable> nodeTables;
    private Transaction txn;
    private DatasetGraphTDB dsg;

    public DatasetBuilderTxn(TransactionManager txnMgr) {
        this.txnMgr = txnMgr;
    }

    public DatasetGraphTDB build(Transaction transaction, ReadWrite mode, DatasetGraphTDB dsg) {
        DatasetGraphTDB dsgTxn;
        this.blockMgrs = dsg.getConfig().blockMgrs;
        this.nodeTables = dsg.getConfig().nodeTables;
        this.txn = transaction;
        this.dsg = dsg;
        switch (mode) {
            case READ: {
                dsgTxn = this.buildReadonly();
                break;
            }
            case WRITE: {
                dsgTxn = this.buildWritable();
                break;
            }
            default: {
                dsgTxn = null;
            }
        }
        dsgTxn = new DatasetGraphTxn(dsgTxn, this.txn);
        dsgTxn.getContext().putAll(dsg.getContext());
        return dsgTxn;
    }

    private DatasetGraphTDB buildReadonly() {
        BlockMgrBuilderReadonly blockMgrBuilder = new BlockMgrBuilderReadonly();
        NodeTableBuilderReadonly nodeTableBuilder = new NodeTableBuilderReadonly();
        DatasetBuilderStd x = new DatasetBuilderStd(blockMgrBuilder, nodeTableBuilder);
        DatasetGraphTDB dsg2 = x.build(this.dsg.getLocation(), this.dsg.getConfig().params);
        return dsg2;
    }

    private DatasetGraphTDB buildWritable() {
        BlockMgrBuilderTx blockMgrBuilder = new BlockMgrBuilderTx();
        NodeTableBuilderTx nodeTableBuilder = new NodeTableBuilderTx();
        DatasetBuilderStd x = new DatasetBuilderStd(blockMgrBuilder, nodeTableBuilder);
        DatasetGraphTDB dsg2 = x.build(this.dsg.getLocation(), this.dsg.getConfig().params);
        return dsg2;
    }

    static BlockMgrBuilder logging(BlockMgrBuilder other) {
        return new BlockMgrBuilderLogger(other);
    }

    class NodeTableBuilderReadonly
    implements NodeTableBuilder {
        NodeTableBuilderReadonly() {
        }

        @Override
        public NodeTable buildNodeTable(FileSet fsIndex, FileSet fsObjectFile, int sizeNode2NodeIdCache, int sizeNodeId2NodeCache, int sizeNodeMissCacheSize) {
            FileRef ref = FileRef.create(fsObjectFile.filename("dat"));
            NodeTable nt = (NodeTable)DatasetBuilderTxn.this.nodeTables.get(ref);
            nt = new NodeTableReadonly(nt);
            return nt;
        }
    }

    class BlockMgrBuilderReadonly
    implements BlockMgrBuilder {
        BlockMgrBuilderReadonly() {
        }

        @Override
        public BlockMgr buildBlockMgr(FileSet fileSet, String ext, int blockSize) {
            FileRef ref = FileRef.create(fileSet, ext);
            BlockMgr blockMgr = (BlockMgr)DatasetBuilderTxn.this.blockMgrs.get(ref);
            if (blockMgr == null) {
                throw new TDBException("No BlockMgr for " + ref);
            }
            blockMgr = new BlockMgrReadonly(blockMgr);
            return blockMgr;
        }
    }

    class BlockMgrBuilderTx
    implements BlockMgrBuilder {
        BlockMgrBuilderTx() {
        }

        @Override
        public BlockMgr buildBlockMgr(FileSet fileSet, String ext, int blockSize) {
            FileRef ref = FileRef.create(fileSet, ext);
            BlockMgr baseMgr = (BlockMgr)DatasetBuilderTxn.this.blockMgrs.get(ref);
            if (baseMgr == null) {
                throw new TDBException("No BlockMgr for " + ref);
            }
            BlockMgrJournal blkMgr = new BlockMgrJournal(DatasetBuilderTxn.this.txn, ref, baseMgr);
            DatasetBuilderTxn.this.txn.addComponent(blkMgr);
            return blkMgr;
        }
    }

    class NodeTableBuilderTx
    implements NodeTableBuilder {
        NodeTableBuilderTx() {
        }

        @Override
        public NodeTable buildNodeTable(FileSet fsIndex, FileSet fsObjectFile, int sizeNode2NodeIdCache, int sizeNodeId2NodeCache, int sizeNodeMissCacheSize) {
            FileRef ref = FileRef.create(fsObjectFile.filename("dat"));
            NodeTable ntBase = (NodeTable)DatasetBuilderTxn.this.nodeTables.get(ref);
            if (ntBase == null) {
                throw new TDBException("No NodeTable for " + ref);
            }
            RecordFactory recordFactory = new RecordFactory(16, 8);
            IndexMap idx = new IndexMap(recordFactory);
            String objFilename = fsObjectFile.filename("dat-jrnl");
            ObjectFile objectFile = fsObjectFile.isMem() ? FileFactory.createObjectFileMem(objFilename) : FileFactory.createObjectFileDisk(objFilename);
            NodeTableTrans ntt = new NodeTableTrans(DatasetBuilderTxn.this.txn, fsObjectFile.getBasename(), ntBase, idx, objectFile);
            DatasetBuilderTxn.this.txn.addComponent(ntt);
            NodeTable nt = NodeTableInline.create(ntt);
            return nt;
        }
    }

    static class BlockMgrBuilderLogger
    implements BlockMgrBuilder {
        public BlockMgrBuilder other;

        public BlockMgrBuilderLogger(BlockMgrBuilder other) {
            this.other = other;
        }

        @Override
        public BlockMgr buildBlockMgr(FileSet fileSet, String ext, int blockSize) {
            BlockMgr blkMgr = this.other.buildBlockMgr(fileSet, ext, blockSize);
            blkMgr = new BlockMgrLogger(blkMgr.getLabel(), blkMgr, true);
            return blkMgr;
        }
    }
}

