/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.transaction;

import com.hp.hpl.jena.query.ReadWrite;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.sys.FileRef;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import com.hp.hpl.jena.tdb.transaction.BlockMgrJournal;
import com.hp.hpl.jena.tdb.transaction.DatasetGraphTxn;
import com.hp.hpl.jena.tdb.transaction.Journal;
import com.hp.hpl.jena.tdb.transaction.JournalEntryType;
import com.hp.hpl.jena.tdb.transaction.NodeTableTrans;
import com.hp.hpl.jena.tdb.transaction.TDBTransactionException;
import com.hp.hpl.jena.tdb.transaction.TransactionLifecycle;
import com.hp.hpl.jena.tdb.transaction.TransactionManager;
import com.hp.hpl.jena.tdb.transaction.TxnState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.openjena.atlas.logging.Log;

public class Transaction {
    private final long id;
    private final String label;
    private final TransactionManager txnMgr;
    private final Journal journal;
    private final ReadWrite mode;
    private final List<NodeTableTrans> nodeTableTrans = new ArrayList<NodeTableTrans>();
    private final List<BlockMgrJournal> blkMgrs = new ArrayList<BlockMgrJournal>();
    private final DatasetGraphTDB basedsg;
    private final List<Iterator<?>> iterators;
    private DatasetGraphTxn activedsg;
    private TxnState state;
    private TxnOutcome outcome;
    private boolean changesPending;

    public Transaction(DatasetGraphTDB dsg, ReadWrite mode, long id, String label, TransactionManager txnMgr) {
        this.id = id;
        if (label == null) {
            label = "Txn";
        }
        label = label + "[" + id + "]";
        switch (mode) {
            case READ: {
                label = label + "/R";
                break;
            }
            case WRITE: {
                label = label + "/W";
            }
        }
        this.label = label;
        this.txnMgr = txnMgr;
        this.basedsg = dsg;
        this.mode = mode;
        this.journal = txnMgr == null ? null : txnMgr.getJournal();
        this.activedsg = null;
        this.iterators = new ArrayList();
        this.state = TxnState.ACTIVE;
        this.outcome = TxnOutcome.UNFINISHED;
        this.changesPending = mode == ReadWrite.WRITE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        Transaction transaction = this;
        synchronized (transaction) {
            switch (this.mode) {
                case READ: {
                    this.outcome = TxnOutcome.R_COMMITED;
                    break;
                }
                case WRITE: {
                    if (this.state != TxnState.ACTIVE) {
                        throw new TDBTransactionException("Transaction has already committed or aborted");
                    }
                    this.prepare();
                    this.journal.write(JournalEntryType.Commit, FileRef.Journal, null);
                    this.journal.sync();
                    this.outcome = TxnOutcome.W_COMMITED;
                }
            }
            this.state = TxnState.COMMITED;
        }
        this.txnMgr.notifyCommit(this);
    }

    private void prepare() {
        this.state = TxnState.PREPARING;
        for (BlockMgrJournal blockMgrJournal : this.blkMgrs) {
            blockMgrJournal.commitPrepare(this);
        }
        for (NodeTableTrans nodeTableTrans : this.nodeTableTrans) {
            nodeTableTrans.commitPrepare(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        Transaction transaction = this;
        synchronized (transaction) {
            switch (this.mode) {
                case READ: {
                    this.state = TxnState.ABORTED;
                    this.outcome = TxnOutcome.R_ABORTED;
                    break;
                }
                case WRITE: {
                    if (this.state != TxnState.ACTIVE) {
                        throw new TDBTransactionException("Transaction has already committed or aborted");
                    }
                    for (BlockMgrJournal blockMgrJournal : this.blkMgrs) {
                        blockMgrJournal.abort(this);
                    }
                    for (NodeTableTrans nodeTableTrans : this.nodeTableTrans) {
                        nodeTableTrans.abort(this);
                    }
                    this.state = TxnState.ABORTED;
                    this.outcome = TxnOutcome.W_ABORTED;
                }
            }
        }
        this.txnMgr.notifyAbort(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Transaction transaction = this;
        synchronized (transaction) {
            switch (this.state) {
                case CLOSED: {
                    return;
                }
                case ACTIVE: {
                    if (this.mode == ReadWrite.READ) {
                        this.commit();
                        this.outcome = TxnOutcome.R_CLOSED;
                        break;
                    }
                    SystemTDB.errlog.warn("Transaction not commited or aborted: " + this);
                    this.abort();
                    break;
                }
            }
            this.state = TxnState.CLOSED;
            this.iterators.clear();
        }
        this.txnMgr.notifyClose(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void signalEnacted() {
        Transaction transaction = this;
        synchronized (transaction) {
            if (!this.changesPending) {
                Log.warn((Object)this, (String)"Transaction was a read transaction or a write transaction that has already been flushed");
            }
            this.changesPending = false;
        }
    }

    public ReadWrite getMode() {
        return this.mode;
    }

    public boolean isRead() {
        return this.mode == ReadWrite.READ;
    }

    public TxnState getState() {
        return this.state;
    }

    public long getTxnId() {
        return this.id;
    }

    public TransactionManager getTxnMgr() {
        return this.txnMgr;
    }

    public DatasetGraphTxn getActiveDataset() {
        return this.activedsg;
    }

    public void setActiveDataset(DatasetGraphTxn activedsg) {
        this.activedsg = activedsg;
    }

    public Journal getJournal() {
        return this.journal;
    }

    public List<Iterator<?>> iterators() {
        return Collections.unmodifiableList(this.iterators);
    }

    public void addIterator(Iterator<?> iter) {
        this.iterators.add(iter);
    }

    public void removeIterator(Iterator<?> iter) {
        this.iterators.remove(iter);
    }

    public List<TransactionLifecycle> components() {
        ArrayList<TransactionLifecycle> x = new ArrayList<TransactionLifecycle>();
        x.addAll(this.nodeTableTrans);
        x.addAll(this.blkMgrs);
        return x;
    }

    public void addComponent(NodeTableTrans ntt) {
        this.nodeTableTrans.add(ntt);
    }

    public void addComponent(BlockMgrJournal blkMgr) {
        this.blkMgrs.add(blkMgr);
    }

    public DatasetGraphTDB getBaseDataset() {
        return this.basedsg;
    }

    public String toString() {
        return "Transaction: " + this.id + " : Mode=" + this.mode + " : State=" + (Object)((Object)this.state) + " : " + this.basedsg.getLocation().getDirectoryPath();
    }

    public String getLabel() {
        return this.label;
    }

    static enum TxnOutcome {
        UNFINISHED,
        W_ABORTED,
        W_COMMITED,
        R_CLOSED,
        R_ABORTED,
        R_COMMITED;

    }
}

