/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.store.bulkloader3;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockMgrFactory;
import com.hp.hpl.jena.tdb.base.file.FileFactory;
import com.hp.hpl.jena.tdb.base.file.FileSet;
import com.hp.hpl.jena.tdb.base.objectfile.ObjectFile;
import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTree;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTreeParams;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTreeRewriter;
import com.hp.hpl.jena.tdb.lib.NodeLib;
import com.hp.hpl.jena.tdb.solver.stats.StatsCollectorNodeId;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.Hash;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.store.bulkloader.BulkLoader;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import org.apache.commons.codec.binary.Hex;
import org.apache.jena.tdb.store.bulkloader3.MultiThreadedSortedDataBag;
import org.apache.jena.tdb.store.bulkloader3.PairComparator;
import org.apache.jena.tdb.store.bulkloader3.PairSerializationFactory;
import org.apache.jena.tdb.store.bulkloader3.ProgressLogger;
import org.openjena.atlas.AtlasException;
import org.openjena.atlas.data.DataBag;
import org.openjena.atlas.data.SerializationFactory;
import org.openjena.atlas.data.ThresholdPolicy;
import org.openjena.atlas.data.ThresholdPolicyCount;
import org.openjena.atlas.data.ThresholdPolicyMemory;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.iterator.Transform;
import org.openjena.atlas.lib.Bytes;
import org.openjena.atlas.lib.Pair;
import org.openjena.atlas.lib.Sink;
import org.openjena.atlas.lib.Tuple;
import org.slf4j.Logger;
import tdb.tdbloader3;

public class NodeTableBuilder2
implements Sink<Quad> {
    private DatasetGraphTDB dsg;
    private ObjectFile objects;
    private DataBag<Tuple<Long>> outputTriples;
    private DataBag<Tuple<Long>> outputQuads;
    private ProgressLogger monitor;
    private StatsCollectorNodeId stats;
    private DataBag<Pair<byte[], byte[]>> sdb01;
    private DataBag<Pair<byte[], byte[]>> sdb02;
    private DataBag<Pair<byte[], byte[]>> sdb03;
    private SerializationFactory<Pair<byte[], byte[]>> serializationFactory = new PairSerializationFactory();
    private MessageDigest digest;
    private final Logger log;

    public NodeTableBuilder2(DatasetGraphTDB dsg, ProgressLogger monitor, DataBag<Tuple<Long>> outputTriples, DataBag<Tuple<Long>> outputQuads) {
        this.dsg = dsg;
        this.monitor = monitor;
        this.log = monitor.getLogger();
        String filename = new FileSet(dsg.getLocation(), "nodes").filename("dat");
        this.objects = FileFactory.createObjectFileDisk(filename);
        this.outputTriples = outputTriples;
        this.outputQuads = outputQuads;
        this.stats = new StatsCollectorNodeId();
        this.sdb01 = new MultiThreadedSortedDataBag<Pair<byte[], byte[]>>(this.getThresholdPolicy(), this.serializationFactory, new PairComparator());
        try {
            this.digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AtlasException((Throwable)e);
        }
    }

    public StatsCollectorNodeId getCollector() {
        return this.stats;
    }

    private ThresholdPolicy<Pair<byte[], byte[]>> getThresholdPolicy() {
        if (tdbloader3.spill_size_auto) {
            long memory = Math.round((double)Runtime.getRuntime().maxMemory() * 0.065);
            this.log.info("Threshold spill is: " + memory);
            return new ThresholdPolicyMemory(memory, this.serializationFactory);
        }
        return new ThresholdPolicyCount((long)tdbloader3.spill_size);
    }

    public void send(Quad quad) {
        try {
            byte[] s = tdbloader3.serialize(quad.getSubject()).getBytes("UTF-8");
            byte[] p = tdbloader3.serialize(quad.getPredicate()).getBytes("UTF-8");
            byte[] o = tdbloader3.serialize(quad.getObject()).getBytes("UTF-8");
            byte[] g = null;
            if (!quad.isTriple() && !quad.isDefaultGraph()) {
                g = tdbloader3.serialize(quad.getGraph()).getBytes("UTF-8");
            }
            this.digest.reset();
            this.digest.update(s);
            this.digest.update(p);
            this.digest.update(o);
            if (g != null) {
                this.digest.update(g.toString().getBytes("UTF-8"));
            }
            String md5 = new String(Hex.encodeHex((byte[])this.digest.digest()));
            this.sdb01.add((Object)new Pair((Object)s, (Object)(md5 + "|s").getBytes("UTF-8")));
            this.sdb01.add((Object)new Pair((Object)p, (Object)(md5 + "|p").getBytes("UTF-8")));
            this.sdb01.add((Object)new Pair((Object)o, (Object)(md5 + "|o").getBytes("UTF-8")));
            if (g != null) {
                this.sdb01.add((Object)new Pair((Object)g, (Object)(md5 + "|g").getBytes("UTF-8")));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new AtlasException((Throwable)e);
        }
        this.monitor.tick();
    }

    public void flush() {
    }

    public void close() {
        this.flush();
        this.buildNodesObjectFile();
        this.generateSortedHashNodeIdDataBag();
        this.buildNodeTableBPTreeIndex();
        this.outputTriples.flush();
        this.outputQuads.flush();
        this.objects.sync();
    }

    private void buildNodesObjectFile() {
        this.sdb02 = new MultiThreadedSortedDataBag<Pair<byte[], byte[]>>(this.getThresholdPolicy(), this.serializationFactory, new PairComparator());
        this.sdb03 = new MultiThreadedSortedDataBag<Pair<byte[], byte[]>>(this.getThresholdPolicy(), this.serializationFactory, new PairComparator());
        try {
            this.log.info("Node Table (1/3): building nodes.dat and sorting hash|id ...");
            ProgressLogger monitor01 = new ProgressLogger(this.log, "records for node table (1/3) phase", BulkLoader.DataTickPoint, BulkLoader.superTick);
            monitor01.start();
            String curr = null;
            long id = -1L;
            for (Pair pair01 : this.sdb01) {
                String leftIn = new String((byte[])pair01.getLeft(), "UTF-8");
                String rightIn = new String((byte[])pair01.getRight(), "UTF-8");
                if (!leftIn.equals(curr)) {
                    curr = leftIn;
                    Node node = tdbloader3.parse(leftIn);
                    id = NodeLib.encodeStore(node, this.objects);
                    Hash hash = new Hash(16);
                    NodeLib.setHash(hash, node);
                    this.sdb03.add((Object)new Pair((Object)hash.getBytes(), (Object)Bytes.packLong((long)id)));
                }
                String[] tokens = rightIn.split("\\|");
                String leftOut = tokens[0];
                String rightOut = id + "|" + tokens[1];
                Pair pair02 = new Pair((Object)leftOut.getBytes("UTF-8"), (Object)rightOut.getBytes("UTF-8"));
                this.sdb02.add((Object)pair02);
                monitor01.tick();
            }
            ProgressLogger.print(this.log, monitor01);
        }
        catch (UnsupportedEncodingException e) {
            throw new AtlasException((Throwable)e);
        }
        finally {
            this.sdb01.close();
            this.sdb01 = null;
        }
    }

    private void generateSortedHashNodeIdDataBag() {
        try {
            this.log.info("Node Table (2/3): generating input data using node ids...");
            ProgressLogger monitor02 = new ProgressLogger(this.log, "records for node table (2/3) phase", BulkLoader.DataTickPoint, BulkLoader.superTick);
            monitor02.start();
            Iterator iter02 = this.sdb02.iterator();
            String curr = null;
            Long s = null;
            Long p = null;
            Long o = null;
            Long g = null;
            while (iter02.hasNext()) {
                String[] tokens;
                Pair pair02 = (Pair)iter02.next();
                String leftIn = new String((byte[])pair02.getLeft(), "UTF-8");
                String rightIn = new String((byte[])pair02.getRight(), "UTF-8");
                if (curr == null) {
                    curr = leftIn;
                }
                if (!leftIn.equals(curr)) {
                    curr = leftIn;
                    this.write(g, s, p, o);
                    s = null;
                    p = null;
                    o = null;
                    g = null;
                    monitor02.tick();
                }
                if ("s".equals((tokens = rightIn.split("\\|"))[1])) {
                    s = Long.parseLong(tokens[0]);
                    continue;
                }
                if ("p".equals(tokens[1])) {
                    p = Long.parseLong(tokens[0]);
                    continue;
                }
                if ("o".equals(tokens[1])) {
                    o = Long.parseLong(tokens[0]);
                    continue;
                }
                if (!"g".equals(tokens[1])) continue;
                g = Long.parseLong(tokens[0]);
            }
            this.write(g, s, p, o);
            ProgressLogger.print(this.log, monitor02);
        }
        catch (UnsupportedEncodingException e) {
            throw new AtlasException((Throwable)e);
        }
        finally {
            this.sdb02.close();
            this.sdb02 = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildNodeTableBPTreeIndex() {
        try {
            this.log.info("Node Table (3/3): building node table B+Tree index (i.e. node2id.dat and node2id.idn files)...");
            final ProgressLogger monitor03 = new ProgressLogger(this.log, "records for node table (3/3) phase", BulkLoader.DataTickPoint, BulkLoader.superTick);
            monitor03.start();
            String path = this.dsg.getLocation().getDirectoryPath();
            new File(path, "node2id.dat").delete();
            new File(path, "node2id.idn").delete();
            final RecordFactory recordFactory = new RecordFactory(16, 8);
            Transform<Pair<byte[], byte[]>, Record> transformPair2Record = new Transform<Pair<byte[], byte[]>, Record>(){

                public Record convert(Pair<byte[], byte[]> pair) {
                    monitor03.tick();
                    return recordFactory.create((byte[])pair.getLeft(), (byte[])pair.getRight());
                }
            };
            int order = BPlusTreeParams.calcOrder(8192, recordFactory);
            BPlusTreeParams bptParams = new BPlusTreeParams(order, recordFactory);
            int readCacheSize = 10;
            int writeCacheSize = 100;
            FileSet destination = new FileSet(this.dsg.getLocation(), "node2id");
            BlockMgr blkMgrNodes = BlockMgrFactory.create(destination, "idn", 8192, readCacheSize, writeCacheSize);
            BlockMgr blkMgrRecords = BlockMgrFactory.create(destination, "dat", 8192, readCacheSize, writeCacheSize);
            Iter iter2 = Iter.iter((Iterator)this.sdb03.iterator()).map((Transform)transformPair2Record);
            BPlusTree bpt2 = BPlusTreeRewriter.packIntoBPlusTree((Iterator<Record>)iter2, bptParams, recordFactory, blkMgrNodes, blkMgrRecords);
            bpt2.sync();
            ProgressLogger.print(this.log, monitor03);
        }
        finally {
            this.sdb03.close();
            this.sdb03 = null;
        }
    }

    private void write(Long g, Long s, Long p, Long o) {
        if (g != null) {
            this.outputQuads.add((Object)Tuple.create((Object[])new Long[]{g, s, p, o}));
            this.stats.record(new NodeId(g), new NodeId(s), new NodeId(p), new NodeId(o));
        } else {
            this.outputTriples.add((Object)Tuple.create((Object[])new Long[]{s, p, o}));
            this.stats.record(null, new NodeId(s), new NodeId(p), new NodeId(o));
        }
    }
}

