/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.store.bulkloader3;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.jena.tdb.store.bulkloader3.DataStreamFactory;
import org.openjena.atlas.AtlasException;
import org.openjena.atlas.lib.Closeable;
import org.openjena.atlas.lib.Tuple;

public class TupleInputStream
implements Iterator<Tuple<Long>>,
Closeable {
    private DataInputStream in;
    private int size;
    private Tuple<Long> slot = null;

    public TupleInputStream(InputStream in, int size) {
        this.in = DataStreamFactory.createDataInputStream(in);
        this.size = size;
        this.slot = this.readNext();
    }

    @Override
    public boolean hasNext() {
        return this.slot != null;
    }

    @Override
    public Tuple<Long> next() {
        Tuple<Long> result = this.slot;
        this.slot = this.readNext();
        return result;
    }

    private Tuple<Long> readNext() {
        try {
            if (this.size == 3) {
                return Tuple.create((Object[])new Long[]{this.in.readLong(), this.in.readLong(), this.in.readLong()});
            }
            if (this.size == 4) {
                return Tuple.create((Object[])new Long[]{this.in.readLong(), this.in.readLong(), this.in.readLong(), this.in.readLong()});
            }
            throw new AtlasException("Unsupported size.");
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public void remove() {
        throw new AtlasException("Method not implemented.");
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            new AtlasException((Throwable)e);
        }
    }
}

