/*
 * Decompiled with CFR 0.152.
 */
package tdb.cmdline;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.ArgModuleGeneral;
import arq.cmdline.CmdArgModule;
import arq.cmdline.CmdGeneral;
import arq.cmdline.ModDataset;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.core.assembler.AssemblerUtils;
import com.hp.hpl.jena.sparql.core.assembler.DatasetAssemblerVocab;
import com.hp.hpl.jena.tdb.TDBFactory;
import com.hp.hpl.jena.tdb.assembler.VocabTDB;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.transaction.DatasetGraphTransaction;
import com.hp.hpl.jena.util.FileManager;
import java.util.ArrayList;
import java.util.List;
import org.openjena.atlas.logging.Log;
import tdb.cmdline.ModTDBAssembler;

public class ModTDBDataset
extends ModDataset {
    private ArgDecl argMem = new ArgDecl(false, "mem");
    private ModTDBAssembler modAssembler = new ModTDBAssembler();
    private boolean useMemory = false;

    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.add(this.argMem);
        cmdLine.addModule((ArgModuleGeneral)this.modAssembler);
    }

    public void processArgs(CmdArgModule cmdLine) {
        this.useMemory = cmdLine.contains(this.argMem);
        this.modAssembler.processArgs(cmdLine);
    }

    public Dataset createDataset() {
        if (this.modAssembler.getAssemblerFile() != null) {
            Dataset thing = null;
            try {
                thing = (Dataset)AssemblerUtils.build((String)this.modAssembler.getAssemblerFile(), (Resource)VocabTDB.tDatasetTDB);
                if (thing != null && !(thing.asDatasetGraph() instanceof DatasetGraphTransaction)) {
                    Log.warn((Object)((Object)this), (String)"Unexpected: Not a TDB dataset for type DatasetTDB");
                }
                if (thing == null) {
                    thing = (Dataset)AssemblerUtils.build((String)this.modAssembler.getAssemblerFile(), (Resource)DatasetAssemblerVocab.tDataset);
                }
            }
            catch (ARQException ex) {
                throw ex;
            }
            catch (JenaException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new CmdException("Error creating", (Throwable)ex);
            }
            return thing;
        }
        if (this.modAssembler.getLocation() == null) {
            throw new CmdException("No assembler file nor location provided");
        }
        Dataset ds = TDBFactory.createDataset(this.modAssembler.getLocation());
        return ds;
    }

    public Location getLocation() {
        List<String> x = this.locations();
        if (x.size() == 0) {
            return null;
        }
        return new Location(x.get(0));
    }

    public List<String> locations() {
        ArrayList<String> locations = new ArrayList<String>();
        if (this.modAssembler.getLocation() != null) {
            locations.add(this.modAssembler.getLocation().getDirectoryPath());
        }
        if (this.modAssembler.getAssemblerFile() != null) {
            Model m = FileManager.get().loadModel(this.modAssembler.getAssemblerFile());
            Query query = QueryFactory.create((String)"PREFIX tdb:     <http://jena.hpl.hp.com/2008/tdb#> SELECT ?dir { [] tdb:location ?dir FILTER (isURI(?dir)) }");
            QueryExecution qExec = null;
            try {
                qExec = QueryExecutionFactory.create((Query)query, (Model)m);
                ResultSet rs = qExec.execSelect();
                while (rs.hasNext()) {
                    String x = rs.nextSolution().getResource("dir").getURI();
                    locations.add(x);
                }
            }
            catch (RuntimeException ex) {
                if (qExec != null) {
                    qExec.close();
                }
                throw ex;
            }
        }
        return locations;
    }
}

