/*
 * Decompiled with CFR 0.152.
 */
package tdb;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdGeneral;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockMgrFactory;
import com.hp.hpl.jena.tdb.base.file.FileSet;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTree;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTreeParams;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTreeRewriter;
import com.hp.hpl.jena.tdb.solver.stats.Stats;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.bulkloader.BulkLoader;
import com.hp.hpl.jena.tdb.sys.Names;
import com.hp.hpl.jena.tdb.sys.SetupTDB;
import java.io.Closeable;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.tdb.store.bulkloader3.CustomLabelToNode;
import org.apache.jena.tdb.store.bulkloader3.DataStreamFactory;
import org.apache.jena.tdb.store.bulkloader3.MultiThreadedSortedDataBag;
import org.apache.jena.tdb.store.bulkloader3.NodeTableBuilder2;
import org.apache.jena.tdb.store.bulkloader3.ProgressLogger;
import org.apache.jena.tdb.store.bulkloader3.QuadSerializationFactory;
import org.apache.jena.tdb.store.bulkloader3.TripleSerializationFactory;
import org.apache.jena.tdb.store.bulkloader3.TupleComparator;
import org.openjena.atlas.AtlasException;
import org.openjena.atlas.data.DataBag;
import org.openjena.atlas.data.SerializationFactory;
import org.openjena.atlas.data.ThresholdPolicy;
import org.openjena.atlas.data.ThresholdPolicyCount;
import org.openjena.atlas.data.ThresholdPolicyMemory;
import org.openjena.atlas.io.IO;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.iterator.Transform;
import org.openjena.atlas.lib.Bytes;
import org.openjena.atlas.lib.ColumnMap;
import org.openjena.atlas.lib.FileOps;
import org.openjena.atlas.lib.Sink;
import org.openjena.atlas.lib.Tuple;
import org.openjena.atlas.logging.Log;
import org.openjena.riot.ErrorHandlerFactory;
import org.openjena.riot.Lang;
import org.openjena.riot.lang.LabelToNode;
import org.openjena.riot.lang.LangNQuads;
import org.openjena.riot.lang.LangNTriples;
import org.openjena.riot.out.NodeToLabel;
import org.openjena.riot.out.OutputLangUtils;
import org.openjena.riot.system.IRIResolver;
import org.openjena.riot.system.ParserProfile;
import org.openjena.riot.system.ParserProfileBase;
import org.openjena.riot.system.Prologue;
import org.openjena.riot.system.RiotLib;
import org.openjena.riot.system.SinkExtendTriplesToQuads;
import org.openjena.riot.tokens.Token;
import org.openjena.riot.tokens.Tokenizer;
import org.openjena.riot.tokens.TokenizerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tdb.cmdline.CmdTDB;

public class tdbloader3
extends CmdGeneral {
    private static Logger cmdLog;
    private static String runId;
    private static ArgDecl argLocation;
    private static ArgDecl argCompression;
    private static ArgDecl argBufferSize;
    private static ArgDecl argGzipOutside;
    private static ArgDecl argSpillSize;
    private static ArgDecl argSpillSizeAuto;
    private static ArgDecl argNoStats;
    private static ArgDecl argNoBuffer;
    private static ArgDecl argMaxMergeFiles;
    private Location location;
    private String locationString;
    private List<String> datafiles;
    public static int spill_size;
    public static boolean spill_size_auto;
    public static boolean no_stats;
    private Comparator<Tuple<Long>> comparator = new TupleComparator();
    private TripleSerializationFactory tripleSerializationFactory = new TripleSerializationFactory();
    private QuadSerializationFactory quadSerializationFactory = new QuadSerializationFactory();
    public static final NodeToLabel nodeToLabel;
    private static final Prologue prologue;
    private static ParserProfile profile;

    public static void main(String ... argv) {
        CmdTDB.init();
        TDB.setOptimizerWarningFlag(false);
        new tdbloader3(argv).mainRun();
    }

    public tdbloader3(String ... argv) {
        super(argv);
        super.add(argLocation, "--loc", "Location");
        super.add(argCompression, "--compression", "Use compression for intermediate files");
        super.add(argBufferSize, "--buffer-size", "The size of buffers for IO in bytes");
        super.add(argGzipOutside, "--gzip-outside", "GZIP...(Buffered...())");
        super.add(argSpillSize, "--spill-size", "The size of spillable segments in tuples|records");
        super.add(argSpillSizeAuto, "--spill-size-auto", "Automatically set the size of spillable segments");
        super.add(argNoStats, "--no-stats", "Do not generate the stats file");
        super.add(argNoBuffer, "--no-buffer", "Do not use Buffered{Input|Output}Stream");
        super.add(argMaxMergeFiles, "--max-merge-files", "Specify the maximum number of files to merge at the same time (default: 100)");
    }

    protected void processModulesAndArgs() {
        if (!super.contains(argLocation)) {
            throw new CmdException("Required: --loc DIR");
        }
        this.locationString = super.getValue(argLocation);
        this.location = new Location(this.locationString);
        if (super.hasArg(argSpillSize)) {
            spill_size = Integer.valueOf(super.getValue(argSpillSize));
        }
        no_stats = super.hasArg(argNoStats);
        DataStreamFactory.setUseCompression(super.hasArg(argCompression));
        DataStreamFactory.setGZIPOutside(super.hasArg(argGzipOutside));
        if (super.hasArg(argBufferSize)) {
            DataStreamFactory.setBufferSize(Integer.valueOf(super.getValue(argBufferSize)));
        }
        DataStreamFactory.setBuffered(!super.hasArg(argNoBuffer));
        if (super.hasArg(argMaxMergeFiles)) {
            MultiThreadedSortedDataBag.MAX_SPILL_FILES = Integer.valueOf(super.getValue(argMaxMergeFiles));
        }
        if (super.hasArg(argSpillSizeAuto)) {
            spill_size_auto = true;
        }
        this.datafiles = super.getPositional();
        for (String filename : this.datafiles) {
            Lang lang = Lang.guess((String)filename, (Lang)Lang.NQUADS);
            if (lang == null) {
                this.cmdError("File suffix not recognized: " + filename);
            }
            if (FileOps.exists((String)filename)) continue;
            this.cmdError("File does not exist: " + filename);
        }
    }

    private ThresholdPolicy<Tuple<Long>> getThresholdPolicy(SerializationFactory<Tuple<Long>> serializationFactory) {
        if (spill_size_auto) {
            long memory = Math.round((double)Runtime.getRuntime().maxMemory() * 0.065);
            cmdLog.info("Threshold spill is: " + memory);
            return new ThresholdPolicyMemory(memory, serializationFactory);
        }
        return new ThresholdPolicyCount((long)spill_size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exec() {
        DatasetGraphTDB dsg = SetupTDB.buildDataset(this.location);
        dsg.getTripleTable().getNodeTupleTable().getTupleTable().close();
        dsg.getQuadTable().getNodeTupleTable().getTupleTable().close();
        dsg.getPrefixes().close();
        ProgressLogger monitorTotal = new ProgressLogger(cmdLog, "tuples", BulkLoader.DataTickPoint, BulkLoader.superTick);
        monitorTotal.start();
        MultiThreadedSortedDataBag<Tuple<Long>> outputTriples = new MultiThreadedSortedDataBag<Tuple<Long>>(this.getThresholdPolicy(this.tripleSerializationFactory), new TripleSerializationFactory(), this.comparator);
        MultiThreadedSortedDataBag<Tuple<Long>> outputQuads = new MultiThreadedSortedDataBag<Tuple<Long>>(this.getThresholdPolicy(this.quadSerializationFactory), new QuadSerializationFactory(), this.comparator);
        NodeTableBuilder2 sink = new NodeTableBuilder2(dsg, monitorTotal, (DataBag<Tuple<Long>>)outputTriples, (DataBag<Tuple<Long>>)outputQuads);
        SinkExtendTriplesToQuads sink2 = new SinkExtendTriplesToQuads((Sink)sink);
        BPlusTree bptSPO = null;
        BPlusTree bptGSPO = null;
        try {
            for (String filename : this.datafiles) {
                LangNTriples parser;
                if (this.datafiles.size() > 0) {
                    cmdLog.info("Load: " + filename + " -- " + Utils.nowAsString());
                }
                InputStream in = IO.openFile((String)filename);
                Tokenizer tokenizer = TokenizerFactory.makeTokenizerUTF8((InputStream)in);
                ParserProfile profile = tdbloader3.createParserProfile(runId, filename);
                Lang lang = Lang.guess((String)filename, (Lang)Lang.NQUADS);
                if (lang.isTriples()) {
                    parser = new LangNTriples(tokenizer, profile, (Sink)sink2);
                    parser.parse();
                } else {
                    parser = new LangNQuads(tokenizer, profile, (Sink)sink);
                    parser.parse();
                }
                IO.close((Closeable)in);
            }
            sink.close();
            bptSPO = this.createBPlusTreeIndex("SPO", (DataBag<Tuple<Long>>)outputTriples);
            bptGSPO = this.createBPlusTreeIndex("GSPO", (DataBag<Tuple<Long>>)outputQuads);
        }
        finally {
            outputTriples.close();
            outputQuads.close();
        }
        for (String indexName : Names.tripleIndexes) {
            if (indexName.equals("SPO")) continue;
            this.createBPlusTreeIndex(indexName, new ColumnMap("SPO", indexName), bptSPO);
        }
        for (String indexName : Names.quadIndexes) {
            if (indexName.equals("GSPO")) continue;
            this.createBPlusTreeIndex(indexName, new ColumnMap("GSPO", indexName), bptGSPO);
        }
        if (!no_stats && !this.location.isMem()) {
            dsg = SetupTDB.buildDataset(this.location);
            Stats.write(dsg, sink.getCollector());
        }
        ProgressLogger.print(cmdLog, monitorTotal);
    }

    protected String getSummary() {
        return this.getCommandName() + " --loc=DIR FILE ...";
    }

    protected String getCommandName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public static void spill(DataBag<?> bag) {
        if (bag instanceof MultiThreadedSortedDataBag) {
            ((MultiThreadedSortedDataBag)bag).spill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BPlusTree createBPlusTreeIndex(String indexName, DataBag<Tuple<Long>> tuples) {
        BPlusTree bpt2;
        this.deleteExistingBPlusTreeIndex(indexName);
        final int size = indexName.length();
        if (size != 3 && size != 4) {
            throw new AtlasException("Unsupported size.");
        }
        final RecordFactory recordFactory = size == 3 ? new RecordFactory(24, 0) : new RecordFactory(32, 0);
        int order = BPlusTreeParams.calcOrder(8192, recordFactory);
        BPlusTreeParams bptParams = new BPlusTreeParams(order, recordFactory);
        int readCacheSize = 10;
        int writeCacheSize = 100;
        FileSet destination = new FileSet(this.location, indexName);
        BlockMgr blkMgrNodes = BlockMgrFactory.create(destination, "idn", 8192, readCacheSize, writeCacheSize);
        BlockMgr blkMgrRecords = BlockMgrFactory.create(destination, "dat", 8192, readCacheSize, writeCacheSize);
        cmdLog.info("Index: creating " + indexName + " index...");
        final ProgressLogger monitor = new ProgressLogger(cmdLog, "records to " + indexName, BulkLoader.DataTickPoint, BulkLoader.superTick);
        monitor.start();
        Transform<Tuple<Long>, Record> transformTuple2Record = new Transform<Tuple<Long>, Record>(){

            public Record convert(Tuple<Long> tuple) {
                Record record = recordFactory.create();
                for (int i = 0; i < size; ++i) {
                    Bytes.setLong((long)((Long)tuple.get(i)), (byte[])record.getKey(), (int)(i * 8));
                }
                monitor.tick();
                return record;
            }
        };
        Iterator it = tuples.iterator();
        Iter iter = null;
        try {
            iter = Iter.iter((Iterator)it).map((Transform)transformTuple2Record);
            bpt2 = BPlusTreeRewriter.packIntoBPlusTree((Iterator<Record>)iter, bptParams, recordFactory, blkMgrNodes, blkMgrRecords);
            bpt2.sync();
        }
        finally {
            Iter.close((Iterator)it);
            Iter.close((Iterator)iter);
        }
        ProgressLogger.print(cmdLog, monitor);
        return bpt2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBPlusTreeIndex(String indexName, final ColumnMap colMap, BPlusTree bpt) {
        final int size = indexName.length();
        if (size != 3 && size != 4) {
            throw new AtlasException("Unsupported size.");
        }
        MultiThreadedSortedDataBag<Tuple<Long>> outTuples = size == 3 ? new MultiThreadedSortedDataBag<Tuple<Long>>(this.getThresholdPolicy(this.tripleSerializationFactory), this.tripleSerializationFactory, this.comparator) : new MultiThreadedSortedDataBag<Tuple<Long>>(this.getThresholdPolicy(this.quadSerializationFactory), this.quadSerializationFactory, this.comparator);
        cmdLog.info("Index: sorting data for " + indexName + " index...");
        final ProgressLogger monitor = new ProgressLogger(cmdLog, "records to " + indexName, BulkLoader.DataTickPoint, BulkLoader.superTick);
        monitor.start();
        Transform<Record, Tuple<Long>> transformTuple2Tuple = new Transform<Record, Tuple<Long>>(){

            public Tuple<Long> convert(Record record) {
                Object[] ids = new Long[size];
                for (int i = 0; i < size; ++i) {
                    ids[colMap.fetchSlotIdx((int)i)] = Bytes.getLong((byte[])record.getKey(), (int)(i * 8));
                }
                monitor.tick();
                return Tuple.create((Object[])ids);
            }
        };
        try {
            Iterator<Record> bptIter = bpt.iterator();
            try {
                outTuples.addAll(Iter.iter(bptIter).map((Transform)transformTuple2Tuple).iterator());
            }
            finally {
                Iter.close(bptIter);
            }
            ProgressLogger.print(cmdLog, monitor);
            this.createBPlusTreeIndex(indexName, (DataBag<Tuple<Long>>)outTuples);
        }
        finally {
            outTuples.close();
            outTuples = null;
        }
    }

    private void deleteExistingBPlusTreeIndex(String indexName) {
        FileOps.delete((String)this.location.absolute(indexName, "idn"));
        FileOps.delete((String)this.location.absolute(indexName, "dat"));
    }

    public static String serialize(Node node) {
        StringWriter out = new StringWriter();
        OutputLangUtils.output((Writer)out, (Node)node, (Prologue)prologue, (NodeToLabel)nodeToLabel);
        return out.toString();
    }

    private static ParserProfile createParserProfile(String runId, String filename) {
        CustomLabelToNode labelMapping = new CustomLabelToNode(runId, filename);
        return new ParserProfileBase(prologue, ErrorHandlerFactory.errorHandlerStd, (LabelToNode)labelMapping);
    }

    private static ParserProfile createParserProfile() {
        LabelToNode labelMapping = LabelToNode.createUseLabelAsGiven();
        return new ParserProfileBase(prologue, ErrorHandlerFactory.errorHandlerStd, labelMapping);
    }

    public static Node parse(String string) {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerString((String)string);
        if (!tokenizer.hasNext()) {
            return null;
        }
        Token t = tokenizer.next();
        Node n = profile.create(null, t);
        if (tokenizer.hasNext()) {
            Log.warn(RiotLib.class, (String)("String has more than one token in it: " + string));
        }
        return n;
    }

    static {
        Log.setCmdLogging();
        cmdLog = LoggerFactory.getLogger(tdbloader3.class);
        runId = String.valueOf(System.currentTimeMillis());
        argLocation = new ArgDecl(true, "loc", "location");
        argCompression = new ArgDecl(false, "comp", "compression");
        argBufferSize = new ArgDecl(true, "buf", "buffer-size");
        argGzipOutside = new ArgDecl(false, "gzip-outside");
        argSpillSize = new ArgDecl(true, "spill", "spill-size");
        argSpillSizeAuto = new ArgDecl(false, "spill-auto", "spill-size-auto");
        argNoStats = new ArgDecl(false, "no-stats");
        argNoBuffer = new ArgDecl(false, "no-buffer");
        argMaxMergeFiles = new ArgDecl(true, "max-merge-files");
        spill_size = 1000000;
        spill_size_auto = false;
        no_stats = false;
        nodeToLabel = NodeToLabel.createBNodeByLabelAsGiven();
        prologue = new Prologue(null, IRIResolver.createNoResolve());
        profile = tdbloader3.createParserProfile();
    }
}

