/*
 * Decompiled with CFR 0.152.
 */
package tdb.tools;

import arq.cmdline.ArgModuleGeneral;
import arq.cmdline.CmdGeneral;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.index.RangeIndex;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTree;
import com.hp.hpl.jena.tdb.store.bulkloader2.IndexFactory;
import com.hp.hpl.jena.tdb.sys.Names;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.openjena.atlas.logging.Log;
import tdb.cmdline.ModLocation;

public class dumpbpt
extends CmdGeneral {
    ModLocation modLocation = new ModLocation();

    public static void main(String ... argv) {
        Log.setLog4j();
        new dumpbpt(argv).mainRun();
    }

    protected dumpbpt(String[] argv) {
        super(argv);
        super.addModule((ArgModuleGeneral)this.modLocation);
    }

    protected void processModulesAndArgs() {
        if (this.modVersion.getVersionFlag()) {
            this.modVersion.printVersionAndExit();
        }
        if (this.modLocation.getLocation() == null) {
            this.cmdError("Location required");
        }
        if (super.getPositional().size() == 0) {
            this.cmdError("No index specified");
        }
    }

    protected String getSummary() {
        return this.getCommandName() + " --loc=DIR IndexName";
    }

    protected String getCommandName() {
        return Utils.className((Object)((Object)this));
    }

    protected void exec() {
        List<String> tripleIndexes = Arrays.asList(Names.tripleIndexes);
        List<String> quadIndexes = Arrays.asList(Names.quadIndexes);
        Location loc = this.modLocation.getLocation();
        for (String indexName : super.getPositional()) {
            String primary;
            if (indexName.length() == 3) {
                primary = "SPO";
            } else if (indexName.length() == 4) {
                primary = "GSPO";
            } else {
                this.cmdError("Wrong length: " + indexName);
                primary = null;
            }
            int keySubLen = 8;
            int keyUnitLen = indexName.length();
            int keyLength = keySubLen * keyUnitLen;
            int valueLength = 0;
            RangeIndex rIndex = IndexFactory.openBPT(loc, indexName, SystemTDB.BlockReadCacheSize, SystemTDB.BlockWriteCacheSize, keyLength, valueLength);
            BPlusTree bpt = (BPlusTree)rIndex;
            System.out.println("---- Index contents");
            Iterator<Record> iter = bpt.iterator();
            if (!iter.hasNext()) {
                System.out.println("<<Empty>>");
            }
            while (iter.hasNext()) {
                Record r = iter.next();
                dumpbpt.printRecord("", System.out, r, keyUnitLen);
            }
            Iterator<Record> iterCheck = bpt.iterator();
            Record r1 = null;
            int i = 0;
            while (iterCheck.hasNext()) {
                Record r2 = iterCheck.next();
                ++i;
                if (r1 != null && !Record.keyLT(r1, r2)) {
                    System.err.println("key error@ " + i);
                    dumpbpt.printRecord("  ", System.err, r1, keyUnitLen);
                    dumpbpt.printRecord("  ", System.err, r2, keyUnitLen);
                }
                r1 = r2;
            }
        }
    }

    private static void printRecord(String label, PrintStream out, Record r, int keyUnitLen) {
        int keySubLen = r.getKey().length / keyUnitLen;
        if (label != null) {
            out.print(label);
        }
        for (int i = 0; i < keyUnitLen; ++i) {
            int k;
            if (i != 0) {
                out.print(" ");
            }
            for (int j = k = i * keySubLen; j < k + keySubLen; ++j) {
                out.printf("%02x", r.getKey()[j]);
            }
        }
        out.println();
    }
}

