/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.base.block;

import org.apache.jena.atlas.logging.Log;
import org.apache.jena.tdb.TDBException;
import org.apache.jena.tdb.base.block.BlockMgr;
import org.apache.jena.tdb.base.block.BlockMgrCache;
import org.apache.jena.tdb.base.block.BlockMgrFileAccess;
import org.apache.jena.tdb.base.block.BlockMgrFreeChain;
import org.apache.jena.tdb.base.block.BlockMgrTracker;
import org.apache.jena.tdb.base.block.BlockParams;
import org.apache.jena.tdb.base.block.FileMode;
import org.apache.jena.tdb.base.file.BlockAccess;
import org.apache.jena.tdb.base.file.BlockAccessDirect;
import org.apache.jena.tdb.base.file.BlockAccessMapped;
import org.apache.jena.tdb.base.file.BlockAccessMem;
import org.apache.jena.tdb.base.file.FileSet;
import org.apache.jena.tdb.sys.SystemTDB;

public class BlockMgrFactory {
    public static boolean AddTracker = false;

    public static BlockMgr tracker(BlockMgr blockMgr) {
        if (blockMgr instanceof BlockMgrTracker) {
            return blockMgr;
        }
        return BlockMgrTracker.track(blockMgr);
    }

    private static BlockMgr track(BlockMgr blockMgr) {
        if (!AddTracker) {
            return blockMgr;
        }
        return BlockMgrFactory.tracker(blockMgr);
    }

    public static BlockMgr create(FileSet fileSet, String ext, BlockParams params) {
        return BlockMgrFactory.create(fileSet, ext, params.getFileMode(), params.getBlockSize(), params.getBlockReadCacheSize(), params.getBlockWriteCacheSize());
    }

    public static BlockMgr create(FileSet fileSet, String ext, int blockSize, int readBlockCacheSize, int writeBlockCacheSize) {
        return BlockMgrFactory.create(fileSet, ext, null, blockSize, readBlockCacheSize, writeBlockCacheSize);
    }

    public static BlockMgr create(FileSet fileSet, String ext, FileMode fileMode, int blockSize, int readBlockCacheSize, int writeBlockCacheSize) {
        if (fileSet.isMem()) {
            return BlockMgrFactory.createMem(fileSet.filename(ext), blockSize);
        }
        return BlockMgrFactory.createFile(fileSet.filename(ext), fileMode, blockSize, readBlockCacheSize, writeBlockCacheSize);
    }

    public static BlockMgr createMem(String indexName, int blockSize) {
        BlockAccessMem file = new BlockAccessMem(indexName, blockSize);
        BlockMgr blockMgr = new BlockMgrFileAccess(file, blockSize);
        blockMgr = new BlockMgrFreeChain(blockMgr);
        return BlockMgrFactory.track(blockMgr);
    }

    public static BlockMgr createFile(String filename, BlockParams params) {
        return BlockMgrFactory.createFile(filename, params.getFileMode(), params.getBlockSize(), params.getBlockReadCacheSize(), params.getBlockWriteCacheSize());
    }

    public static BlockMgr createFile(String filename, FileMode fileMode, int blockSize, int readBlockCacheSize, int writeBlockCacheSize) {
        if (fileMode == null) {
            fileMode = SystemTDB.fileMode();
        }
        switch (fileMode) {
            case mapped: {
                return BlockMgrFactory.createMMapFile(filename, blockSize);
            }
            case direct: {
                return BlockMgrFactory.createStdFile(filename, blockSize, readBlockCacheSize, writeBlockCacheSize);
            }
        }
        throw new TDBException("Unknown file mode: " + (Object)((Object)fileMode));
    }

    public static BlockMgr createMMapFile(String filename, int blockSize) {
        BlockAccessMapped file = new BlockAccessMapped(filename, blockSize);
        BlockMgr blockMgr = BlockMgrFactory.wrapFileAccess(file, blockSize);
        return BlockMgrFactory.track(blockMgr);
    }

    public static BlockMgr createStdFile(String filename, int blockSize, int readBlockCacheSize, int writeBlockCacheSize) {
        BlockAccessDirect file = new BlockAccessDirect(filename, blockSize);
        BlockMgr blockMgr = BlockMgrFactory.wrapFileAccess(file, blockSize);
        blockMgr = BlockMgrFactory.addCache(blockMgr, readBlockCacheSize, writeBlockCacheSize);
        return BlockMgrFactory.track(blockMgr);
    }

    public static BlockMgr createStdFileNoCache(String filename, int blockSize) {
        BlockAccessDirect blockAccess = new BlockAccessDirect(filename, blockSize);
        BlockMgrFileAccess blockMgr = new BlockMgrFileAccess(blockAccess, blockSize);
        return blockMgr;
    }

    public static BlockMgr addCache(BlockMgr blockMgr, int readBlockCacheSize, int writeBlockCacheSize) {
        if (blockMgr instanceof BlockMgrCache) {
            Log.warn(BlockMgrFactory.class, (String)("BlockMgr already has a cache: " + blockMgr.getLabel()));
        }
        return BlockMgrCache.create(readBlockCacheSize, writeBlockCacheSize, blockMgr);
    }

    public static BlockMgr addCache(BlockMgr blockMgr, FileSet fileSet, FileMode fileMode, int readBlockCacheSize, int writeBlockCacheSize) {
        if (fileSet.isMem()) {
            return blockMgr;
        }
        if (fileMode == null) {
            fileMode = SystemTDB.fileMode();
        }
        if (fileMode == FileMode.mapped) {
            return blockMgr;
        }
        return BlockMgrFactory.addCache(blockMgr, readBlockCacheSize, writeBlockCacheSize);
    }

    private static BlockMgr wrapFileAccess(BlockAccess blockAccess, int blockSize) {
        BlockMgr blockMgr = new BlockMgrFileAccess(blockAccess, blockSize);
        blockMgr = new BlockMgrFreeChain(blockMgr);
        return blockMgr;
    }
}

