/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.service.knoxsso;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.hadoop.gateway.i18n.messages.MessagesFactory;
import org.apache.hadoop.gateway.service.knoxsso.KnoxSSOMessages;
import org.apache.hadoop.gateway.services.GatewayServices;
import org.apache.hadoop.gateway.services.security.token.JWTokenAuthority;
import org.apache.hadoop.gateway.services.security.token.TokenServiceException;
import org.apache.hadoop.gateway.services.security.token.impl.JWT;
import org.apache.hadoop.gateway.util.RegExUtils;
import org.apache.hadoop.gateway.util.Urls;

@Path(value="/api/v1/websso")
public class WebSSOResource {
    private static final String SSO_COOKIE_NAME = "knoxsso.cookie.name";
    private static final String SSO_COOKIE_SECURE_ONLY_INIT_PARAM = "knoxsso.cookie.secure.only";
    private static final String SSO_COOKIE_MAX_AGE_INIT_PARAM = "knoxsso.cookie.max.age";
    private static final String SSO_COOKIE_DOMAIN_SUFFIX_PARAM = "knoxsso.cookie.domain.suffix";
    private static final String SSO_COOKIE_TOKEN_TTL_PARAM = "knoxsso.token.ttl";
    private static final String SSO_COOKIE_TOKEN_AUDIENCES_PARAM = "knoxsso.token.audiences";
    private static final String SSO_COOKIE_TOKEN_WHITELIST_PARAM = "knoxsso.redirect.whitelist.regex";
    private static final String SSO_ENABLE_SESSION_PARAM = "knoxsso.enable.session";
    private static final String ORIGINAL_URL_REQUEST_PARAM = "originalUrl";
    private static final String ORIGINAL_URL_COOKIE_NAME = "original-url";
    private static final String DEFAULT_SSO_COOKIE_NAME = "hadoop-jwt";
    private static final String DEFAULT_WHITELIST = "^/.*$;^https?://(localhost|127.0.0.1|0:0:0:0:0:0:0:1|::1):\\d{0,9}/.*$";
    static final String RESOURCE_PATH = "/api/v1/websso";
    private static KnoxSSOMessages log = (KnoxSSOMessages)MessagesFactory.get(KnoxSSOMessages.class);
    private String cookieName = null;
    private boolean secureOnly = true;
    private int maxAge = -1;
    private long tokenTTL = 30000L;
    private String whitelist = null;
    private String domainSuffix = null;
    private String[] targetAudiences = null;
    private boolean enableSession = false;
    @Context
    private HttpServletRequest request;
    @Context
    private HttpServletResponse response;
    @Context
    ServletContext context;

    @PostConstruct
    public void init() {
        String ttl;
        String audiences;
        String age;
        String secure;
        this.cookieName = this.context.getInitParameter(SSO_COOKIE_NAME);
        if (this.cookieName == null) {
            this.cookieName = DEFAULT_SSO_COOKIE_NAME;
        }
        if ((secure = this.context.getInitParameter(SSO_COOKIE_SECURE_ONLY_INIT_PARAM)) != null) {
            boolean bl = this.secureOnly = !"false".equals(secure);
            if (!this.secureOnly) {
                log.cookieSecureOnly(this.secureOnly);
            }
        }
        if ((age = this.context.getInitParameter(SSO_COOKIE_MAX_AGE_INIT_PARAM)) != null) {
            try {
                log.setMaxAge(age);
                this.maxAge = Integer.parseInt(age);
            }
            catch (NumberFormatException nfe) {
                log.invalidMaxAgeEncountered(age);
            }
        }
        this.domainSuffix = this.context.getInitParameter(SSO_COOKIE_DOMAIN_SUFFIX_PARAM);
        this.whitelist = this.context.getInitParameter(SSO_COOKIE_TOKEN_WHITELIST_PARAM);
        if (this.whitelist == null) {
            this.whitelist = DEFAULT_WHITELIST;
        }
        if ((audiences = this.context.getInitParameter(SSO_COOKIE_TOKEN_AUDIENCES_PARAM)) != null) {
            this.targetAudiences = audiences.split(",");
        }
        if ((ttl = this.context.getInitParameter(SSO_COOKIE_TOKEN_TTL_PARAM)) != null) {
            try {
                this.tokenTTL = Long.parseLong(ttl);
            }
            catch (NumberFormatException nfe) {
                log.invalidTokenTTLEncountered(ttl);
            }
        }
        String enableSession = this.context.getInitParameter(SSO_ENABLE_SESSION_PARAM);
        this.enableSession = "true".equals(enableSession);
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    public Response doGet() {
        return this.getAuthenticationToken(307);
    }

    @POST
    @Produces(value={"application/json", "application/xml"})
    public Response doPost() {
        return this.getAuthenticationToken(303);
    }

    private Response getAuthenticationToken(int statusCode) {
        HttpSession session;
        GatewayServices services = (GatewayServices)this.request.getServletContext().getAttribute("org.apache.hadoop.gateway.gateway.services");
        boolean removeOriginalUrlCookie = true;
        String original = this.getCookieValue(this.request, ORIGINAL_URL_COOKIE_NAME);
        if (original == null) {
            removeOriginalUrlCookie = false;
            original = this.getOriginalUrlFromQueryParams();
            if (original.isEmpty()) {
                log.originalURLNotFound();
                throw new WebApplicationException("Original URL not found in the request.", Response.Status.BAD_REQUEST);
            }
            boolean validRedirect = RegExUtils.checkWhitelist((String)this.whitelist, (String)original);
            if (!validRedirect) {
                log.whiteListMatchFail(original, this.whitelist);
                throw new WebApplicationException("Original URL not valid according to the configured whitelist.", Response.Status.BAD_REQUEST);
            }
        }
        JWTokenAuthority ts = (JWTokenAuthority)services.getService("TokenService");
        Principal p = this.request.getUserPrincipal();
        try {
            JWT token = null;
            if (this.targetAudiences == null || this.targetAudiences.length == 0) {
                token = ts.issueToken(p, "RS256", this.getExpiry());
            } else {
                ArrayList<String> aud = new ArrayList<String>();
                for (int i = 0; i < this.targetAudiences.length; ++i) {
                    aud.add(this.targetAudiences[i]);
                }
                token = ts.issueToken(p, aud, "RS256", this.getExpiry());
            }
            if (token != null) {
                this.addJWTHadoopCookie(original, token);
            }
            if (removeOriginalUrlCookie) {
                this.removeOriginalUrlCookie(this.response);
            }
            log.aboutToRedirectToOriginal(original);
            this.response.setStatus(statusCode);
            this.response.setHeader("Location", original);
            try {
                this.response.getOutputStream().close();
            }
            catch (IOException e) {
                log.unableToCloseOutputStream(e.getMessage(), Arrays.toString(e.getStackTrace()));
            }
        }
        catch (TokenServiceException e) {
            log.unableToIssueToken((Exception)((Object)e));
        }
        URI location = null;
        try {
            location = new URI(original);
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        if (!this.enableSession && (session = this.request.getSession(false)) != null) {
            session.invalidate();
        }
        return Response.seeOther((URI)location).entity((Object)("{ \"redirectTo\" : " + original + " }")).build();
    }

    private String getOriginalUrlFromQueryParams() {
        String original = this.request.getParameter(ORIGINAL_URL_REQUEST_PARAM);
        StringBuffer buf = new StringBuffer(original);
        Map params = this.request.getParameterMap();
        for (Map.Entry entry : params.entrySet()) {
            if (ORIGINAL_URL_REQUEST_PARAM.equals(entry.getKey()) || original.contains((String)entry.getKey() + "=")) continue;
            buf.append("&").append((String)entry.getKey());
            String[] values = (String[])entry.getValue();
            if (values.length > 0 && values[0] != null) {
                buf.append("=");
            }
            for (int i = 0; i < values.length; ++i) {
                if (values[0] == null) continue;
                buf.append(values[i]);
                if (i >= values.length - 1) continue;
                buf.append("&").append((String)entry.getKey()).append("=");
            }
        }
        return buf.toString();
    }

    private long getExpiry() {
        long expiry = 0L;
        expiry = this.tokenTTL == -1L ? -1L : System.currentTimeMillis() + this.tokenTTL;
        return expiry;
    }

    private void addJWTHadoopCookie(String original, JWT token) {
        log.addingJWTCookie(token.toString());
        Cookie c = new Cookie(this.cookieName, token.toString());
        c.setPath("/");
        try {
            String domain = Urls.getDomainName((String)original, (String)this.domainSuffix);
            if (domain != null) {
                c.setDomain(domain);
            }
            c.setHttpOnly(true);
            if (this.secureOnly) {
                c.setSecure(true);
            }
            if (this.maxAge != -1) {
                c.setMaxAge(this.maxAge);
            }
            this.response.addCookie(c);
            log.addedJWTCookie();
        }
        catch (Exception e) {
            log.unableAddCookieToResponse(e.getMessage(), Arrays.toString(e.getStackTrace()));
            throw new WebApplicationException("Unable to add JWT cookie to response.");
        }
    }

    private void removeOriginalUrlCookie(HttpServletResponse response) {
        Cookie c = new Cookie(ORIGINAL_URL_COOKIE_NAME, null);
        c.setMaxAge(0);
        c.setPath(RESOURCE_PATH);
        response.addCookie(c);
    }

    private String getCookieValue(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        String value = null;
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!name.equals(cookie.getName())) continue;
                value = cookie.getValue();
            }
        }
        if (value == null) {
            log.cookieNotFound(name);
        }
        return value;
    }
}

